<?php
/**
 * 목록보기 스킨.
 */
use mc\Board;

/**
 * 목록 분류형 출렷 기본 스킨.
 * @param \mc\Board $mc_board
 * @param array $params
 * @return array 검색폼에서 넘겨야할 파람제출.
 */
return function (Board $mc_board, array $params) {
    $inputs = $mc_board->getInputs();
    $config = $mc_board->getConfig();
    $search = array();
    echo '<div style="padding:4px 0;">';
    echo '<form>';
    echo '<input type="hidden" name="bo_table" value="' . $config['bo_table'] . '"/>';
    if (!empty($params['sca'])) {
        echo '<input type="hidden" name="sca" value="' . $params['sca'] . '"/>';
    }
    foreach ($inputs as $input) {
        if(!$input->searchable) continue;
        $input->submit = true;
        $input->required = false;
        if ($input->type === 'radio') {
            $input->type = 'select';
        }
        if (isset($params[$input->name]) && $params[$input->name] !== '') {
            $input->value = htmlspecialchars($params[$input->name]);
            $search[$input->name] = $input->value;
        }
        echo '<span style="display:inline-block;padding:4px;background:#ddd;;margin:4px;line-height:100%;border:1px #999 solid;">';
        echo '<span style="display:inline-block;vertical-align:middle">', $input->title, ' : </span> ';
        $input->render();
        /*
        if ($input->type === 'checkbox') {
            $op = array('or' => '또는', 'and' => '그리고');
            $op_name = $input->name . '_op';
            echo '<select name="' . $op_name . '" onchange="this.form.submit()">';
            foreach ($op as $k => $v) {
                $selected = $k === $params[$op_name] ? ' selected="selected"' : '';
                echo '<option value="' . $k . '" ' . $selected . '>', $v, '</option>';
            }
            echo '</select>';
        }
        */
        echo '</span>';
    }
    //echo '<button type="button" class="btn_submit" onclick="mcApi.resetSubmit(this)">초기화</button>';
    echo '</form>';
    echo '</div>';
    return $search;
};
