(function (window, $) {

    var api = {};

    api.handleCheck = function (obj, asSubmit) {
        var elm = $(obj);
        var values = [];
        var input = $(':input[name=' + elm.data('input') + ']');
        var type = elm.attr('type');
        var value = elm.val();
        if (type === 'radio') {
            $(":checked." + elm.data('id')).not(function () {
                return this.value == value;
            }).prop('checked', false);
            input.val(value);
        } else if (type === 'checkbox') {
            $(":checked." + elm.data('id')).each(function () {
                values.push($(this).val());
            });
            input.val(values.length? '..'+values.join('.'):'');
        }
        if (asSubmit) {
            if (obj.form) {
                obj.form.submit();
            } else {
                alert('form 이 없습니다.');
            }
        }
    };

    api.resetSubmit = function(obj){
      if(obj.form){
          var f = $(obj.form);
          f.find(':input').not(":hidden").val("");
          obj.form.submit();
      }
    };
    /**
     *  셀렉트박스 변경 핸들러
     * @param obj
     * @returns {boolean|void}
     */
    api.handleSelect = function (obj, asSubmit) {
        var sel = $(obj);
        if (obj.tagName !== 'SELECT') {
            return false;
        }
        var val = sel.val();
        var data = sel.data();
        var input = $('#input-' + data.id);
        var next_el;
        for (var i = data.maxNo; i > data.no; i--) {
            next_el = $('#' + data.id + '--' + i);
            next_el.find('option').not(function () {
                return $(this).val() === '';
            }).remove();
            next_el.prop('disabled', true);
        }
        if (data.no > 0 && val === '') {
            input.val($('#' + data.id.split('--')[0] + '--' + (data.no - 1)).val());
        } else {
            input.val(val);
        }
        if (asSubmit) {
            if (obj.form) {
                // 리스트 인경우 검색시 필터링 유지
                var search_form = $('form[name=fsearch]');
                if(search_form.length && search_form.find('input[name=stx]').val()!=''){
                    var s_inputs = ($(obj.form).serializeArray());
                    if(s_inputs.length){
                        for(var k=0;k<s_inputs.length;k++){
                            var inp = search_form.find(":input[name="+s_inputs[k].name+"]");
                            if(!inp.length) {
                                inp = $('<input type="hidden" name="' + s_inputs[k].name + '">').appendTo(search_form);
                            }
                            inp.val(s_inputs[k].value);
                        }
                        search_form.submit();
                    }
                }else {
                    obj.form.submit();
                }
            } else {
                alert('form 이 없습니다.');
            }
        } else if (next_el) {
            var send_data = {column: data.column}
            send_data[data.column] = val;
            send_data['root']= data.root;
            $.ajax({
                url: g5_url + "/plugin/mc/ajax.php",
                data: send_data,
                type: "get",
                cache: false,
                dataType: "json",
                success: function (res) {
                    console.log(res);
                    if (res.data) {
                        var length = res.data.length;
                        if (length > 0) {
                            next_el.prop('disabled', false);
                            next_el.find("option").not(function () {
                                return $(this).val() === "";
                            }).remove();
                            for (var i = 0; i < length; i++) {
                                var value = res.data[i][data.column];
                                if(res.root_path){
                                    value = value.substring(res.root_path.length);
                                }
                                next_el.append('<option value="' + value + '">' + res.data[i].title + '</option>');
                            }
                            if(next_el.data('required')){
                                next_el.prop('required', true);
                            }
                        } else {
                            next_el.prop('disabled', true);
                            if(next_el.data('required')){
                                next_el.prop('required', false);
                            }
                        }
                    }
                }
            });
        }
        return false;
    };

    $(function () {
        var container = $("#anc_bo_extra");
        var tds = container.find(".td_extra");
        var trs = tds.closest("tr");

        var inputs = $('<input type="checkbox"/>').appendTo(tds);
        inputs.on('click', function () {
            var input = $(this);
            var label = input.closest('tr').children(".row");

            if (this.checked) {
                alert(this.checked);
            }
        });
    });

    window.mcApi = api;
})(window, jQuery);