<?php
use Restserver\Libraries\REST_Controller;
use Restserver\Libraries\REST_Controller_Definitions;
defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/REST_Controller_Definitions.php';
require APPPATH . 'libraries/Format.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Gnuboard extends CI_Controller {
    use REST_Controller {
        REST_Controller::__construct as private __resTraitConstruct;
    }
    function __construct() {
        parent::__construct();
        $this->__resTraitConstruct();
        $api_time = 5; //접근 제한
        $api_limit = 5; //제한에 걸렸을 경우 해당 시간이 지난 후 다시 접근 가능(단위 초);

        $this->methods['index_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['index_get']['time'] = $api_time; //시간
        $this->methods['content_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['content_get']['time'] = $api_time; //시간
        $this->methods['board_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_get']['time'] = $api_time; //시간
        $this->methods['board_post']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_post']['time'] = $api_time; //시간
        $this->methods['visit_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['visit_get']['time'] = $api_time; //시간
        
        $data = [];
    }
    public function index_get()
    {
        $write_prefix = $this->config->item('g5_table_prefix');
        $config_table = "{$write_prefix}config";
        $this->load->database();
        
        $sql = "SELECT cf_title, cf_admin, cf_visit FROM {$config_table}";
        $query = $this->db->query($sql, array('0'));
        foreach ($query->result() as $row){
            $data[] = $row;
        }
        if($data){
            $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
        }else{
            $this->response([
                'status' => false,
                'message' => '그누보드가 정상적으로 설치되어있지 않습니다.'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }
    public function content_get()
    {
        $write_prefix = $this->config->item('g5_table_prefix');
        $co_id = $this->get('co_id');
        $content_table = "{$write_prefix}content";
        $this->load->database();
        if($co_id){
            $sql = "SELECT co_id, co_subject, co_content FROM {$content_table} WHERE co_id = ?";
            $query = $this->db->query($sql, array($co_id));
            foreach ($query->result() as $row){
                $data[] = $row;
            }
            if($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }else{
                $this->response([
                    'status' => false,
                    'message' => '그누보드가 정상적으로 설치되어있지 않습니다.'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }    
        }
        $sql = "SELECT co_id, co_subject, co_content FROM {$content_table}";
        $query = $this->db->query($sql, array('0'));
        foreach ($query->result() as $row){
            $data[] = $row;
        }
        if($data){
            $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
        }else{
            $this->response([
                'status' => false,
                'message' => '그누보드가 정상적으로 설치되어있지 않습니다.'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }
    public function board_get()
    {
        $mb_id = $this->get('mb_id');
        $bo_table = $this->get('bo_table');
        $limit = $this->get('limit');
        $limit = ($limit) ? $limit : 10;
        $page = $this->get('page');
        $page = ($page) ? ($page) : 0;
        if($page>1){
            $page = ($page*$limit)-($limit-1);
        }
        $LIMIT = "LIMIT {$page}, {$limit}";
        
        $write_prefix = $this->config->item('g5_table_prefix');
        $write_table = "{$write_prefix}write_{$bo_table}";
        $this->load->database();
        $data = [];
        if ($mb_id === null && $bo_table === null) //그냥 주소만 쳤을때
        {
            $write_table = "{$write_prefix}board"; //아무값도 없으면 baord db 출력
            $sql = "SELECT bo_table, bo_subject FROM {$write_table}";
            $query = $this->db->query($sql, array('0'));
            $data = [];
            foreach ($query->result() as $row){
                    $data[] = $row;
            }
            if ($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' => '정상적인 호출이 아닙니다.'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }
        if($mb_id !== null && $bo_table === null){ //mb_id값만 들어왔을때
             $this->response([
                'status' => false,
                'message' => 'bo_table값을 입력해주세요'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
        if($mb_id === null && $bo_table !== null){ //bo_table값만 들어왔을때
            $sql = "SELECT * FROM {$write_table} WHERE wr_is_comment = ? order by wr_id desc {$LIMIT}";
            $query = $this->db->query($sql, array('0'));
            $data = [];
            foreach ($query->result() as $row){
                    $row->wr_password = ''; //보안문제로 제거
                    $data[] = $row;
            }
            if ($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' => '데이터가 없습니다'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
       }
        if($mb_id && $bo_table) { //정상적으로 값이 들어왔을때 
            $write_table = "{$write_prefix}write_free"; //아무값도 없으면 free 게시판의 데이터를 10개 출력
            $sql = "SELECT * FROM {$write_table} WHERE mb_id = ? AND wr_is_comment = ? order by wr_id desc {$LIMIT}";
            $query = $this->db->query($sql, array($mb_id, '0'));
            $data = [];
            foreach ($query->result() as $row){
                    $row->wr_password = ''; //보안문제로 제거
                    $data[] = $row;
            }
            if ($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' => '데이터가 없습니다'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }
    }
    public function board_post()
    {
        $mb_id = $this->post('mb_id');
        $bo_table = $this->post('bo_table');
        $limit = $this->post('limit');
        $limit = ($limit) ? $limit : 10;
        $page = $this->post('page');
        $page = ($page) ? ($page) : 0;
        if($page>1){
            $page = ($page*$limit)-($limit-1);
        }
        $LIMIT = "LIMIT {$page}, {$limit}";
        
        $write_prefix = $this->config->item('g5_table_prefix');
        $write_table = "{$write_prefix}write_{$bo_table}";
        $this->load->database();
        $data = [];
        if ($mb_id === null && $bo_table === null) //그냥 주소만 쳤을때
        {
            $write_table = "{$write_prefix}board"; //아무값도 없으면 baord db 출력
            $sql = "SELECT bo_table, bo_subject FROM {$write_table}";
            $query = $this->db->query($sql, array('0'));
            $data = [];
            foreach ($query->result() as $row){
                    $row->wr_password = ''; //보안문제로 제거
                    $data[] = $row;
            }
            if ($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' => '정상적인 호출이 아닙니다.'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }
        if($mb_id !== null && $bo_table === null){ //mb_id값만 들어왔을때
             $this->response([
                'status' => false,
                'message' => 'bo_table값을 입력해주세요'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
        if($mb_id && $bo_table) { //정상적으로 값이 들어왔을때 
            $write_table = "{$write_prefix}write_free"; //아무값도 없으면 free 게시판의 데이터를 10개 출력
            $sql = "SELECT * FROM {$write_table} WHERE mb_id = ? AND wr_is_comment = ? order by wr_id desc {$LIMIT}";
            $query = $this->db->query($sql, array($mb_id, '0'));
            $data = [];
            foreach ($query->result() as $row){
                    $data[] = $row;
            }
            if ($data){
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' => '데이터가 없습니다'
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }
    }
    //방문자수
    public function visit_get()
    {
        $limit = $this->get('limit');
        $limit = ($limit) ? $limit : 10;
        $page = $this->get('page');
        $page = ($page) ? ($page) : 0;
        if($page>1){
            $page = ($page*$limit)-($limit-1);
        }
        $LIMIT = "LIMIT {$page}, {$limit}";
        
        $write_prefix = $this->config->item('g5_table_prefix');
        $visit_table = "{$write_prefix}visit_sum";
        $this->load->database();
        $data = [];
        $sql = "SELECT * FROM {$visit_table} order by vs_date desc {$LIMIT}";
        $query = $this->db->query($sql);
        $data = [];
        foreach ($query->result() as $row){
                $data[] = $row;
        }
        if ($data){
            $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
        }
        else{
            $this->response([
                'status' => false,
                'message' => '정상적인 호출이 아닙니다.'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }
    //로그인 연동
    public login_post(){
        $mb_id = $this->get('mb_id');
        $password = $this->get('password');
        $member_table = "{$write_prefix}member";
        $this->load->database();
        $data = [];
        $sql = "SELECT * FROM {$member_table} WHERE mb_id = ? AND password = password(?)";
        $query = $this->db->query($sql, array($mb_id, $password));
        $data = [];
        foreach ($query->result() as $row){
            $data[] = $row;
        }
        if ($data){
            $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
        }
        else{
            $this->response([
                'status' => false,
                'message' => '정상적인 호출이 아닙니다.'
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }
}