<?php
use Restserver\Libraries\REST_Controller;
use Restserver\Libraries\REST_Controller_Definitions;
defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/REST_Controller_Definitions.php';
require APPPATH . 'libraries/Format.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Login extends CI_Controller {
    use REST_Controller {
        REST_Controller::__construct as private __resTraitConstruct;
    }
    function __construct() {
        parent::__construct();
        $this->__resTraitConstruct();
        $this->load->config('gnu_config');
        $api_time = 5; //접근 제한
        $api_limit = 5; //제한에 걸렸을 경우 해당 시간이 지난 후 다시 접근 가능(단위 초);

        $this->methods['index_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['index_get']['time'] = $api_time; //시간
        $this->methods['content_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['content_get']['time'] = $api_time; //시간
        $this->methods['board_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_get']['time'] = $api_time; //시간
        $this->methods['board_post']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_post']['time'] = $api_time; //시간
        $this->methods['visit_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['visit_get']['time'] = $api_time; //시간
        
        $data = [];
    }

    public function index_post()
    {
        $data = [];
        $mb_id = $this->post('mb_id');
        $mb_password = $this->post('password');

        $login_check = json_decode(login_password_check($mb_id, $mb_password, $this->config->item('base_url')));
        //$msg = $login_check->message;
        if($login_check->status=="success"){
            $sql = "SELECT * FROM {$member_table} WHERE mb_id = ?";
            //$query = $this->db->query($sql, array($mb_id, $password));
            $query = $this->db->query($sql, array($mb_id));
            $data = [];
            foreach ($query->result() as $row){
                $data = $row;
            }
            if ($data){
                $data->mb_password = ''; //패스워드는 제공하지 않음
                $this->response($data, REST_Controller_Definitions::HTTP_OK); // OK (200) being the HTTP response code
            }
            else{
                $this->response([
                    'status' => false,
                    'message' =>  $login_check->message
                ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }else{
            $this->response([
                'status' => false,
                'message' =>  $login_check->message
            ], REST_Controller_Definitions::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }
    
}