<?php
use Restserver\Libraries\REST_Controller;
use Restserver\Libraries\REST_Controller_Definitions;
defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/REST_Controller_Definitions.php';
require APPPATH . 'libraries/Format.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Write extends CI_Controller {
    use REST_Controller {
        REST_Controller::__construct as private __resTraitConstruct;
    }
    function __construct() {
        parent::__construct();
        $this->__resTraitConstruct();
        $this->load->config('gnu_config');
        $api_time = 5; //접근 제한
        $api_limit = 5; //제한에 걸렸을 경우 해당 시간이 지난 후 다시 접근 가능(단위 초);

        $this->methods['index_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['index_get']['time'] = $api_time; //시간
        $this->methods['content_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['content_get']['time'] = $api_time; //시간
        $this->methods['board_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_get']['time'] = $api_time; //시간
        $this->methods['board_post']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['board_post']['time'] = $api_time; //시간
        $this->methods['visit_get']['limit'] = $api_limit; //일일 호출 갯수 제한
        $this->methods['visit_get']['time'] = $api_time; //시간
        
        $data = [];
    }

    public function index_post()
    {
        $this->load->library('Gnu_write'); //글쓰기 라이브러리 불러옴
        $data = [];
        $post = new stdClass();
        $post->mb_id = $this->post('mb_id');
        $post->mb_password = $this->post('mb_password');
        $post->bo_table = $this->post('bo_table');
        $post->wr_content = $this->post('wr_content'); //내용
        $post->wr_subject = $this->post('wr_subject'); //제목
        $post->ca_name = $this->post('ca_name'); //카테코리

        //html, 비밀글, 메일 사용 여부
        $post->html = $this->post('html'); 
        $post->secret = $this->post('secret'); 
        $post->mail = $this->post('mail'); 

        //링크 여부
        $post->wr_link1 = $this->post('wr_link1'); 
        $post->wr_link2 = $this->post('wr_link2'); 

        //작성자항목
        $post->wr_password = $this->post('wr_password'); 
        $post->wr_name = $this->post('wr_name'); 
        $post->wr_email = $this->post('wr_email'); 
        $post->wr_homepage = $this->post('wr_homepage'); 

        //여분필드
        $post->wr_1 = $this->post('wr_1');
        $post->wr_2 = $this->post('wr_2');
        $post->wr_3 = $this->post('wr_3');
        $post->wr_4 = $this->post('wr_4');
        $post->wr_5 = $this->post('wr_5');
        $post->wr_6 = $this->post('wr_6');
        $post->wr_7 = $this->post('wr_7');
        $post->wr_8 = $this->post('wr_8');
        $post->wr_9 = $this->post('wr_9');
        $post->wr_10 = $this->post('wr_10');

        $result = json_decode($this->gnu_write->insert_write($post));
        if($result->status==true){
            $HTTP_RESPOND = REST_Controller_Definitions::HTTP_OK;
        }else{
            $HTTP_RESPOND = REST_Controller_Definitions::HTTP_NOT_FOUND;
        }
        $this->response([
            'status' => $result->status,
            'message' =>  $result->message
        ], $HTTP_RESPOND); // NOT_FOUND (404) being the HTTP response code
    }
    
}