<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Gnu_write {

    use PBKDF2; //암호화

    protected $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->database();
        $this->CI->load->config('gnu_config'); //그누 기본변수불러옴
    }
    public function insert_write($post)
    {
        $bo_table = trim($post->bo_table);
        $write_prefix = $this->CI->config->item('g5_table_prefix');
        $board_table = "{$write_prefix}board";
        if(!strlen($bo_table)) 
            return '{"status" : "false", "message" : "테이블 값을 입력해주세요"}';

        $sql = "SELECT * FROM {$board_table} WHERE bo_table = '{$bo_table}'";
        $board = $this->CI->db->query($sql)->result()[0];   //board 설정값을 불러옴
        if(!$board->bo_table)  //테이블이 없을때
            return '{"status" : "false", "message" : "입력하신 테이블 값이 존재하지 않습니다"}';

        if ($post->ca_name && strpos($board->bo_category_list, $post->ca_name) === FALSE){ //카테코리 처리
            $category_list = $board->bo_category_list."|".$post->ca_name;
            $sql = " update {$board_table} set bo_category_list = '$category_list' where bo_table = '$bo_table' ";
            $this->CI->db->query($sql);
        }
        
        $login_check = json_decode(login_password_check($post->mb_id, $post->mb_password, $this->CI->config->item('base_url')));

        if($login_check->status=="success"){ //로그인 성공
            $member = $this->get_member($post->mb_id);
            if ($member->mb_level < $board->bo_write_level) {
                return '{"status" : "false", "message" : "글을 쓸 권한이 없습니다"}';
            }
        }
        else{ //실패
            if (1 < $board->bo_write_level) { //로그인이 안되었을 경우 1레벨
                return '{"status" : "false", "message" : "글을 쓸 권한이 없습니다"}';
            }
            $post->wr_password = $post->mb_password; //회원이 아니고, 
            $member = new stdClass();
            $member->mb_id = '';
        }

        if ($member->mb_id!='') {
            $post->mb_id = $member->mb_id;
            $post->wr_name = addslashes($this->clean_xss_tags($board->bo_use_name ? $member->mb_name : $member->mb_nick));
            $post->wr_password = '';
            $post->wr_email = addslashes($member->mb_email);
            $post->wr_homepage = addslashes($this->clean_xss_tags($member->mb_homepage));
        } else {
            $post->mb_id = '';
            // 비회원의 경우 이름이 누락되는 경우가 있음
            if (!$post->wr_name)
                return '{"status" : "false", "message" : "이름은 필히 입력하셔야 합니다"}';
            $post->wr_name = $this->clean_xss_tags(trim($post->wr_name));
            $post->wr_password = $this->get_encrypt_string($post->wr_password);
            if($post->wr_email) //이메일 값이 있으면 이메일 형식 검사
                $post->wr_email = $this->get_email_address(trim($post->wr_email));
            if($post->wr_homepage) //홈페이지 값이 있으면 검사
                $post->wr_homepage = $this->clean_xss_tags($wr_homepage);
        }

        $write_table = "{$write_prefix}write_{$bo_table}";
        $wr_num = $this->get_next_num($write_table);

        $post->wr_subject = addslashes(substr(trim($post->wr_subject),0,255));
        $post->wr_content = addslashes(substr(trim($post->wr_content),0,65535));

        $post->wr_link1 = substr($post->wr_link1, 0,1000);
        $post->wr_link1 = trim(strip_tags($post->wr_link1));
        $post->wr_link1 = preg_replace("#[\\\]+$#", "", $post->wr_link1);

        $post->wr_link2 = substr($post->wr_link2, 0,1000);
        $post->wr_link2 = trim(strip_tags($post->wr_link2));
        $post->wr_link2 = preg_replace("#[\\\]+$#", "", $post->wr_link2);



        if (substr_count($post->wr_content, '&#') > 50) {
            return '{"status" : "false", "message" : "내용에 올바르지 않은 코드가 다수 포함되어 있습니다"}';
        }
        if (!$board->bo_use_secret && (stripos($post->html, 'secret') !== false || stripos($post->secret, 'secret') !== false || stripos($post->mail, 'secret') !== false)) {
            return '{"status" : "false", "message" : "비밀글 미사용 게시판 이므로 비밀글로 등록할 수 없습니다"}';
        }        

        if($post->wr_subject=='')
            return '{"status" : "false", "message" : "글 제목이 없습니다"}';
        if($post->wr_content=='')
            return '{"status" : "false", "message" : "글 내용이 없습니다"}';
        //글 입력
        $sql = " insert into {$write_table}
        set wr_num = '{$wr_num}',
            wr_reply = '',
            wr_comment = 0,
            ca_name = '$post->ca_name',
            wr_option = '$post->html,$post->secret,$post->mail',
            wr_subject = '$post->wr_subject',
            wr_content = '$post->wr_content',
            wr_link1 = '$post->wr_link1',
            wr_link2 = '$post->wr_link2',
            wr_link1_hit = 0,
            wr_link2_hit = 0,
            wr_hit = 0,
            wr_good = 0,
            wr_nogood = 0,
            mb_id = '$post->mb_id',
            wr_password = '$post->wr_password',
            wr_name = '$post->wr_name',
            wr_email = '$post->wr_email',
            wr_homepage = '$post->wr_homepage',
            wr_datetime = '".G5_TIME_YMDHIS."',
            wr_last = '".G5_TIME_YMDHIS."',
            wr_ip = '{$_SERVER['REMOTE_ADDR']}',
            wr_1 = '$post->wr_1',
            wr_2 = '$post->wr_2',
            wr_3 = '$post->wr_3',
            wr_4 = '$post->wr_4',
            wr_5 = '$post->wr_5',
            wr_6 = '$post->wr_6',
            wr_7 = '$post->wr_7',
            wr_8 = '$post->wr_8',
            wr_9 = '$post->wr_9',
            wr_10 = '$post->wr_10' ";
        $this->CI->db->query($sql);

        $wr_id = $this->CI->db->insert_id();

        $sql = "update {$write_table} set wr_parent = '{$wr_id}' where wr_id = '{$wr_id}'"; //부모 아이디에 UPDATE
        $this->CI->db->query($sql);
        $board_new = "{$write_prefix}board_new";
        $sql = "insert into {$board_new} ( bo_table, wr_id, wr_parent, bn_datetime, mb_id ) values ( '{$bo_table}', '{$wr_id}', '{$wr_id}', '".G5_TIME_YMDHIS."', '{$post->mb_id}' )"; //새글 INSERT    
        $this->CI->db->query($sql);
        $sql = "update {$board_table} set bo_count_write = bo_count_write + 1 where bo_table = '{$bo_table}'"; //게시글 1 증가
        $this->CI->db->query($sql);
        
        return '{"status" : "true", "message" : "글 쓰기에 성공하였습니다"}';
    }
    // 게시판의 다음글 번호를 얻는다.
    public function get_next_num($table)
    {
        // 가장 작은 번호를 얻어
        $sql = "SELECT min(wr_num) as min_wr_num FROM {$table}";
        $row = $this->CI->db->query($sql)->result()[0];
        // 가장 작은 번호에 1을 빼서 넘겨줌
        return (int)($row->min_wr_num - 1);
    } 
    public function get_member($mb_id)
    {
        $write_prefix = $this->CI->config->item('g5_table_prefix');
        $member_table = "{$write_prefix}member";
        $sql = "SELECT * FROM {$member_table}";
        $row = $this->CI->db->query($sql)->result()[0];
        return $row;
    }    
    public function clean_xss_tags($str, $check_entities=0)
    {
        $str_len = strlen($str);
        
        $i = 0;
        while($i <= $str_len){
            $result = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $str);
            
            if( $check_entities ){
                $result = str_replace(array('&colon;', '&lpar;', '&rpar;', '&NewLine;', '&Tab;'), '', $result);
            }

            if((string)$result === (string)$str) break;

            $str = $result;
            $i++;
        }

        return $str;
    }
    public function get_email_address($email)
    {
        preg_match("/[0-9a-z._-]+@[a-z0-9._-]{4,}/i", $email, $matches);

        return $matches[0];
    }
    public function get_encrypt_string($pass){
        if(G5_GNUBOARD_VER>=5.4 && G5_STRING_ENCRYPT_FUNCTION=="create_hash"){
            return $encrypt = $this->create_hash($pass);
        }else{
            $sql = "SELECT  password('$pass') as pass";
            $row = $this->CI->db->query($sql)->result()[0];
            return $row->pass;
        }
        return false;
    }
}

@require "../lib/pbkdf2.compat.php";
trait PBKDF2{
    public function create_hash($password, $force_compat = false)
    {
        if (function_exists('mcrypt_create_iv')) {
            $salt = base64_encode(mcrypt_create_iv(PBKDF2_COMPAT_SALT_BYTES, MCRYPT_DEV_URANDOM));
        } elseif (@file_exists('/dev/urandom') && $fp = @fopen('/dev/urandom', 'r')) {
            $salt = base64_encode(fread($fp, PBKDF2_COMPAT_SALT_BYTES));
        } else {
            $salt = '';
            for ($i = 0; $i < PBKDF2_COMPAT_SALT_BYTES; $i += 2) {
                $salt .= pack('S', mt_rand(0, 65535));
            }
            $salt = base64_encode(substr($salt, 0, PBKDF2_COMPAT_SALT_BYTES));
        }

        $algo = strtolower(PBKDF2_COMPAT_HASH_ALGORITHM);
        $iterations = PBKDF2_COMPAT_ITERATIONS;
        if ($force_compat || !function_exists('hash_algos') || !in_array($algo, hash_algos())) {
            $algo = false;                         // This flag will be detected by pbkdf2_default()
            $iterations = round($iterations / 5);  // PHP 4 is very slow. Don't cause too much server load.
        }
        
        $pbkdf2 = pbkdf2_default($algo, $password, $salt, $iterations, PBKDF2_COMPAT_HASH_BYTES);
        $prefix = $algo ? $algo : 'sha1';
        return $prefix . ':' . $iterations . ':' . $salt . ':' . base64_encode($pbkdf2);
    }
}