<?php
/**
 * GPF 관리자 > GPF 설정
 *
 * @package GPF
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 * @since 2.0.0
 */
include_once "_common.php";

$g5['title'] = 'GPF 설정';

$gpa_page_id = str_replace('.php', '', basename(__FILE__));

if ($md == 'save_api_key') {
    if (!$api_key) {
        @unlink(GP_API_KEY_FILE);
        alert('삭제하였습니다.', $_SERVER['SCRIPT_NAME'] . gp_uparam());
    }
    $url = gp_api_url('check_api_key', array('new_key' => $api_key));
    list($code, $header, $res) = gp_http_get($url);
    if ($code != 200)
        alert('러블리어스에 연결할 수 없습니다. (' . $code . ')');
    $json = json_decode($res, true);
    if ($json['code'] == -1)
        alert('사용할 수 없는 키입니다.');

    _gp_write_config(GP_API_KEY_FILE, $api_key);
    alert('저장하였습니다.', $_SERVER['SCRIPT_NAME'] . gp_uparam());
    exit;
}

if ($md == 'save_app_url') {
    if (!$app_url) {
        @unlink(GP_APP_URL_FILE);
        alert('삭제하였습니다.', $_SERVER['SCRIPT_NAME'] . gp_uparam());
    }
    _gp_write_config(GP_APP_URL_FILE, $app_url);
    alert('저장하였습니다.', $_SERVER['SCRIPT_NAME'] . gp_uparam());
    exit;
}


$gpf_api_key = _gp_read_config(GP_API_KEY_FILE, $default_data = '');
$gpf_app_url = _gp_read_config(GP_APP_URL_FILE, $default_data = '');

include_once GP_ADMIN_PATH . '/head.php';
?>
<h2>GPF 설정</h2>

<h3>API 키</h3>
<p>
    플러그인 원격 설치를 위해 GPF API 키가 필요합니다. <br/>
    API 키는 <a href="http://lovelyus.net">러블리어스</a>의 마이페이지에서 생성할 수 있습니다.<br/>
<form name="keyfrm" method="post" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>">
    <input type="hidden" name="md" value="save_api_key"/>
    <input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
    <input type="hidden" name="gr_id" value="<?php echo $gr_id; ?>">
    GPF API Key <input type="text" name="api_key" class="frm_input" value="<?php echo htmlspecialchars($gpf_api_key); ?>" style="width:400px" />
    <span class="btn_confirm">
        <input type="submit" value=" 설정 " class="btn_submit"/>
    </span>
</form>
</p>

<h3>GPF 앱 URL</h3>
<p>
    GPF 앱 URL 은 "[그누보드]/gp/a" 입니다.<br/>
    기본 URL 을 변경하시려면 "[그누보드]/gp/a" 디렉토리를 원하시는 곳으로 복사하시고 전체 URL 을 입력하세요.<br/>
<form name="aurlfrm" method="post" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>">
    <input type="hidden" name="md" value="save_app_url"/>
    <input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
    <input type="hidden" name="gr_id" value="<?php echo $gr_id; ?>">
    GPF APP URL <input type="text" name="app_url" class="frm_input" value="<?php echo htmlspecialchars($gpf_app_url); ?>" style="width:250px" />
    <span class="btn_confirm">
        <input type="submit" value=" 설정 " class="btn_submit"/>
    </span>
</form>
</p>


<?php
include_once GP_ADMIN_PATH . '/tail.php';
?>
