<?php
/**
 * GPF 테마 업그레이드 클래스
 *
 * 러블리어스 {@link http://lovelyus.net} 에서 테마를 다운받아
 * 설치 및 업그레이드 하거나, 로컬 테마를 삭제한다.
 *
 * @package GPF
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 * @since 5.1.0
 */
if (!defined("_GNUBOARD_"))
    exit; // 개별 페이지 접근 불가 

include_once dirname(__FILE__) . DS . 'class.upgrader.php';

/**
 * ThemeUpgrader
 * 
 * @uses GPUpgrader
 * @package GPF
 * @author Chongmyung Park <byfun@byfun.com> 
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 * @since 5.1.0
 */
class ThemeUpgrader extends GPUpgrader {

    /**
     * 테마 디렉토리명
     *
     * @var string
     * */
    var $theme;

    /**
     * 테마 버전
     *
     * @var string
     * */
    var $version;

    /**
     * 다운로드할 테마 파일명
     *
     * @var string
     * */
    var $filename;

    /**
     * 실행 모드
     *
     * @var string
     * */
    var $md;

    /**
     * __construct 
     * 
     * @access protected
     * @return void
     */
    function __construct() {
        global $md, $theme, $version, $filename;
        if (!$theme)
            alert('잘못된 연결');
        parent::__construct();
        $this->basic_info = array_merge($this->basic_info, compact('theme', 'version'));
        $this->md = $md;
        $this->theme = $theme;
        $this->version = $version;
        $this->filename = $filename;
    }

    /**
     * doit 
     *
     * <gp_admin>/updater.php 에서 호출하는 페이지로,
     * $md 값에 따라서 테마 설치, 업그레이드, 삭제 기능을 수행
     * 
     * @param string $md 실행모드
     * @access public
     * @return void
     */
    function doit($md) {
        $this->load_filemanager();

        if ($md == 'install')
            $this->installTheme();
        else if ($md == 'upgrade')
            $this->upgradeTheme();
        else if ($md == 'remove')
            $this->uninstallTheme();
        else
            alert('잘못된 연결 : ' . $md);
    }

    /**
     * installTheme
     *
     * 테마 설치
     *
     * 설치 프로세스
     *   1. 러블리어스에서 테마 파일 다운로드 : <g5>/data/gp/downloaded_theme/<THEME_FILE>.zip 에 저장
     *   2. 테마 압축 해제 : <g5>/data/gp/downloaded_theme/ 에 압축해제
     *   3. 업그레이드 모드 이면 기존의 테마 삭제
     *   4. 테마 복사 : <g5>/theme/<THEME> 로 이동
     *   5. 다운로드 데이터 삭제
     * 
     * @access public
     * @return void
     */
    function installTheme($is_upgrade = false) {
        @chmod(G5_DATA_PATH, 0777);
        @chmod(GP_DATA_PATH, 0777);
        @chmod($this->down_path, 0777);

        $this->flush('"' . $this->theme . '" 테마를 다운로드합니다.... ');
        $url = gp_api_url('download_theme', $this->basic_info);
        if (!$url)
            alert('API 키를 설정하신 후 사용하세요');
        $zip_file = $this->down_path . DS . $this->filename;
        @unlink($zip_file);
        list($code, $header, $res, $downloaded) = gp_http_download($url, $zip_file);
        if (!$downloaded) {
            $this->error(' [ 실패 - ' . $code . ' ] <br/>');
            $this->error('* ' . $res . '<br/>');
            $this->_tail();
            return;
        }
        $this->desc(' [ 완료 ] <br/>');

        $this->flush('테마 압축 파일을 풉니다....');
        $dirname = $this->unzip($zip_file, $this->down_path);
        $dirpath = $this->down_path . DS . $dirname;
        if ($dirname)
            $this->desc(' [ 완료 ] <br/>');
        else {
            $this->error(' [ 실패 ] <br/>');
            unlink($zip_file);
            $this->_tail();
            return;
        }

        if ($is_upgrade)
            $this->uninstallTheme($print_tail = false);

        $this->flush('테마를 테마 디렉토리로 이동합니다....');
        $target_path = G5_PATH .DS. G5_THEME_DIR . DS . $dirname;
        if (!$this->fs->mkdir($this->_remote_path($target_path)))
            alert('디렉토리 생성에 실패 하였습니다 : ' . $dirname, $this->backurl);
        $res = $this->copy_dir($dirpath, $target_path);
        if (!$res) {
            $this->error(' [ 실패 ]');
            unlink($zip_file);
            $this->_tail();
            return;
        }
        $this->remove_dir($dirpath);
        $this->desc(' [ 완료 ] <br/>');

        unlink($this->down_path . DS . $this->filename); // remove downloaded zip file
        $this->_tail();
    }

    /**
     * upgradeTheme
     *
     * 테마 업그레이드
     *
     * @access public
     * @return void
     */
    function upgradeTheme() {
        $this->installTheme($is_upgrade = true);
    }

    /**
     * uninstallTheme
     *
     * 테마 삭제
     *
     * 삭제 프로세스
     *   1. 테마 삭제 : <g5>/theme/<THEME> 삭제
     * 
     * @access public
     * @return void
     */
    function uninstallTheme($print_tail = true) {
        $this->flush('설치된 테마를 제거합니다....');
        $res = $this->fs->delete($this->_remote_path(G5_PATH.DS.G5_THEME_DIR .DS . $this->theme), true);
        if ($res)
            $this->desc(' [ 완료 ] <br/>');
        else {
            $this->error(' [ 실패 ] <br/>');
            $this->error('* 다음을 삭제할 수 없습니다 : ' . G5_PATH.DS.G5_THEME_DIR . DS . $this->theme . '<br/>');
        }

        if ($print_tail)
            $this->_tail();
    }

    /**
     * _tail 
     *
     * 프로세스 완료 후, 하단 메시지 출력
     * 
     * @access protected
     * @return void
     */
    function _tail() {
        global $md, $theme, $skin_type;
        
        @chmod(G5_DATA_PATH, 0707);
        @chmod(GP_DATA_PATH, 0707);
        @chmod($this->down_path, 0707);
        
        if($md != 'remove' && !$this->has_error) $this->flush('<br/>테마 정보 페이지로 이동합니다... ');
        
        $msg = '<br/><a href="theme_install.php?'. gp_uparam(TRUE) . '">테마 설치 페이지로 이동</a> | <a href="themes.php?' . gp_uparam(TRUE) . '">테마 목록 페이지로 이동</a>';
        $this->flush($msg);

        if($md != 'remove' && !$this->has_error) 
        {
            sleep(2);
            goto_url('themeinfo.php?theme='.$this->theme.'&'.gp_uparam(TRUE));
        }    
    }

}

?>
