<?php
/**
 *
 * 테마 정보
 *
 * @package GPF
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 * @since 5.1.0
 */
include_once '_common.php';

$gpa_page_id = 'themes';

include_once GP_ADMIN_PATH . DS . 'head.php';

$theme_content = file_get_contents(G5_PATH.DS.G5_THEME_DIR.DS.$theme.DS.'readme-gp.txt');
if(!$theme_content) alert('테마 정보 : 잘못된 연결', 'themes.php');

$theme_header = array(
    'Platform' => 'Platform',
    'Name' => 'Theme Name',
    'ThemeURI' => 'Theme URI',
    'Version' => 'Version',
    'Description' => 'Description',
    'Author' => 'Author',
    'AuthorURI' => 'Author URI',
    'License' => 'Theme License',
    'DonationURI' => 'Donation URI',
    'Tags' => 'Tags',
    'Required G5' => 'Required G5 Version',
    'Tested' => 'Tested up to'
);

foreach ($theme_header as $field => $regex) {
    if (preg_match('/^[ \t\/*#@]*' . preg_quote($regex, '/') . ':(.*)$/mi', $theme_content, $match) && $match[1]) {
        $theme_header[$field] = trim(preg_replace("/\s*(?:\*\/|\?>).*/", '', $match[1]));
        $theme_content = str_replace($match[0] . "\n", '', $theme_content);
    } else {
        if ($field == 'Platform' || $field == 'Name' || $field == 'Version' || $field == 'Description' || $field == 'Author') {
            alert("알림 : readme-gp.txt 의 테마 정보가 불충분합니다.");
            return;
        }
        $theme_header[$field] = '';
    }
}

$theme_codes = array();

include_once GP_ADMIN_PATH.DS.'lib'.DS.'markdown'.DS.'markdown.php';
$content = '<div class="markdown">' . Markdown($theme_content) . '</div>';

preg_replace_callback('/\[code\s?([\w]{0,})\](.*?)\[\/code\]/si', '_gp_save_code', $theme_content);
$content = preg_replace_callback('/\[code\s?([\w]{0,})\](.*?)\[\/code\]/si', '_gp_do_code_parse', $content);


?>
<br/>
<h1>테마 정보</h1>

<?php if($theme_header['DonationURI']) { ?>
<div class="gp_donation">
    <a href="<?php echo $theme_header['DonationURI']; ?>" class="gp_donation_btn" target="_blank">테마 후원하기</a>
    <div class="gp_donation_exp">
        더 좋은 소프트웨어 개발을 위해<br/> 개발자님을 후원해주세요.
    </div>
</div>
<?php } ?>

<div class="gp_section markdown">
    <ul>
        <li>테마명 : <strong><?php echo $theme_header['Name']; ?></strong></li>
        <li>테마위치 : G5/theme/<?php echo $theme; ?></li>
        <li>버전 : <?php echo $theme_header['Version']; ?></li>
        <li>저자 : <a href="<?php echo $theme_header['AuthorURI']; ?>" target="_blank"><?php echo $theme_header['Author']; ?></a></li>
        <?php if(isset($theme_header['ThemeURI'])) { ?><li>테마 사이트 : <a href="<?php echo $theme_header['ThemeURI']; ?>" target="_blank"><?php echo $theme_header['ThemeURI']; ?></a></li><?php } ?>
        <li>요구되는 최소 G5 버전 : <?php echo $theme_header['Required G5']; ?>
        <?php if ($theme_header['Tested'] > $theme_header['Required G5'])
            echo '<span style="margin-left:10px;color:#888">(' . $theme_header['Tested'] . '버전 까지 테스트되었습니다.)</span>';
        ?>
         </li>
        <?php if(isset($theme_header['License'])) { ?><li>라이선스 : <a href="<?php echo $theme_header['License']; ?>" target="_blank"><?php echo $theme_header['License']; ?></a></li><?php } ?>
    </ul>
</div>

<h1>테마 설명</h1>
<div class="gp_section">
    <?php echo $content; ?>
</div>

<div style="text-align:center;">
    <a href="themes.php<?php echo gp_uparam();?>">테마 목록</a> | <a href="theme_install.php<?php echo gp_uparam();?>">테마 설치</a>
</div>

<style>
    .gp_section{margin:0 0 30px 0;padding:10px;border:2px solid #eee;}
    .gp_donation{float:right;margin:10px;padding:10px;width:200px;text-align:center}
    .gp_donation_btn{display:inline-block;width:190px;font-weight: bold;height: 50px;cursor: pointer;border-radius: 5px 5px 5px 5px;line-height: 50px;background-color: #000;color: #fff500 !important;}
    .gp_donation_exp{margin-top:10px;color:#888;}
</style>
<link type="text/css" rel="stylesheet" href="<?php echo GP_ADMIN_URL ?>/css/markdown.css"/>
<script type="text/javascript" src="<?php echo GP_ADMIN_URL ?>/js/sh/scripts/shCore.js"></script>
<script type="text/javascript" src="<?php echo GP_ADMIN_URL ?>/js/sh/scripts/shBrushAll.js" ></script>
<link type="text/css" rel="stylesheet" href="<?php echo GP_ADMIN_URL ?>/js/sh/styles/shCore.css"/>
<link type="text/css" rel="stylesheet" href="<?php echo GP_ADMIN_URL ?>/js/sh/styles/shThemeDefault.css"/>
<script type="text/javascript">
    SyntaxHighlighter.config.clipboardSwf = '<?php echo GP_ADMIN_URL ?>/js/sh/scripts/clipboard.swf';
    SyntaxHighlighter.all();
</script>

<?php
include_once GP_ADMIN_PATH . DS . 'tail.php';


function _gp_save_code($matches) {
    global $theme_codes;
    array_push($theme_codes, $matches[2]);
}

function _gp_do_code_parse($matches) {
    global $theme_codes;
    $code = $theme_codes[0];
    $code = htmlspecialchars($code);
    array_shift($theme_codes);
    return "<pre class='brush: {$matches[1]}'>" . $code . "</pre>";
}
?>
