<?php
/**
 * GPF 관리자 > 테마 목록
 *
 * @package GPF
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 * @since 2.0.0
 */
include_once "_common.php";

$g5['title'] = '설치 테마 목록';

$gpa_page_id = str_replace('.php', '', basename(__FILE__));

include_once 'head.php';

if(!$is_theme_available) {
    alert('테마는 그누보드 5.1.0 이후부터 지원합니다.');
} else if(!file_exists(G5_PATH.DS.G5_THEME_DIR)) {
    alert('테마 디렉토리가 존재하지 않습니다.');
}

$themes = gp_themes();
$themes = gp_subval_asort($themes, 'dir');

?>
<h2>
    설치된 테마
    <span class="gpa_sub_link">
        <a href="theme_install.php?<?php echo gp_uparam(TRUE); ?>">테마 추가</a>
    </span>
</h2>

<div class="gpa_section">
    <ul>
        <li>테마 정보파일(readme-gp.txt)이 존재하지 않는 테마는 제외됩니다.</li>
    </ul>
</div>

<table class="gpa_table" cellspacing="0" cellpadding="0" border="0" width="100%">
    <colgroup><col width="160px"/><col/></colgroup>
    <thead>
        <tr>
            <th style="text-align:right">테마</th>
            <th>설명</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($themes as $theme) {
            $info = $theme['info'];
            if (!isset($info['Description']))
                $info['Description'] = '등록된 설명이 없습니다.';
            array_walk($info, create_function('&$value, $key', '$value = gp_get_text($value); if($key == "Description") $value = url_auto_link($value); '));
            ?>
            <tr>
                <th valign="top">
                    <a href="themeinfo.php?theme=<?php echo $theme['dir'];?><?php echo '&'.gp_uparam(true);?>"><span style="color:#222"><?php echo $info['Name']; ?></span></a>
                    <?php
                    $menus = array();
                    array_push($menus, array('href' => 'javascript:if(confirm(\'테마 파일이 모두 삭제됩니다.\\n삭제 하시겠습니까?\')) { location.href=\'' . gp_url(GP_ADMIN_URL . '/updater.php', $gp_scope, $noqm = false) . '&utarget=theme&md=remove&theme=' . $theme['dir'] . '&nocache=' . time() . '\';}', 'text' => '제거'));

                    $menus = gp_do_filter('gpa_theme_menu_' . $info['dir'], $menus);
                    ?>
        <ul>
            <?php
            foreach ($menus as $menu) {
                echo '<li><a href="' . $menu['href'] . '"' . $menu['attr'] . '>' . $menu['text'] . '</a></li>';
            }
            ?>
        </ul>
    </th>
    <td valign="top">
        <div class="gpa_desc">
            <?php echo $info['Description']; ?>
        </div>
        <div class="gpa_info">
            <?php if (isset($info['Version'])) { ?>
                버전 : <?php echo $info['Version']; ?> 
                <?php } ?>
                <?php if (isset($info['Author'])) { ?>
                | 저자 : <?php if (isset($info['AuthorURI'])) { ?><a href="<?php echo $info['AuthorURI']; ?>"><?php } ?>
                <?php echo $info['Author']; ?>
                <?php if (isset($info['AuthorURI'])) { ?></a><?php } ?>
            <?php } ?>
            <?php if (isset($info['ThemeURI'])) { ?>
                | <a href="<?php echo $info['ThemeURI']; ?>">테마사이트 방문</a>
            <?php } ?>
            <?php if (isset($info['DonationURI'])) { ?>
                | <a href="<?php echo $info['DonationURI']; ?>">테마 후원하기</a>
    <?php } ?>
        </div>
    </td>
    </tr>
<?php } ?>
<?php if (empty($themes)) { ?>
    <tr>
        <td colspan="2" height="100px" align="center" valign="middle">
            테마가 없습니다.
        </td>
    </tr>
<?php } ?>
</tbody>
</table>
<?php
include_once 'tail.php';
?>
