그누보드 플러그인 프레임워크
============================

그누보드 플러그인 프레임워크(Gnuboard Plugin Framework; GPF)는 그누보드로 운영되는 사이트에서 이벤트 기반의 프로그램을 개발하고 운영할 수 있도록 도와주는 프레임워크입니다. GPF를 설치하면 그누보드 관리자 페이지에 '플러그인' 메뉴가 생깁니다. GPF의 플러그인/스킨 관리는 이 '플러그인' 페이지에서 이루어집니다. GPF로 할 수 있는 일들을 정리하면 아래와 같습니다.

  - 손쉬운 플러그인/스킨의 설치/업그레이드/제거
    - 러블리어스의 플러그인/스킨 자료실과 연동되는 원격 설치/업그레이드
    - 파일 업로드를 통한 설치
  - GPF 코어의 원격 업그레이드
  - 그누보드 원본을 수정하지 않고 유용한 기능 구현 가능
    - 게시물이 보여질때, 게시물이 쓰여질때, 삭제될 때, 로그인할 때, 회원가입할 때 등등 그누보드의 각종 활동에 대한 이벤트 처리로 유용한 기능 개발 가능
  - 사이트전체/게시판그룹/게시판 으로 플러그인 적용 영역을 구분하여 플러그인 설정
    - 사이트 : 그누보드의 common.php 가 include 되는 전체 영역에서 실행될 수 있는 플러그인
    - 그룹 : 해당 게시판 그룹에 속한 게시판에 접근할 때 실행될 수 있는 플러그인
    - 게시판 : 해당 게시판에 접근할 때 실행될 수 있는 플러그인
        * 그룹과 게시판에 중복 활성화/설정 되었을 경우, '게시판' 설정을 따름

요구사항
---------
  - [그누보드5](http://sir.co.kr, "SIR")
  - PHP 5.x

설치
----
GPF 설치, 어렵지 않습니다. 아래 내용을 천천히 읽어 주세요.

- GPF 를 다운로드 한다 (러블리어스 첫 화면에서 'GPF 최신버전 다운로드' 링크 클릭)
- 압축을 풀면 gpf, extend, skin, adm 디렉토리가 있다. 이 디렉토리들을 그대로 그누보드가 설치된 폴더에 복사/업로드 한다.
  - <g4>/head.sub.php 파일 <html> 태그 위에 다음 코드를 추가합니다.
  <?php gp_do_action('load'); ?>
  - <g4>/head.sub.php 파일 <body> 태그 위에 다음 코드를 추가합니다.
  <?php gp_do_action('head_script'); ?>
  - <g4>/tail.sub.php 파일의 마지막 라인에 다음 코드를 추가합니다.
  <?php gp_do_action('unload'); ?>
  - 러블리어스의 플러그인/스킨 자료실을 사용하기 위해, '그누보드 관리자 > 플러그인 > GPF 설정'에서 GPF API Key 를 입력합니다. API Key는 러블리어스에 로그인하시고 'MyPage > ApiKey' 페이지에서 받으실 수 있습니다.


플러그인 및 스킨의 설치
-----------------------

플러그인/스킨의 설치는 FTP 설치, 업로드 설치, 원격설치의 3가지 방법으로 할 수 있습니다.

#### FTP 설치

  - 러블리어스의 플러그인/스킨/테마 자료실에서 플러그인/스킨/테마를 다운로드합니다. (zip 파일)
  - zip 파일의 압축을 풉니다. 압축을 풀면 하나의 디렉토리가 나옵니다. (디렉토리명을 변경하시면 안됩니다)
  - 파일질라와 같은 FTP 프로그램으로 압축해제한 디렉토리를 프로그램 위치에 업로드 합니다.
     - 플러그인 : [그누보드DIR]/gp/plugins 디렉토리에 업로드
     - 스킨 : [그누보드DIR]/skin/[스킨유형]/ 디렉토리에 업로드 (스킨 유형은 위의 '용어' 참고)
     - 테마 : [그누보드DIR]/theme/ 디렉토리에 업로드

#### 업로드 설치

  - 러블리어스의 플러그인 자료실에서 플러그인/스킨을 다운로드합니다. (zip 파일)
  - 플러그인/스킨 추가 페이지로 이동합니다.
     - 플러그인 : '그누보드 관리자 > 플러그인' 페이지의 '플러그인 추가' 링크를 클릭
     - 스킨 : '그누보드 관리자 > 스킨' 페이지의 '스킨 추가' 링크를 클릭. 스킨의 경우는 스킨 유형에 맞는 스킨 설치 페이지에서 업로드 해야 합니다.
     - 테마 : '그누보드 관리자 > 테마' 페이지의 '테마 추가' 링크를 클릭.
  - '업로드 설치' 하단의 업로드 폼에서 '찾아보기' 버튼을 클릭하고 다운받은 zip 파일을 업로드 합니다.
  - FTP 정보를 입력합니다. 입력한 FTP 정보는 패스워드를 제외하고는 서버에 안전하게 저장되며, 러블리어스로 전송되지 않습니다.
    - 호스트 : FTP 서버 주소를 입력합니다. 기본값으로 설정된것이 맞는지 확인해주세요.
    - FTP 포트 : 기본포트는 21입니다. 다른값으로 설정하셨다면 값을 맞게 설정해주세요.
    - FTP 패스워드 : FTP 접속 암호를 입력하세요.
    - 연결 후 그누보드 위치 : FTP 로그인 후 로그인 디렉토리로부터 그누보드 설치 디렉토리까지의 상대경로, 또는 그누보드 설치 디렉토리의 FTP상의 절대 경로를 입력합니다. 만약, FTP 로그인 후 현재 디렉토리가 /home/username 이고 그누보드 설치 디렉토리가 /home/username/public_html/gnuboard 라면, "public_html/gnuboard" 또는 "/home/username/public_html/gnuboard" 를 입력하시면 됩니다. 기본값으로는 웹상의 그누보드 설치경로의 절대 경로가 표시됩니다.

#### 원격 설치

  - 플러그인/스킨 추가 페이지로 이동합니다.
     - 플러그인 : '그누보드 관리자 > 플러그인' 페이지의 '플러그인 추가' 링크를 클릭
     - 스킨 : '그누보드 관리자 > 스킨' 페이지의 '스킨 추가' 링크를 클릭. 
     - 테마 : '그누보드 관리자 > 테마' 페이지의 '테마 추가' 링크를 클릭.
  - 하단의 목록에서 원하는 플러그인/스킨의 '설치' 또는 '업그레이드' 링크를 클릭합니다.
  - FTP 정보를 입력합니다. (FTP 정보는 이전의 '업로드 설치' 부분을 참고하세요)


플러그인의 사용
--------------

사실 플러그인의 사용은, 플러그인에 따라 다를것입니다. 여기에서는 일반적은 내용을 다룹니다.

### 플러그인의 종류

플러그인의 종류라고 하긴 뭐하지만, 이해를 돕기위해 구분해보겠습니다.
GPF의 플러그인은 게시판에 적용되는 플러그인과 사이트 전체에 적용하는 플러그인의 두가지로 크게 구분할 수 있습니다.

#### 게시판 플러그인
게시판 플러그인은 정해진 게시판에만 적용될 수 있도록 하는 플러그인입니다. 예를들면, 특정 사용자만 파일 다운로드가 가능하도록 한다던지, 글 보기 화면에 광고를 넣는다던지 하는 등의 게시판을 대상으로하는 플러그인입니다. 

게시판 플러그인은 쉬운 설정을 위해, 게시판 그룹을 대상으로 플러그인을 활성화/설정 할 수 있으며 또는 하나의 게시판에만 플러그인을 활성화/설정 할 수 있습니다. 

이때, G 라는 그룹에 속하는 모든 게시판에 플러그인을 활성화하고 설정하고자 한다면, 아래 화면에서 보이는 '대상' 선택에서 원하는 그룹을 선택하고 플러그인을 활성화 및 설정하면 됩니다. 그런데 이 그룹에 속하는 게시판중 A 게시판에는 다른 설정을 하고자 한다면, '대상' 선택에서 A 게시판을 선택하시고 그룹에서 설정한 같은 플러그인을 활성화 및 설정 하시면 그룹의 설정이 무시되고 게시판에서 설정한 내용이 플러그인에 적용됩니다.


#### 사이트 플러그인

사이트 플러그인은 그누보드로 구성된 사이트 전체에 적용되는 플러그인입니다. 예를들면, 모든 게시판들의 다운로드 로그를 남긴다던지, '리토리' 플러그인 처럼 모든 게시물 보기 현황을 기록한다든지, '소셜로그인' 플러그인처럼 회원 로그인 및 가입 등의 처리를 하는 플러그인들이 사이트 플러그인으로 작성될 수 있습니다. 아래 그림처럼, '플러그인' 탭에서 '대상' 선택을 '사이트 전체' 로 하면 사이트 플러그인 목록이 나타납니다. 


### 플러그인 사용 순서

  - 플러그인을 설치 (상단의 '플러그인/스킨의 설치' 부분 참고)
  - 플러그인 활성화 (플러그인 목록 페이지에서 '활성화' 링크 클릭)
  - 플러그인 설정 (플러그인에 설정 기능이 있다면, '설정' 탭 클릭)

스킨의 사용
----------

그누보드의 스킨 사용법과 동일합니다. GPF는 스킨의 설치/업그레이드/제거 만 도울 뿐입니다.


링크
----
  - [러블리어스](http://lovelyus.net "러블리어스로 고고싱")
  - [GPF 설치부터 사용까지](http://youtu.be/lQo6J-qoSh4 "유튜브로 고고싱")
