/**
 * Copyright (c) 2012 Jacob Lee <letsgolee@naver.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA or check at http://www.gnu.org/licenses/gpl.html
 */
/*
	the source comes from internet and I cannot remember.
*/
var COOKIE = {
	set: function(name, value, expires, path, domain, secure) {
		// set time, it's in milliseconds
		// expires: hours
		var today = new Date();
		today.setTime(today.getTime());

		/*
		if the expires variable is set, make the correct
		expires time, the current script below will set
		it for x number of days, to make it for hours,
		delete * 24, for minutes, delete * 60 * 24
		*/
		if (expires) {
			//expires = expires * 1000 * 60 * 60 * 24;
			expires = expires * 1000 * 60 * 60;
		}
		var expires_date = new Date(today.getTime() + (expires));

		document.cookie = name + "=" +escape(value) +
		(expires ? ";expires=" + expires_date.toGMTString() : "" ) +
		(path ? ";path=" + path : "" ) +
		(domain ? ";domain=" + domain : "" ) +
		(secure ? ";secure" : "" );
	},

	get: function(name) {
		// first we'll split this cookie up into name/value pairs
		// note: document.cookie only returns name=value, not the other components
		var cookies = document.cookie.split(';');
		var cookie = '';
		var cookie_name = '';
		var cookie_value = '';
		var found = false; // set boolean t/f default f

		for (i = 0; i < cookies.length; i++) {
			// now we'll split apart each name=value pair
			cookie = cookies[i].split('=');


			// and trim left/right whitespace while we're at it
			cookie_name = cookie[0].replace(/^\s+|\s+$/g, '');

			// if the extracted name matches passed name
			if (cookie_name == name) {
				found = true;
				// we need to handle case where cookie has no value but exists (no = sign, that is):
				if (cookie.length > 1) {
					cookie_value = unescape(cookie[1].replace(/^\s+|\s+$/g, ''));
				}
				// note that in cases where cookie is initialized but no value, null is returned
				return cookie_value;
				break;
			}
			cookie = null;
			cookie_name = '';
		}
		if (!found) {
			return null;
		}
	},
	
	del: function(name, path, domain) {
		if (this.get(name)) {
			document.cookie = name + "=" +
			(path ? ";path=" + path : "") +
			(domain ? ";domain=" + domain : "" ) +
			";expires=Thu, 01-Jan-1970 00:00:01 GMT";
		}
	}
}
