<?php
  include_once('../../common.php');
  $g5['title'] = "Vegas 플레이";

  if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

  include_once(G5_PATH.'/_head.php');

  if(!$member['mb_id']) {
    alert("회원전용 페이지입니다. 로그인 후 이용하세요.", "/bbs/login.php");        
  }
?>

<script type="text/javascript">
  var file = location.pathname.split("/").pop();
  var link = document.createElement("link");
  link.href = file.substr(0, file.lastIndexOf( "." )) + "slot.css";
  link.type = "text/css";
  link.rel = "stylesheet";
  link.media = "screen,print";
  document.getElementsByTagName("head")[0].appendChild(link);
</script>

<div style="width: 100%; text-align: center;">
  <input type="range" id="volumeBar" min="0" max="1" step="0.03" value="0.05" style="display: inline-block;">
</div>
<div style="height: 400px;">
  <div id="slot-machine">
    <div id="slot-body">
      <div id="slot-block"></div>
      <div id="slot-frame"></div>
      <div id="slot-glaze-bottom"></div>
      <div id="slot-display">
        <div id="slot-overlay"></div>
        <div id="slot-overlay-line"></div>
        <div id="slot-credits">0</div>
        <div id="slot-zeros">00000000000</div>
      </div>
      <div id="slot-wheels">
        <div id="wheel1" class="wheel">
          <div class="overlay"></div>              
          <img src="img/slot-1.gif" style="top: -572px;"/>                        
          <img src="img/spin.gif" class="slotSpinAnimation"/>
        </div>
        <div id="wheel2" class="wheel">
          <div class="overlay"></div>
          <img src="img/slot-2.gif" style="top: -484px;"/>
          <img src="img/spin.gif" class="slotSpinAnimation"/>
        </div>
        <div id="wheel3" class="wheel">
          <div class="overlay"></div>
          <img src="img/slot-3.gif" style="top: -220px;"/>
          <img src="img/spin.gif" class="slotSpinAnimation"/>
        </div>
      </div>
      <div id="slot-trigger">
        <div class="arm">
          <div class="knob"></div>
        </div>
        <div class="arm-shadow"></div>
        <div class="ring1">
          <div class="shadow"></div>
        </div>
        <div class="ring2">
          <div class="shadow"></div>
        </div>
      </div>
    </div>
    <div id="slot-details">
      <div id="slot-top"></div>
      <div id="slot-bottom"></div>
    </div>
    <div id="slot-legend">
      <div class="frame"></div>
      <ul class="wins">
        <li class="Seven">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">5000</span>
        </li>
        <li class="Prune">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">200</span>
        </li>
        <li class="Bar3">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">2000</span>
        </li>
        <li class="Orange">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">100</span>
        </li>
        <li class="Bar2">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">1000</span>
        </li>
        <li class="Cherry">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">120</span>
        </li>
        <li class="Bar1">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">300</span>
        </li>
        <li class="Cherry2">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon none"></span>
          <span class="count">30</span>
        </li>
        <li class="BarAny">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">80</span>
        </li>
        <li class="Cherry1">
          <span class="icon id1"></span>
          <span class="icon none"></span>
          <span class="icon none"></span>
          <span class="count">10</span>
        </li>
        <li class="Bell">
          <span class="icon id1"></span>
          <span class="icon id2"></span>
          <span class="icon id3"></span>
          <span class="count">500</span>
        </li>
      </ul>
    </div>
  </div>
  <audio id="trigEffect">
    <source src="snd/coin.ogg" type="audio/ogg">
  </audio>
  <audio id="spinEffect1" loop>
    <source src="snd/spin.ogg" type="audio/ogg">
  </audio>
  <audio id="spinEffect2" loop>
    <source src="snd/spin.ogg" type="audio/ogg">
  </audio>
  <audio id="spinEffect3" loop>
    <source src="snd/spin.ogg" type="audio/ogg">
  </audio>
  <audio id="stopEffect1">
    <source src="snd/stop.ogg" type="audio/ogg">
  </audio>
  <audio id="stopEffect2">
    <source src="snd/stop.ogg" type="audio/ogg">
  </audio>
  <audio id="stopEffect3">
    <source src="snd/stop.ogg" type="audio/ogg">
  </audio>
  <audio id="winEffect">
    <source src="snd/win.ogg" type="audio/ogg">
  </audio>
  <audio id="loseEffect">
    <source src="snd/lose.ogg" type="audio/ogg">
  </audio>
  <audio id="jackpotEffect">
    <source src="snd/jackpot.ogg" type="audio/ogg">
  </audio>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script id="rendered-js">
  (function($) {
    var trigEffect = document.getElementById("trigEffect");
    var spinEffect = [document.getElementById("spinEffect1"), document.getElementById("spinEffect2"), document.getElementById("spinEffect3")];
    var stopEffect = [document.getElementById("stopEffect1"), document.getElementById("stopEffect2"),document.getElementById("stopEffect3")];
    var winEffect = document.getElementById("winEffect");
    var loseEffect = document.getElementById("loseEffect");
    var jackpotEffect = document.getElementById("jackpotEffect");
    
    var slotMachine = function() {
      var credits = 0,
      spinning = 3,
      spin = [0, 0, 0],
      profits = [
        [10, 30, 120],  // cherry
        [0, 0, 100],    // orange
        [0, 0, 200],    // prune
        [0, 0, 500],    // bell
        [0, 0, 5000],   // seven
        [0, 0, 300],    // bar1
        [0, 0, 1000],   // bar2
        [0, 0, 2000],   // bar3
        [0, 0, 80]      // anybar
      ],
      slotName = {
        'cherry': 0,
        'orange': 1,
        'prune': 2,
        'bell': 3,
        'seven': 4,
        'bar1': 5,
        'bar2': 6,
        'bar3': 7,
        'anyBar': 8
      },
      slots = [
        [
          slotName.cherry, slotName.orange, slotName.cherry, slotName.bar2, slotName.prune, slotName.bar1, slotName.bell, slotName.orange,
          slotName.cherry, slotName.orange, slotName.bar3, slotName.prune, slotName.cherry, slotName.bell, slotName.bar1, slotName.orange,
          slotName.cherry, slotName.seven, slotName.prune, slotName.orange, slotName.cherry
        ],
        [
          slotName.orange, slotName.cherry, slotName.bar1, slotName.prune, slotName.orange, slotName.bar2, slotName.bell, slotName.cherry,
          slotName.bar3, slotName.orange, slotName.bar1, slotName.prune, slotName.cherry, slotName.orange, slotName.bell, slotName.bar2,
          slotName.seven, slotName.cherry, slotName.bar1, slotName.prune, slotName.orange, slotName.cherry
        ],
        [
          slotName.orange, slotName.cherry, slotName.bar1, slotName.bell, slotName.bar3, slotName.prune, slotName.orange, slotName.bar2,
          slotName.cherry, slotName.prune, slotName.bell, slotName.seven, slotName.bar1, slotName.bar3, slotName.orange, slotName.bar2,
          slotName.cherry, slotName.bell, slotName.prune, slotName.bar1, slotName.orange
        ]
      ],
      startSlot = function() {
        spinning = false;
        $('#slot-trigger').removeClass('slot-triggerDisabled');
        this.blur();
        return false;
      },
      endSlot = function() {
        $('#slot-block').show();
        $('#slot-credits').text('빈털털이!!!');
        setInterval(blink($('#slot-credits')), 1000);
      },
      addCredit = function(incrementCredits) {
        var currentCredits = credits;
        credits += incrementCredits;
        blink($('#slot-credits'));
        $('#slot-credits').css('credit', 0).animate(
          {credit:incrementCredits},
          {
            duration: 400 + incrementCredits,
            easing: 'easeOut',
            step: function(now) {
              $(this).html(parseInt(currentCredits + now, 10));
            },
            complete: function() {
              $(this).html(credits);
              blink($('#slot-credits'));
            }
          }
        );
      },
      spin = function() {    
        this.blur();
        if(spinning == false) {
          getPoint();
          if(credits >= 10) {
            spinEffect[0].currentTime = 0;
            spinEffect[1].currentTime = 0;
            spinEffect[2].currentTime = 0;
            spinEffect[0].play();
            spinEffect[1].play();
            spinEffect[2].play();

            $('#slot-machine .arm').animate({top:'45px', height:'2%'});
            $('#slot-machine .arm .knob').animate({top:'-20px', height:'20px'});
            $('#slot-machine .arm-shadow').animate({top:'40px'}, 380);
            $('#slot-machine .ring1 .shadow, #slot-machine .ring2 .shadow').animate({top:'50%', opacity:1});
            spinning = 3;
            credits = credits - 10;
            $('#slot-credits').html(credits);
            getSpin();
            //spin[0] = parseInt(Math.random() * 21);
            //spin[1] = parseInt(Math.random() * 22);
            //spin[2] = parseInt(Math.random() * 21);
            $('#slot-trigger').addClass('slot-triggerDisabled');
            $('img.slotSpinAnimation').show();
            $('#wheel1 img:first').css('top', -(spin[0] * 44 + 16) + 'px');
            $('#wheel2 img:first').css('top', -(spin[1] * 44 + 16) + 'px');
            $('#wheel3 img:first').css('top', -(spin[2] * 44 + 16) + 'px');
            setTimeout(function() {
              $('#slot-machine .arm').animate({top:'-25px', height:'50%', overflow:'visible'});
              $('#slot-machine .arm .knob').animate({top:'-15px', height:'16px'});
              $('#slot-machine .arm-shadow').animate({top:'13px' });
              $('#slot-machine .ring1 .shadow, #slot-machine .ring2 .shadow').animate({top:'0', opacity:0});
            }, 500);
            setTimeout(function() {
              stopSpin(1);
            }, 1500 + parseInt(1500 * Math.random()));
            setTimeout(function() {
              stopSpin(2);
            }, 1500 + parseInt(1500 * Math.random()));
            setTimeout(function() {
              stopSpin(3);
            }, 1500 + parseInt(1500 * Math.random()));
          }
        }
        return false;
      },
      stopSpin = function(slot) {
        spinEffect[slot - 1].pause();
        
        stopEffect[slot - 1].currentTime = 0;
        stopEffect[slot - 1].play();
        
        $('#wheel' + slot).find('img:last').hide().end().find('img:first').animate(
          {top:-spin[slot - 1] * 44},
          {
            duration: 500,
            easing: 'elasticOut',
            complete: function() {
              spinning--;
              if(spinning <= 0) endSpin();
            }
          }
        );
      },
      endSpin = function() {
        var matched = slots[0][spin[0]],
        matchCount = 0,
        winnedCredits = 0,
        waitToSpin = 10;

        if(matched == slots[1][spin[1]]) {
          matchCount++;
        } else if((matched > slotName.seven) && (slots[1][spin[1]] > slotName.seven)) {
          matched = slotName.anyBar;
          matchCount++;
        }
        
        if(matched == slots[2][spin[2]]) {
          if(matchCount > 0) matchCount++;
        } else if((matched > slotName.seven) && (slots[2][spin[2]] > slotName.seven)) {
          if(matchCount > 0) {
            matched = slotName.anyBar;
            matchCount++;
          }
        }

        var winnedCredits = profits[matched][matchCount];
        if(winnedCredits > 0) {
          if(winnedCredits == profits[slotName.seven][2]) {
            jackpotEffect.currentTime = 0;
            jackpotEffect.play();
          } else {
            winEffect.currentTime = 0;
            winEffect.play();
          }

          addCredit(winnedCredits);
          waitToSpin = 410 + winnedCredits;
        } else {
          loseEffect.currentTime = 0;
          loseEffect.play();
        }
        setTimeout(
          function() {
            if(credits == 0) {
              endSlot();
            } else {
              $('#slot-trigger').removeClass('slot-triggerDisabled');
              spinning = false;
            }
          },
          waitToSpin
        );
      },
      getPoint = function() {
        $.ajax({
          url: "point.php",
          type: "get",
          datatype: "json",
          async: false,
          success: function(data) {
            credits = JSON.parse(data)['point'];
            $('#slot-credits').text(String(credits));
          },
          complete: function(data) {},
          error: function(xhr, status, error) {}
        });    
      },
      getSpin = function() {
        spin[0] = -1;
        $.ajax({
          url: "spin.php",
          type: "get",
          datatype: "json",
          async: false,
          success: function(data) {
            spin[0] = JSON.parse(data)['slot1'];
            spin[1] = JSON.parse(data)['slot2'];
            spin[2] = JSON.parse(data)['slot3'];
          },
          complete: function(data) {},
          error: function(xhr, status, error) {}
        });    
      },
      setVolume = function() {
        var volume = $('#volumeBar').val();
        trigEffect.volume = volume;
        spinEffect[0].volume = volume;
        spinEffect[1].volume = volume;
        spinEffect[2].volume = volume;
        stopEffect[0].volume = volume;
        stopEffect[1].volume = volume;
        stopEffect[2].volume = volume;
        winEffect.volume = volume;
        loseEffect.volume = volume;
        jackpotEffect.volume = volume;
      };
      return {
        init: function() {
          getPoint();
          startSlot();
          $('#slot-trigger').bind('mousedown', function() {
            $(this).addClass('slot-triggerDown');
            trigEffect.currentTime = 0;
            trigEffect.play(); 
          }).bind('click', spin);
          $(document).bind('mouseup', function() {
            $('#slot-trigger').removeClass('slot-triggerDown');
          });
          $('#wheel1 img:first').css('top', -(parseInt(Math.random() * 21) * 44) + 'px');
          $('#wheel2 img:first').css('top', -(parseInt(Math.random() * 22) * 44) + 'px');
          $('#wheel3 img:first').css('top', -(parseInt(Math.random() * 21) * 44) + 'px');

          $('#volumeBar').change(function() {
            setVolume();
          });
          setVolume();
        }
      };
    }();
    $.extend($.easing,{
      bounceOut: function(x, t, b, c, d) {
        if((t /= d) < 1 / 2.75) {
          return c * (7.5625 * t * t) + b;
        } else if(t < 2 / 2.75) {
          return c * (7.5625 * (t -= 1.5 / 2.75) * t + .75) + b;
        } else if(t < 2.5 / 2.75) {
          return c * (7.5625 * (t -= 2.25 / 2.75) * t + .9375) + b;
        } else {
          return c * (7.5625 * (t -= 2.625 / 2.75) * t + .984375) + b;
        }
      },
      easeOut: function(x, t, b, c, d) {
        return -c * (t /= d) * (t - 2) + b;
      },
      elasticOut: function(x, t, b, c, d) {
        var s = 1.70158;var p = 0;var a = c;
        if(t == 0) return b;if ((t /= d) == 1) return b + c;if (!p) p = d * .3;
        if(a < Math.abs(c)) {
          a = c;
          var s = p / 4;
        } else
          var s = p / (2 * Math.PI) * Math.asin(c / a);
        return a * Math.pow(2, -10 * t) * Math.sin((t * d - s) * (2 * Math.PI) / p) + c + b;
      }
    });
    $(document).ready(slotMachine.init);
  })(jQuery);

  function blink(element) {
    element.animate({opacity:0}, 200, 'linear', function() {
      $(this).animate({opacity:1}, 200);
    });
  }
</script>


<?php
    include_once(G5_PATH.'/_tail.php');