      (function($) {
							var trigEffect = document.getElementById("trigEffect");
              var spinEffect = [document.getElementById("spinEffect1"), document.getElementById("spinEffect2"), document.getElementById("spinEffect3")];
              var stopEffect = [document.getElementById("stopEffect1"), document.getElementById("stopEffect2"),document.getElementById("stopEffect3")];
        
        var slotMachine = function () {
          var credits = 100,
          spinning = 3,
          spin = [0, 0, 0],
          slotsTypes = {
            'cherry': [10, 30, 120],
            'orange': [0, 0, 100],
            'prune': [0, 0, 200],
            'bell': [0, 0, 500],
            'bar1': [0, 0, 300],
            'bar2': [0, 0, 2000],
            'bar3': [0, 0, 4000],
            'seven': [0, 0, 5000],
            'anybar': [0, 0, 80]
          },

          slots = [
            [
              'seven', 'cherry', 'orange', 'cherry', 'bar1', 'cherry', 'bar2', 'orange',
              'bar3', 'cherry', 'prune', 'bell', 'bar1', 'orange', 'cherry', 'bar2',
              'bar3', 'cherry', 'bar1', 'orange', 'cherry', 'prune', 'bell', 'bar2'
            ],
            [
              'seven', 'cherry', 'orange', 'cherry', 'bar1', 'orange', 'prune', 'cherry',
              'bar2', 'cherry', 'bell', 'bar3', 'bar1', 'orange', 'prune', 'cherry',
              'orange', 'bar1', 'bar2', 'cherry', 'prune', 'bell'
            ],
            [
              'seven', 'cherry', 'orange', 'cherry', 'bar1', 'bar2', 'orange', 'cherry',
              'prune', 'bell', 'bar1', 'bar3', 'orange', 'bar2', 'cherry', 'orange',
              'bar1', 'cherry', 'prune', 'bell', 'bar2'
              ]
          ],

          startSlot = function() {
            spinning = false;
            $('#slot-trigger').removeClass('slot-triggerDisabled');
            this.blur();
            return false;
          },
          endSlot = function() {
            $('#slot-block').show();
            $('#slot-credits').text('!!!');
            setInterval(blink($('#slot-credits')), 1000);
          },
          addCredit = function(incrementCredits) {
            var currentCredits = credits;
            credits += incrementCredits;
            blink($('#slot-credits'));
            $('#slot-credits').css('credit', 0).animate(
              {credit:incrementCredits},
              {
                duration: 400 + incrementCredits,
                easing: 'easeOut',
                step: function(now) {
                  $(this).html(parseInt(currentCredits + now, 10));
                },
                complete: function() {
                  $(this).html(credits);
                  blink($('#slot-credits'));
                }
              }
            );
          },
          spin = function() {
            spinEffect[0].currentTime = 0;
            spinEffect[1].currentTime = 0;
            spinEffect[2].currentTime = 0;
  					spinEffect[0].play();
  					spinEffect[1].play();
  					spinEffect[2].play();
            
            this.blur();
            if(spinning == false) {
              $('#slot-machine .arm').animate({top:'45px', height:'2%'});
              $('#slot-machine .arm .knob').animate({top:'-20px', height:'20px'});
              $('#slot-machine .arm-shadow').animate({top:'40px'}, 380);
              $('#slot-machine .ring1 .shadow, #slot-machine .ring2 .shadow').animate({top:'50%', opacity:1});
              spinning = 3;
              credits = credits - 10;
              $('#slot-credits').html(credits);
              spin[0] = parseInt(Math.random() * 24);
              spin[1] = parseInt(Math.random() * 22);
              spin[2] = parseInt(Math.random() * 21);
              $('#slot-trigger').addClass('slot-triggerDisabled');
              $('img.slotSpinAnimation').show();
              $('#wheel1 img:first').css('top', -(spin[0] * 44 + 16) + 'px');
              $('#wheel2 img:first').css('top', -(spin[1] * 44 + 16) + 'px');
              $('#wheel3 img:first').css('top', -(spin[2] * 44 + 16) + 'px');
              setTimeout(function() {
                $('#slot-machine .arm').animate({top:'-25px', height:'50%', overflow:'visible'});
                $('#slot-machine .arm .knob').animate({top:'-15px', height:'16px'});
                $('#slot-machine .arm-shadow').animate({top:'13px' });
                $('#slot-machine .ring1 .shadow, #slot-machine .ring2 .shadow').animate({top:'0', opacity:0});
              }, 500);
              setTimeout(function() {
                stopSpin(1);
              }, 1500 + parseInt(1500 * Math.random()));
              setTimeout(function() {
                stopSpin(2);
              }, 1500 + parseInt(1500 * Math.random()));
              setTimeout(function() {
                stopSpin(3);
              }, 1500 + parseInt(1500 * Math.random()));
            }
            return false;
          },
          stopSpin = function(slot) {
  					spinEffect[slot - 1].pause();
            
            stopEffect[slot - 1].currentTime = 0;
  					stopEffect[slot - 1].play();
            
            $('#wheel' + slot).find('img:last').hide().end().find('img:first').animate(
              {top:-spin[slot - 1] * 44},
              {
                duration: 500,
                easing: 'elasticOut',
                complete: function() {
                  spinning--;
                  if(spinning <= 0) endSpin();
                }
              }
            );
          },
          endSpin = function() {
            var slotType = slots[0][spin[0]],
            matches = 1,
            barMatch = /bar/.test(slotType) ? 1 : 0,
            winnedCredits = 0,
            waitToSpin = 10;
            if(slotType == slots[1][spin[1]]) {
              matches++;
              if(slotType == slots[2][spin[2]]) {
                matches++;
              } else if(barMatch != 0 && /bar/.test(slots[2][spin[2]])) {
                barMatch++;
              }
            } else if(barMatch != 0 && /bar/.test(slots[1][spin[1]])) {
              barMatch++;
              if(/bar/.test(slots[2][spin[2]])) barMatch++;
            }
            if(matches != 3 && barMatch == 3) {
              slotType = 'anybar';
              matches = 3;
            }
            var winnedCredits = slotsTypes[slotType][matches - 1];
            if(winnedCredits > 0) {
              addCredit(winnedCredits);
              waitToSpin = 410 + winnedCredits;
            }
            setTimeout(
              function() {
                if(credits == 0) {
                  endSlot();
                } else {
                  $('#slot-trigger').removeClass('slot-triggerDisabled');
                  spinning = false;
                }
              },
              waitToSpin
            );
          };
          return {
            init: function() {
              startSlot();
              $('#slot-trigger').bind('mousedown', function() {
                $(this).addClass('slot-triggerDown');
								trigEffect.currentTime = 0;
  							trigEffect.play(); 
              }).bind('click', spin);
              $(document).bind('mouseup', function() {
                $('#slot-trigger').removeClass('slot-triggerDown');
              });
              $('#wheel1 img:first').css('top', -(parseInt(Math.random() * 24) * 44) + 'px');
              $('#wheel2 img:first').css('top', -(parseInt(Math.random() * 22) * 44) + 'px');
              $('#wheel3 img:first').css('top', -(parseInt(Math.random() * 21) * 44) + 'px');
            }
          };
        }();
        $.extend($.easing,{
          bounceOut: function(x, t, b, c, d) {
            if((t /= d) < 1 / 2.75) {
              return c * (7.5625 * t * t) + b;
            } else if(t < 2 / 2.75) {
              return c * (7.5625 * (t -= 1.5 / 2.75) * t + .75) + b;
            } else if(t < 2.5 / 2.75) {
              return c * (7.5625 * (t -= 2.25 / 2.75) * t + .9375) + b;
            } else {
              return c * (7.5625 * (t -= 2.625 / 2.75) * t + .984375) + b;
            }
          },
          easeOut: function(x, t, b, c, d) {
            return -c * (t /= d) * (t - 2) + b;
          },
          elasticOut: function(x, t, b, c, d) {
            var s = 1.70158;var p = 0;var a = c;
            if(t == 0) return b;if ((t /= d) == 1) return b + c;if (!p) p = d * .3;
            if(a < Math.abs(c)) {
              a = c;
              var s = p / 4;
            } else
              var s = p / (2 * Math.PI) * Math.asin(c / a);
            return a * Math.pow(2, -10 * t) * Math.sin((t * d - s) * (2 * Math.PI) / p) + c + b;
          }
        });
        $(document).ready(slotMachine.init);
      })(jQuery);

      function blink(element) {
        element.animate({opacity:0}, 200, 'linear', function() {
          $(this).animate({opacity:1}, 200);
        });
      }
