<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/style.css">', 0);
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/css/jquery.memo.tagit.css">', 1);
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/css/jquery-ui.themes.flick.css">', 1);
add_javascript('<script src="'.$member_skin_url.'/js/jquery.ui.js"></script>', 0);
add_javascript('<script src="'.$member_skin_url.'/js/jquery.memo.input.js"></script>', 0);
?>

<!-- 쪽지 보내기 시작 { -->
<div id="memo_write" class="new_win">
    <h1 id="win_title"><i class="fa fa-envelope-o" aria-hidden="true"></i> 쪽지 보내기</h1>
    <div class="new_win_con2">
        <ul class="win_ul">
            <li><a href="./memo.php?kind=recv">받은쪽지</a></li>
            <li><a href="./memo.php?kind=send">보낸쪽지</a></li>
            <li class="selected"><a href="./memo_form.php">쪽지쓰기</a></li>
        </ul>

        <form name="fmemoform" action="<?php echo $memo_action_url; ?>" onsubmit="return fmemoform_submit(this);" method="post" autocomplete="off">
        <div class="form_01">
            <h2 class="sound_only">쪽지쓰기</h2>
            <ul>
                <li>
                    <label for="me_recv_mb_id" class="sound_only">받는 회원아이디<strong>필수</strong></label>
                    
                    <input type="text" id="wr_tags_input" name="me_recv_mb_id" value="<?php echo $me_recv_mb_id; ?>" id="me_recv_mb_id" required class="frm_input full_input required" size="47" placeholder="받는 회원아이디">
					<ul id="singleFieldTags" class="qa_tag_el"></ul>
                    <span class="frm_info">여러 회원에게 보낼때는 컴마(,)로 구분하세요.</span>
                    <?php if ($config['cf_memo_send_point']) { ?>
                    <br ><span class="frm_info">쪽지 보낼때 회원당 <?php echo number_format($config['cf_memo_send_point']); ?>점의 포인트를 차감합니다.</span>
                    <?php } ?>
                </li>
                <li>
                    <label for="me_memo" class="sound_only">내용</label>
                    <textarea name="me_memo" id="me_memo" required class="required"><?php echo $content ?></textarea>
                </li>
                <li>
                    <span class="sound_only">자동등록방지</span>
                    
                    <?php echo captcha_html(); ?>
                    
                </li>
            </ul>
        </div>

        <div class="win_btn">
        	<button type="submit" id="btn_submit" class="btn btn_b02 reply_btn">보내기</button>
        	<button type="button" onclick="window.close();" class="btn_close">창닫기</button>
        </div>
    </div>
    </form>
</div>

<script>
function fmemoform_submit(f)
{
    <?php echo chk_captcha_js();  ?>

    return true;
}

jQuery(function($){

    var memo_global_tags = [];
    var $tag_field_wrap = $('#singleFieldTags'),
        cachequery = {},
        item_datas = null;

    $("#wr_tags_input").hide();

    function ids_subtractArray(a1, a2, obj) {

        if( typeof obj.edittagInput != "undefined" && obj.edittagInput.data('autocomplete-edit') ){
            return a1;
        }

        var result = [];
        for (var i = 0; i < a1.length; i++) {

            if( typeof a1[i].mb_id != 'undefined' ){
                obj._dataspush( a1[i].mb_id );
            }

            if ( typeof a1[i].mb_id != 'undefined' && $.inArray(a1[i].mb_id, a2) == -1) {
                result.push(a1[i]);
            }
        }
        return result;
    }

    $tag_field_wrap.tagit({
        placeholderText : "아이디 or 닉네임 입력해주세요",
        singleField: true,
        singleFieldNode: $('#wr_tags_input'),
        tagLimit : 30,
        onTagLimitExceeded : function(e, ui){},
        Special_chars_block: 1,
        autocomplete: ({
            delay: 130,
            minLength: 1,
            source: function (request, response) {
                var othis = this;

                item_datas = cachequery[request.term];

                if (typeof item_datas == "object") {

                    item_datas = ids_subtractArray(item_datas, othis.assignedTags(), othis);

                    response($.map(item_datas, function (item) {
                        return {
                            label : item.mb_id,
                            value : item.mb_id,
                            mb_nick : item.mb_nick,
                            img : item.img,
                        }
                    }))
                    return;

                } else {
                    cache = {};

                    $.ajax({
                        url : "<?php echo $member_skin_url ?>/data.php",
                        data: { format: "json", s: request.term },
                        dataType: 'json',
                        type: 'GET',
                        success: function (data) {

                            cachequery[request.term] = data;

                            data = ids_subtractArray(data, othis.assignedTags(), othis);

                            response($.map(data, function (item) {
                                return {
                                    label : item.mb_id,
                                    value : item.mb_id,
                                    mb_nick : item.mb_nick,
                                    img : item.img,
                                }
                            }));
                        },
                        error: function (request, status, error) {
                            alert(error);
                        }
                    });

                }
            },
            create: function () {
                $(this).data('ui-autocomplete')._renderItem = function (ul, item) {
                    var item_value = String(item.value).replace(
                            new RegExp(this.term, "gi"),
                            "<span class='highlight'>$&</span>"),
                        item_mb_nick = String(item.mb_nick).replace(
                            new RegExp(this.term, "gi"),
                            "<span class='highlight'>$&</span>");

                  return $('<li>').addClass("autocomplete_user")
                    .append( '<a>' + item.img + ' <span class="label_left">' + item_mb_nick + '</span><span class="label_right">' + item_value + "</span></a>" )
                    .appendTo(ul);
                };
                
                $(this).data('ui-autocomplete')._move = function (direction, event) {

                    if ( !this.menu.element.is( ":visible" ) ) {
                        this.search( null, event );
                        return;
                    }

                    this.menu[ direction ]( event );
                };
            },
            open: function(){
                $(this).autocomplete('widget').css('z-index', 100);
            },
            autoFocus: true,
            focus: function( event, ui ) {
              event.preventDefault();
            },
            position: { my: "left top", at: "left bottom", collision: "flip" },
        })

    }).on("keypress keydown keyup change", "input", function(e){
        if(e.keyCode == 13) { // Enter 방지
            e.preventDefault();
            return false;
        }
    });
});
</script>
<!-- } 쪽지 보내기 끝 -->

