<?php
$sub_menu = '200800';
include_once('./_common.php');

auth_check_menu($auth, $sub_menu, "r");

if( !isset($g5['history_table']) ){
    die('<meta charset="utf-8">/data/dbconfig.php 파일에 <strong>$g5[\'history_table\'] = G5_TABLE_PREFIX.\'history\';</strong> 를 추가해 주세요.');
}
//내용(컨텐츠)정보 테이블이 있는지 검사한다.
if(!sql_query(" DESCRIBE {$g5['history_table']} ", false)) {
    if(sql_query(" DESCRIBE {$g5['g5_history_table']} ", false)) {
        sql_query(" ALTER TABLE {$g5['g5_history_table']} RENAME TO `{$g5['history_table']}` ;", false);
    } else {
       $query_cp = sql_query(" CREATE TABLE IF NOT EXISTS `{$g5['history_table']}` (
                      `co_id` int(11) NOT NULL AUTO_INCREMENT,
                      `co_html` tinyint(4) NOT NULL DEFAULT '0',
                      `co_year` int(4) NOT NULL DEFAULT '0',
                      `co_month` int(2) NOT NULL DEFAULT '0',
                      `co_day` int(2) NOT NULL DEFAULT '0',
                      `co_content` longtext NOT NULL,
                      PRIMARY KEY (`co_id`)
                    ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ", true);
    }
}


$g5['title'] = '내용관리';
include_once (G5_ADMIN_PATH.'/admin.head.php');

$sql_common = " from {$g5['history_table']} ";

// 테이블의 전체 레코드수만 얻음
$sql = " select count(*) as cnt " . $sql_common;
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$rows = $config['cf_page_rows'];
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) { $page = 1; } // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

$sql = "select * $sql_common order by co_id limit $from_record, {$config['cf_page_rows']} ";
$result = sql_query($sql);
?>

<div class="local_ov01 local_ov">
    <?php if ($page > 1) {?><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>">처음으로</a><?php } ?>
    <span class="btn_ov01"><span class="ov_txt">전체 내용</span><span class="ov_num"> <?php echo $total_count; ?>건</span></span>
</div>

<div class="btn_fixed_top">
    <a href="../history" class="btn btn_01">사이트 보기</a>
    <a href="./historywrite.php" class="btn btn_01">내용 추가</a>
</div>

<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col">번호</th>
        <th scope="col">연력일정</th>
        <th scope="col">연혁내용</th>
        <th scope="col">관리</th>
    </tr>
    </thead>
    <tbody>
    <?php for ($i=0; $row=sql_fetch_array($result); $i++) {
        $bg = 'bg'.($i%2);
    ?>
    <tr class="<?php echo $bg; ?>">
        <td class="td_id"><?php echo $row['co_id']; ?></td>
        <td class="td_id"><?php echo $row['co_year']."-".$row['co_month']."-".$row['co_day']; ?></td>
        <td class="td_left"><?php echo $row['co_content']; ?></td>
        <td class="td_mng td_mng_l">
            <a href="./historywrite.php?w=u&amp;co_id=<?php echo $row['co_id']; ?>" class="btn btn_03"><span class="sound_only"><?php echo htmlspecialchars2($row['co_content']); ?> </span>수정</a>
            <a href="./historyupdate.php?w=d&amp;co_id=<?php echo $row['co_id']; ?>" onclick="return delete_confirm(this);" class="btn btn_02"><span class="sound_only"><?php echo htmlspecialchars2($row['co_content']); ?> </span>삭제</a>
        </td>
    </tr>
    <?php
    }
    if ($i == 0) {
        echo '<tr><td colspan="4" class="empty_table">자료가 한건도 없습니다.</td></tr>';
    }
    ?>
    </tbody>
    </table>
</div>

<?php echo get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, "{$_SERVER['SCRIPT_NAME']}?$qstr&amp;page="); ?>

<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');