<?php
/**
 * 인트라넷 플러그인 
 *
 * @package net.lovelyus.g5.plugin.intranet
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$luIntranet = new LUIntranet();
$luIntranet->hook($gp_scope);

/**
 * 
 * 
 * @author Chongmyung Park <byfun@byfun.com> 
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
class LUIntranet
{
  var $id;
  var $scope;
  var $plugin_url;
  var $plugin_path;
  var $plugin_config;
  var $config_file = 'cfg.plugin.intranet.php';
  var $do_url;

  /**
   * hook : gpf 후킹
   * 
   * @access public
   * @return void
   */
	function hook($gp_scope)
	{ 
		$this->scope = $gp_scope;
		$this->id = gp_plugin_id(__FILE__);
    $this->plugin_path = dirname(__FILE__);
    $this->plugin_url = gp_plugin_url(__FILE__);
		$this->plugin_config = gp_read_config($this->config_file, array('access_level'=>2, 'use_register'=>1), $this->scope);
		$this->do_url = GP_URL . '/do.php?scope='.$this->scope.'&bo_table='.$bo_table.'&wr_id='.$wr_id.'&id='.$this->id.'&act=';

		gp_add_filter('gpa_settings', array($this, 'plugin_setting'), 10);
		gp_add_action('pxa_save_setting', array($this, 'plugin_save_setting'));
		gp_add_filter('gpa_menu_plugin_'.$this->id, array($this, 'plugin_menu'));
		gp_add_action('pxa_install', array($this, 'plugin_install'));
		gp_add_action('pxa_uninstall', array($this, 'plugin_uninstall'));

		gp_add_filter('gp_admin_menu', array($this, 'admin_menu'));
		gp_add_action('pxa_manage', array($this, 'on_manage_request'));
		gp_add_action('pxa_confirm_request', array($this, 'on_confirm_request'));
		gp_add_action('pxa_delete_complete', array($this, 'on_delete_complete'));

    gp_add_action('gp_plugin_loaded', array($this, 'on_system_loaded'));
    gp_add_action('px_request_auth', array($this, 'on_auth_requested'));
	}

  function on_system_loaded()
  {
    extract($GLOBALS);
    
    $exfiles = array(
      'password_lost.php', 'password_lost2.php', 'password.php', 'password_lost_certify.php'
      , 'login_check.php', 'logout.php', 'do.php'
    );

    if($this->plugin_config['use_register']) {
      $exfiles = array_merge($exfiles, array(
                  'register.php', 'register_email.php', 'register_email_update.php', 'register_form.php'
                  , 'register_form_update.php', 'register_form_update_mail1.php', 'register_form_update_mail2.php', 'register_form_update_mail3.php', 'register_result.php'
                 ));
    }
    
    $file = basename($_SERVER['SCRIPT_NAME']);

    if(in_array($file, $exfiles)) return;

    if($is_guest) {
      include_once $this->plugin_path.DS.'tpl'.DS.'login.skin.php';
      exit;
    }

    if($member['mb_level'] < $this->plugin_config['access_level'])
    {
      include_once $this->plugin_path.DS.'tpl'.DS.'noauth.skin.php';
      exit;
    }
  }

  function on_auth_requested()
  {
    global $member;

    if(!$member['mb_id']) die( json_encode( array('code'=>-1, 'msg'=>'로그인 후 사용하세요') ) );

    $ex = sql_fetch("SELECT * FROM gpf_intranet_auth WHERE mb_id = '{$member['mb_id']}'");
    if($ex) die( json_encode( array('code'=>-1, 'msg'=>'이미 사용 권한을 요청하였습니다.') ) );

    sql_query("INSERT INTO gpf_intranet_auth SET mb_id = '{$member['mb_id']}', stat=1, reg_date='".G5_TIME_YMDHIS."'");
    die( json_encode( array('code'=>1, 'msg'=>'사용 권한을 요청하였습니다.') ) );
  }

	function admin_menu($menu)
	{
		array_push($menu, array("717002", "인트라넷 권한요청 관리", GP_ADMIN_URL."/admin_do.php?id=".$this->id."&act=manage"));
		return $menu;
	}

  function on_manage_request()
  {
    extract($GLOBALS);
    include_once $this->plugin_path.DS.'adm'.DS.'front.php';
  }

  function on_confirm_request()
  {
    global $g5, $rid;
    if(!$rid) die( json_encode( array('code'=>-1, 'msg'=>'잘못된 연결입니다.') ) );

    $req = sql_fetch("SELECT * FROM gpf_intranet_auth WHERE id= '{$rid}'");
    if(!$req) die( json_encode( array('code'=>-1, 'msg'=>'존재하지 않는 요청 정보입니다.') ) );

    sql_query("UPDATE gpf_intranet_auth SET stat = 0 WHERE id = '{$rid}'");
    sql_query("UPDATE {$g5['member_table']} SET mb_level = '{$this->plugin_config['access_level']}' WHERE mb_id = '{$req['mb_id']}'");

    die( json_encode( array('code'=>1, 'msg'=>'사용자의 레벨을 '. $this->plugin_config['access_level']. '로 설정하였습니다.') ) );
  }

  function on_delete_complete()
  {
    global $g5, $rid;
    if(!$rid) die( json_encode( array('code'=>-1, 'msg'=>'잘못된 연결입니다.') ) );

    $req = sql_fetch("SELECT * FROM gpf_intranet_auth WHERE id= '{$rid}'");
    if(!$req) die( json_encode( array('code'=>-1, 'msg'=>'존재하지 않는 요청 정보입니다.') ) );

    sql_query("DELETE FROM gpf_intranet_auth WHERE id = '{$rid}'");

    die( json_encode( array('code'=>1, 'msg'=>'요청 내역을 삭제하였습니다.') ) );
  }

  /**
   * 설정페이지에 항목 추가
   * 
   * @param mixed $gpa_settings 
   * @access public
   * @return void
   */
	function plugin_setting($gpa_settings)
	{
		array_push($gpa_settings, array('ID'=>$this->id, 'title'=>'인트라넷', 'print_contents'=>array($this, 'plugin_config_contents'), 'order'=>10) );
		return $gpa_settings;
	}

	
  /**
   * 플러그인 설정 페이지
   * 
   * @access public
   * @return void
   */
	function plugin_config_contents()
	{
		$plugin_config = $this->plugin_config;
		$plugin_id = $this->id;
		$plugin_path = $this->plugin_path;
		$plugin_url = $this->plugin_url;
		include_once $this->plugin_path."/tpl/config.form.php";
	}

  /**
   * 설정 저장
   * 
   * @access public
   * @return void
   */
	function plugin_save_setting()
	{
		gp_write_config($this->config_file, gp_strip_slashes($_REQUEST['plugin_config']), $this->scope );
		alert('인트라넷 플러그인 설정 저장 완료');
	}

	

  /**
   * plugins 페이지에 메뉴 추가
   * 
   * @param mixed $menus 
   * @access public
   * @return void
   */
	function plugin_menu($menus)
	{
		global $bo_table;
		if(gp_table_exists('gpf_intranet_auth')) 
		{
		  array_push($menus, array('href'=>gp_url('setting.php', $this->scope, $noqm=false, $this->id), 'text'=>'설정'));
			array_push($menus, array('href'=>gp_url('admin_do.php', $this->scope).'&id='.$this->id.'&act=uninstall', 'attr'=>'onclick="return confirm(\'등록된 모든 DB 정보가 삭제됩니다.\\n진행하시겠습니까?\');"', 'text'=>'DB삭제'));
		} else {
			array_push($menus, array('href'=>gp_url('admin_do.php', $this->scope).'&id='.$this->id.'&act=install', 'text'=>'DB생성', 'attr'=>''));
		}
		return $menus;
	}

  /**
   * 플러그인 설치
   * 
   * @access public
   * @return void
   */
	function plugin_install()
	{
		$install_script =<<<EOF
		CREATE TABLE IF NOT EXISTS `gpf_intranet_auth` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `mb_id` varchar(255) NOT NULL,
		  `stat` tinyint NOT NULL,
		  `reg_date` datetime NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;
;
EOF;
		$f = explode(";", $install_script);
		for ($i=0; $i<count($f); $i++) {
			if (trim($f[$i]) == "") continue;
			sql_query($f[$i]);
		}
		goto_url(gp_url('plugins.php', $this->scope));
	}

	
  /**
   * 플러그인 제거
   * 
   * @access public
   * @return void
   */
	function plugin_uninstall()
	{
		sql_query("DROP TABLE gpf_intranet_auth", false);
		gp_deactivate_plugin($this->id, $this->scope);
		goto_url(gp_url('plugins.php', $this->scope));
	}
}
?>
