<?php
header('Content-Type: application/json; charset=utf-8');

include '../_config.php';

if(isset($_POST['url']))
{
    $vid = getYoutubeVideoId($_POST['url']);

    if($vid)
	{
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://www.googleapis.com/youtube/v3/videos?id='.$vid.'&key='.$api_key.'&part=snippet');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $rst = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($rst, true);

        if(!empty($data['items']))
		{
            $info = $data['items'][0]['snippet'];
			if(!$info['description']) $info['description'] = '.'; // 내용이 없을때 어떻게 할지 고민?

            $view = [
                'wr_subject' => $info['title'],
                'wr_content' => nl2br($info['description']),
                'thumbnail_url' => $info['thumbnails']['high']['url']
            ];

            echo json_encode($view, JSON_UNESCAPED_UNICODE);
        } else {
			echo json_encode(['error' => '해당 YouTube 동영상을 찾을 수 없습니다.'], JSON_UNESCAPED_UNICODE);
        }
    } else {
        echo json_encode(['error' => '유효한 YouTube URL이 아닙니다.'], JSON_UNESCAPED_UNICODE);
    }
}

function getYoutubeVideoId($url)
{
    $vid = '';

	if (preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/i', $url, $matches))
		$vid = $matches[1];

    return $vid;
}
