<?php
// data.json 파일에서 JSON 데이터 읽기
$jsonData = file_get_contents('data.json');
$dataArray = json_decode($jsonData, true);

// 데이터가 없으면 빈 배열로 초기화
if ($dataArray === null) {
    $dataArray = [];
}

// 검색 기능
$searchName = isset($_GET['search_name']) ? $_GET['search_name'] : '';

// 검색된 결과 필터링
if ($searchName) {
    $filteredData = array_filter($dataArray, function($member) use ($searchName) {
        return stripos($member['이름'], $searchName) !== false;  // 이름을 포함하는 경우
    });
} else {
    // 검색어가 없으면 모든 데이터 출력
    $filteredData = $dataArray;
}

?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>회원 목록</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        img {
            width: 50px;  /* 이미지 크기 조정 */
            height: 50px;
        }
    </style>
</head>
<body>

<h1>회원 목록</h1>

<!-- 검색 폼 -->
<form method="GET" action="look.php">
    <label for="search_name">회원 이름 검색:</label>
    <input type="text" id="search_name" name="search_name" value="<?php echo htmlspecialchars($searchName); ?>" placeholder="이름을 입력하세요">
    <button type="submit">검색</button>
</form>

<h2>검색 결과</h2>

<table>
    <thead>
        <tr>
            <th>이름</th>
            <th>전화번호</th>
            <th>주소</th>
            <th>이메일</th>
            <th>소개</th>
            <th>사진</th>  <!-- 사진 항목 추가 -->
        </tr>
    </thead>
    <tbody>
        <?php
        // 필터링된 데이터 배열을 순회하며 테이블 행을 생성
        if (count($filteredData) > 0) {
            foreach ($filteredData as $member) {
                echo "<tr>";
                echo "<td>" . htmlspecialchars($member['이름']) . "</td>";
                echo "<td>" . htmlspecialchars($member['전화번호']) . "</td>";
                echo "<td>" . htmlspecialchars($member['주소']) . "</td>";
                echo "<td>" . htmlspecialchars($member['이메일']) . "</td>";
                echo "<td>" . htmlspecialchars($member['소개']) . "</td>";
                // 이미지 출력
                echo "<td><img src='" . htmlspecialchars($member['사진']) . "' alt='사진'></td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><td colspan='6'>검색된 회원이 없습니다.</td></tr>";
        }
        ?>
    </tbody>
</table>

</body>
</html>
