<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if ($mark == 1){
include_once(G5_LIB_PATH . '/image_proc.function.php');

$selected_value = $_POST['go_sel'];
if ($selected_value == "1") {
$img_path = $board_skin_path . '/img/';
$extensions = ['jpg', 'png', 'gif', 'jpeg'];
foreach ($extensions as $ext) {
    if (file_exists($img_path . "watermark." . $ext)) {
        $p_m_file = $img_path . "watermark." . $ext;
        break;
        }
    }
} elseif ($selected_value == "2") {
$text = isset($_POST['watermark_text']) ? $_POST['watermark_text'] : 'Dandelion'; // 기본값 설정 $text = 'Dandelion'; // 텍스트 내용
$font_size = 10; // 글자 크기
$font_path = $board_skin_path . '/font/apercumovistarbold.ttf'; // 글꼴 경로

// 글자 크기 계산 (이미지 크기를 텍스트에 맞게 조정)
$bbox = imagettfbbox($font_size, 0, $font_path, $text);
$text_width = $bbox[2] - $bbox[0];
$text_height = $bbox[1] - $bbox[7];
$image_width = $text_width + 10; // 여유 공간 10px 추가
$image_height = $text_height + 10;

// 투명한 이미지 생성
$image = imagecreatetruecolor($image_width, $image_height);
imagesavealpha($image, true);
$transparent = imagecolorallocatealpha($image, 0, 0, 0, 127); // 완전 투명
imagefill($image, 0, 0, $transparent);

// 글자 색상 (주황색, 투명도 없음)
$text_color = imagecolorallocatealpha($image, 255, 125, 0, 0); // alpha = 0 (불투명)

// 텍스트의 위치 계산 (중앙 정렬)
$x_position = 5; // 좌측 여백
$y_position = ($image_height - $text_height) / 2 + $text_height;

// 텍스트 삽입
imagettftext($image, $font_size, 0, $x_position, $y_position, $text_color, $font_path, $text);

// 결과 이미지를 저장
$output_file = $board_skin_path . '/img/transparent_text.png';
imagepng($image, $output_file);
$p_m_file = $output_file;

// 메모리 해제
imagedestroy($image);

}

// 워터마크 적용 함수
function apply_watermark($path_file, $path_mark_file, $path_save_file, $position, $opacity) {
    // 원본 이미지 가져오기
    list($src, $src_w, $src_h) = get_image_resource_from_file($path_file);
    if (empty($src)) {
        throw new Exception("원본 이미지를 불러올 수 없습니다: $path_file");
    }

    // 워터마크 이미지 가져오기
    list($mark, $mark_w, $mark_h) = get_image_resource_from_file($path_mark_file);
    if (empty($mark)) {
        throw new Exception("워터마크 이미지를 불러올 수 없습니다: $path_mark_file");
    }

    // 알파 채널 활성화
    imagesavealpha($src, true);
    imagesavealpha($mark, true);

    // 워터마크 위치 설정
    switch ($position) {
        case '1': // 좌상단
            $src2_x = 10;
            $src2_y = 10;
            break;
        case '2': // 우상단
            $src2_x = $src_w - $mark_w - 10;
            $src2_y = 10;
            break;
        case '3': // 좌하단
            $src2_x = 10;
            $src2_y = $src_h - $mark_h - 10;
            break;
        case '4': // 우하단
            $src2_x = $src_w - $mark_w - 10;
            $src2_y = $src_h - $mark_h - 10;
            break;
        case '5': // 중앙
            $src2_x = ceil(($src_w - $mark_w) / 2);
            $src2_y = ceil(($src_h - $mark_h) / 2);
            break;
        default: // 기본: 우하단
            $src2_x = $src_w - $mark_w - 10;
            $src2_y = $src_h - $mark_h - 10;
            break;
    }

    // 알파 블렌딩 비활성화 및 복사
    imagealphablending($src, true);
    imagealphablending($mark, false);

    // 투명도 적용: 별도 처리 필요 시 알파값 변경
    if ($opacity < 100) {
        $temp_mark = imagecreatetruecolor($mark_w, $mark_h);
        imagesavealpha($temp_mark, true);
        $transparent = imagecolorallocatealpha($temp_mark, 0, 0, 0, 127); // 투명 배경
        imagefill($temp_mark, 0, 0, $transparent);

        // 워터마크 이미지 복사 (투명도 조절)
        imagecopy($temp_mark, $mark, 0, 0, 0, 0, $mark_w, $mark_h);
        imagefilter($temp_mark, IMG_FILTER_COLORIZE, 0, 0, 0, (127 - $opacity) * 1.27); // 투명도 필터
        $mark = $temp_mark;
    }

    // 워터마크 복사
    imagecopy($src, $mark, $src2_x, $src2_y, 0, 0, $mark_w, $mark_h);

    // 결과 이미지 저장
    $result_save = save_image_from_resource($src, $path_save_file, 100, 2);
    if ($result_save === false) {
        throw new Exception("이미지를 저장하는 중 오류가 발생하였습니다: $path_save_file");
    }

    // 리소스 해제
    @imagedestroy($src);
    @imagedestroy($mark);
}

// 본문 내용에서 이미지 처리
try {
    $content_por = sql_fetch("SELECT * FROM " . G5_TABLE_PREFIX . "write_" . $bo_table . " WHERE wr_id = '$wr_id'");
    $contents = $content_por['wr_content'];

    // 이미지 태그에서 src 추출
    preg_match_all('@<img\s+.*?(src\s*=\s*("[^"\\\\]*(?:[^"\\\\]*)*"|\'[^\'\\\\]*(?:[^\'\\\\]*)*\'|[^\s]+)).*?>@is', $contents, $match);
    $wtm_count = count($match[1]);

    $marks_image = [];
    for ($k = 0; $k < $wtm_count; $k++) {
        $marks[$k] = str_replace('"', "", $match[1][$k]);
        $marks_image[$k] = str_replace(' /', "", $marks[$k]);
    }

    foreach ($marks_image as $image_path) {
        if (!empty($image_path)) {
            $original_image = basename($image_path);
            $image_extension = strtolower(pathinfo($original_image, PATHINFO_EXTENSION));

            if (in_array($image_extension, ['jpg', 'png', 'gif', 'jpeg'])) {
                $path_file = G5_PATH . '/data/editor/' . date('ym') . '/' . $original_image;
                $path_mark_file = $p_m_file;
                $path_save_file = $path_file;

                apply_watermark($path_file, $path_mark_file, $path_save_file, $_POST['go_pos'], $_POST['go_opt']);
            }
        }
    }
} catch (Exception $e) {
    echo $e->getMessage();
}

// 게시판 첨부 이미지 처리
try {
    $sql_data = "SELECT * FROM " . G5_TABLE_PREFIX . "board_file WHERE bo_table = '$bo_table' AND wr_id = '$wr_id'";
    $res_data = sql_query($sql_data);

    while ($row_data = sql_fetch_array($res_data)) {
        $exp = $row_data['bf_file'];
        $exp_img = strtolower(pathinfo($exp, PATHINFO_EXTENSION));

        if (in_array($exp_img, ['jpg', 'png', 'gif', 'jpeg'])) {
            $path_file = G5_PATH . '/data/file/' . $bo_table . "/" . $row_data['bf_file'];
            $path_mark_file = $p_m_file;
            $path_save_file = $path_file;

            apply_watermark($path_file, $path_mark_file, $path_save_file, $_POST['go_pos'], $_POST['go_opt']);
            }
        }
    } catch (Exception $e) {
        echo $e->getMessage();
    }
}
