<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once($_SERVER['DOCUMENT_ROOT'] . "/jubo/tcpdf/tcpdf.php");
include('connect_pdo.php'); // ݵ echo  Ϸ !

// PDF     !
ob_start(); //  ۸  (ʿ  )

// TCPDF ü 
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('״');
$pdf->SetTitle('PDF ٿε');
$pdf->SetSubject('״ Խñ PDF ȯ');
$pdf->SetKeywords('״, PDF, ٿε');

// ѱ Ʈ  (NanumGothic Ʈ )
$pdf->SetFont('nanumgothic', '', 14);

$pdf->SetMargins(10, 10, 10);
$pdf->AddPage();

$post_id = isset($_GET['wr_id']) ? intval($_GET['wr_id']) : 0;

if ($post_id > 0) {
    $sql = "SELECT wr_subject, wr_content FROM g5_write_basic_original WHERE wr_id = :wr_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':wr_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        //  
        $pdf->Cell(0, 10, $row['wr_subject'], 0, 1, 'C');

        //   (HTML  )
        $pdf->SetFont('nanumgothic', '', 12);
        $pdf->writeHTML(nl2br($row['wr_content']), true, false, true, false, '');

        // ٹٲ ߰
        $pdf->Ln(10);

        // ̹  (g5_board_file ̺ )
        $sql_img = "SELECT bf_file FROM g5_board_file WHERE bo_table = 'basic_original' AND wr_id = :wr_id";
        $stmt_img = $pdo->prepare($sql_img);
        $stmt_img->bindParam(':wr_id', $post_id, PDO::PARAM_INT);
        $stmt_img->execute();

        $image_width = 150; // PDF  ̹ ʺ (mm )
        $image_height = 90; // PDF  ̹  (mm )
        $margin = 10; // ̹  (mm)
        $y_position = $pdf->GetY(); //  Y ǥ 

        while ($img = $stmt_img->fetch(PDO::FETCH_ASSOC)) {
            $image_path = $_SERVER['DOCUMENT_ROOT'] . "/data/file/basic_original/" . $img['bf_file'];

            if (file_exists($image_path)) {
                //  Y ǥ ̹ 
                $pdf->Image($image_path, 30, $y_position, $image_width, $image_height, '', '', 'T', false, 300, '', false, false, 0, false, false, false);

                //  ̹ Y ǥ  ( Y + ̹  + )
                $y_position += $image_height + $margin;
            } else {
                $pdf->Cell(0, 10, "̹  ã  ϴ: " . $img['bf_file'], 0, 1, 'C');
            }
        }
    } else {
        $pdf->Cell(0, 10, 'Խñ ã  ϴ.', 0, 1, 'C');
    }
} else {
    $pdf->Cell(0, 10, '߸ Դϴ.', 0, 1, 'C');
}

//     PDF ٿε
ob_end_clean();
$pdf->Output('download.pdf', 'D');
exit;
?>
