<?php
// select.php

// 데이터베이스 연결 파일 포함
include('connect_pdo.php');

try {
    // SQL 쿼리 작성
    $sql = "SELECT id, chapter, title, mp3, photo, video, first, lyrics FROM aa_praise ORDER BY id ASC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();

    // 데이터 가져오기
    $praises = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("쿼리 오류: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Praise List</title>
    <style>
        /* 기본 스타일 */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f0f0f0;
            text-align: center;
        }
        h1 {
            color: #333;
        }
        table {
            width: 100%;
            max-width: 1000px;
            margin: 0 auto;
            border-collapse: collapse;
            background-color: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 15px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        img {
            max-width: 100px;
            height: auto;
            border-radius: 5px;
        }
        .title-link {
            color: #007BFF;
            text-decoration: none;
            font-weight: bold;
            cursor: pointer;
        }
        .title-link:hover {
            text-decoration: underline;
        }
        /* 모달 스타일 */
        .modal {
            display: none; /* 기본적으로 숨김 */
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto; /* 스크롤 가능 */
            background-color: rgba(0,0,0,0.5); /* 반투명 배경 */
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto; /* 수직 중앙 정렬 */
            padding: 20px;
            border: 1px solid #888;
            width: 90%;
            max-width: 800px;
            border-radius: 10px;
            position: relative;
            text-align: left;
        }
        .close {
            color: #aaa;
            position: absolute;
            top: 15px;
            right: 25px;
            font-size: 30px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
        }
        .media-container {
            position: relative;
            width: 720px;
            height: 405px;
            margin: 0 auto;
        }
        .background-image {
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
        }
        .overlay-video {
            width: 100%;
            height: 100%;
            position: absolute;
            top: 0;
            left: 0;
            mix-blend-mode: screen;
            display: none; /* 기본적으로 숨김 */
        }
        .modal-lyrics {
            margin-top: 20px;
            white-space: pre-wrap;
        }
        /* 반응형 디자인 */
        @media (max-width: 768px) {
            th, td {
                padding: 10px;
            }
            .modal-content {
                width: 95%;
            }
            .media-container {
                width: 100%;
                height: auto;
            }
            .background-image, .overlay-video {
                height: auto;
                padding-top: 56.25%; /* 16:9 비율 */
            }
        }
        @media (max-width: 480px) {
            th, td {
                padding: 8px;
            }
            .modal-content {
                width: 98%;
            }
            .media-container {
                width: 100%;
            }
        }
        /* 디버깅 메시지 스타일 */
        .debug-message {
            color: red;
            font-weight: bold;
            margin-top: 10px;
        }
    </style>
</head>
	
<body>
    <h1>Praise List</h1>
    <?php if (!empty($praises)): ?>
        <table>
            <thead>
                <tr>
                    <th>장</th>
                    <th>제목</th>
                    <th>사진</th>
                    <th>음악</th>
                    <th>가사 첫 줄</th>
                </tr>
            </thead>
			
            <tbody>
                <?php foreach ($praises as $praise): ?>
                    <tr>
						
                        <td><?= htmlspecialchars($praise['chapter']) ?></td>
						
                        <td>
                            <a href="#" class="title-link" 
                               data-title="<?= htmlspecialchars($praise['title']) ?>" 
                               data-mp3="<?= htmlspecialchars($praise['mp3']) ?>" 
                               data-photo="<?= htmlspecialchars($praise['photo']) ?>" 
                               data-video="<?= htmlspecialchars($praise['video']) ?>" 
                               data-lyrics="<?= htmlspecialchars($praise['lyrics']) ?>">
                               <?= htmlspecialchars($praise['title']) ?>
                            </a>
                        </td>
						
                        <td>
                            <?php
                                // 이미지 파일 경로 설정
                                $photoPath = __DIR__ . '/' . $praise['photo'];
                                $photoURL = $praise['photo']; // 웹 URL 경로 (상대 경로)
                                
                                // 디버깅을 위해 절대 경로와 웹 URL 경로 출력
                              //  echo '<div>절대 경로: ' . htmlspecialchars($photoPath) . '</div>';
                              //  echo '<div>웹 URL 경로: ' . htmlspecialchars($photoURL) . '</div>';
                                
                                if (file_exists($photoPath)) {
                                    echo '<img src="' . htmlspecialchars($photoURL) . '" alt="' . htmlspecialchars($praise['title']) . ' 사진">';
                                } else {
                                    echo '<div class="debug-message">사진 파일을 찾을 수 없습니다: ' . htmlspecialchars($praise['photo']) . '</div>';
                                }
                            ?>
                        </td>
						
                        <td>
                            <?php
                                // 음악 파일 경로 설정
                                $mp3Path = __DIR__ . '/' . $praise['mp3'];
                                $mp3URL = $praise['mp3']; // 웹 URL 경로 (상대 경로)
                                
                                // 디버깅을 위해 절대 경로와 웹 URL 경로 출력
                              //  echo '<div>절대 경로: ' . htmlspecialchars($mp3Path) . '</div>';
                              //  echo '<div>웹 URL 경로: ' . htmlspecialchars($mp3URL) . '</div>';
                                
                                if (file_exists($mp3Path)) {
                                    echo '<audio class="row-audio" controls>';
                                    echo '<source src="' . htmlspecialchars($mp3URL) . '" type="audio/mpeg">';
                                    echo 'Your browser does not support the audio element.';
                                    echo '</audio>';
                                } else {
                                    echo '<div class="debug-message">음악 파일을 찾을 수 없습니다: ' . htmlspecialchars($praise['mp3']) . '</div>';
                                }
                            ?>
                        </td>
						
                        <td><?= htmlspecialchars($praise['first']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>데이터가 없습니다.</p>
    <?php endif; ?>

    <!-- 모달 창 -->
    <div id="myModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 id="modalTitle">제목</h2>
            
            <div class="media-container">
                <div class="background-image" style="background-image: url('');"></div>
                <video class="overlay-video" 
                       src="" 
                       autoplay 
                       loop 
                       muted 
                       playsinline>
                    Your browser does not support the video tag.
                </video>
            </div>
            
            <p id="modalLyrics" class="modal-lyrics">가사가 여기에 표시됩니다.</p>
            <audio id="modalAudio" controls>
                <source id="audioSource" src="" type="audio/mpeg">
                Your browser does not support the audio element.
            </audio>
            <div id="modalDebug" class="debug-message"></div>
        </div>
    </div>

    <script>
        // 모달 요소 가져오기
        const modal = document.getElementById("myModal");
        const modalTitle = document.getElementById("modalTitle");
        const backgroundImage = document.querySelector('.background-image');
        const overlayVideo = document.querySelector('.overlay-video');
        const modalLyrics = document.getElementById("modalLyrics");
        const modalAudio = document.getElementById("modalAudio");
        const audioSource = document.getElementById("audioSource");
        const closeBtn = document.getElementsByClassName("close")[0];
        const modalDebug = document.getElementById("modalDebug");

        // 모든 제목 링크에 클릭 이벤트 추가
        const links = document.querySelectorAll('.title-link');
        links.forEach(link => {
            link.addEventListener('click', async (event) => {
                event.preventDefault(); // 기본 링크 동작 방지

                // 데이터 속성에서 정보 가져오기
                const title = link.getAttribute('data-title');
                const mp3 = link.getAttribute('data-mp3');
                const photo = link.getAttribute('data-photo');
                const video = link.getAttribute('data-video');
                const lyrics = link.getAttribute('data-lyrics');

                // 모달 내용 초기화
                modalTitle.textContent = title;
                backgroundImage.style.backgroundImage = "url('')";
                overlayVideo.style.display = "none";
                overlayVideo.src = "";
                modalAudio.style.display = "none";
                modalDebug.innerHTML = "";

                // 사진 설정 및 존재 여부 확인
                if (photo && photo !== '') {
                    if (await fileExists(photo)) { // 상대 경로
                        backgroundImage.style.backgroundImage = `url('${photo}')`;
                    } else {
                        modalDebug.innerHTML += `사진 파일을 찾을 수 없습니다: ${photo}<br>`;
                    }
                }

                // 비디오 설정 및 존재 여부 확인
                if (video && video !== '') {
                    if (await fileExists(video)) { // 상대 경로
                        overlayVideo.src = video;
                        overlayVideo.style.display = "block";
                        overlayVideo.play();
                    } else {
                        modalDebug.innerHTML += `비디오 파일을 찾을 수 없습니다: ${video}<br>`;
                    }
                }

                // 가사 설정
                modalLyrics.textContent = lyrics;

                // 오디오 설정 및 존재 여부 확인
                if (mp3 && mp3 !== '') {
                    if (await fileExists(mp3)) { // 상대 경로
                        audioSource.src = mp3;
                        modalAudio.load();
                        modalAudio.style.display = "block";
                        modalAudio.play();
                    } else {
                        modalDebug.innerHTML += `음악 파일을 찾을 수 없습니다: ${mp3}<br>`;
                    }
                }

                // 모달 표시
                modal.style.display = "block";

                // 기존에 재생 중인 오디오가 있다면 일시 정지

                const audios = document.querySelectorAll('audio');
                audios.forEach(audio => {
                    if (audio !== modalAudio) {
                        audio.pause();
                        audio.currentTime = 0;
                    }
                });
            });
        });

        // 닫기 버튼 클릭 시 모달 닫기
        closeBtn.onclick = function() {
            modal.style.display = "none";
            modalAudio.pause();
            audioSource.src = "";
            overlayVideo.pause();
            overlayVideo.src = "";
            modalDebug.innerHTML = "";
        }

        // 모달 외부 클릭 시 모달 닫기
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
                modalAudio.pause();
                audioSource.src = "";
                overlayVideo.pause();
                overlayVideo.src = "";
                modalDebug.innerHTML = "";
            }
        }

        // 모든 오디오 요소에 이벤트 리스너 추가하여 하나만 재생되도록 함
        const allAudios = document.querySelectorAll('audio');
        allAudios.forEach(audio => {
            audio.addEventListener('play', () => {
                allAudios.forEach(otherAudio => {
                    if (otherAudio !== audio) {
                        otherAudio.pause();
                        otherAudio.currentTime = 0;
                    }
                });
            });
        });

        // JavaScript로 파일 존재 여부 확인 함수 (비동기)
        async function fileExists(url) {
            try {
                const response = await fetch(url, { method: 'HEAD' });
                return response.ok;
            } catch (e) {
                return false;
            }
        }
    </script>
</body>
</html>
