<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
add_stylesheet('<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css">', 0);

?>

<style>
    #multi_type_view {padding: 0 10px;border: none;}
    #multi_type_view button {margin: 5px;padding: 5px;font-size: 12px;cursor: pointer;border: none;border-radius: 5px;background-color: #000;color:#fff;}
    #multi_type_view button:hover {background-color: #ccc;}
    .view-type {display: none;margin-top: 20px;padding: 0px;border: 0px solid #efef;border-radius: 5px;}
    .active {display: block;}
	#bo_btn_top{
	padding:10px;
	}
 </style>
<!-- 게시판 목록 시작 { -->
<div style="padding-left:5px;">
<?php include 'basic_category.php'; ?>
</div>

<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>">	
	<form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
	<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
	<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
	<input type="hidden" name="stx" value="<?php echo $stx ?>">
	<input type="hidden" name="spt" value="<?php echo $spt ?>">
	<input type="hidden" name="sca" value="<?php echo $sca ?>">
	<input type="hidden" name="sst" value="<?php echo $sst ?>">
	<input type="hidden" name="sod" value="<?php echo $sod ?>">
	<input type="hidden" name="page" value="<?php echo $page ?>">
	<input type="hidden" name="sw" value="">
	
	<!-- 게시판 페이지 정보 및 버튼 시작 { -->
    <div id="bo_btn_top">
        <div id="bo_list_total">
            <span>Total <?php echo number_format($total_count) ?>건</span>
            <?php echo $page ?> 페이지
        </div>

        <ul class="btn_bo_user">
        	<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn" title="관리자" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a></li><?php } ?>
			<?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01 btn" title="RSS" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="RSS"><i class="fa fa-rss" aria-hidden="true"></i><span class="sound_only">RSS</span></a></li><?php } ?>
            <li>
            	<button type="button" class="btn_bo_sch btn_b01 btn" title="게시판 검색" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="게시판 검색"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">게시판 검색</span></button>
            </li>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
        	<?php if ($is_admin == 'super' || $is_auth) {  ?>
        	<li>
        		<button type="button" class="btn_more_opt is_list_btn btn_b01 btn" title="게시판 리스트 옵션" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="게시판 리스트 옵션"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트 옵션</span></button>
        		<?php if ($is_checkbox) { ?>
		        <ul class="more_opt is_list_btn">
		            <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><i class="fa fa-trash-o" aria-hidden="true"></i> 선택삭제</button></li>
		            <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"><i class="fa fa-files-o" aria-hidden="true"></i> 선택복사</button></li>
		            <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"><i class="fa fa-arrows" aria-hidden="true"></i> 선택이동</button></li>
		        </ul>
		        <?php } ?>
        	</li>
        	<?php }  ?>
        </ul>
    </div>
    <!-- } 게시판 페이지 정보 및 버튼 끝 -->
    <div id="multi_type_view">
        <button  type="button" id="default-btn" onclick="changeView('default')" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="기본형보기" aria-label="기본형보기">기본형보기</button>
        <button  type="button" id="list-btn"  onclick="changeView('list')"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="리스트형보기" aria-label="리스트형보기">리스트형보기</button>
        <button  type="button" id="gallery-btn" onclick="changeView('gallery')"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="앨범형보기" aria-label="앨범형보기">앨범형보기</button>
        <button  type="button" id="webzine-btn"  onclick="changeView('webzine')"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="웹진형보기" aria-label="웹진형보기">웹진형보기</button>
    </div>   	
    

    <div id="default" class="view-type active">
        <?php include 'default_view.php'; ?>
    </div>
    <div id="list" class="view-type">
        <?php include 'list_view.php'; ?>
    </div>
    <div id="gallery" class="view-type">
        <?php include 'gallery_view.php'; ?>
    </div>
    <div id="webzine" class="view-type">
        <?php include 'webzine_view.php'; ?>
    </div>
	

	
	 
	</form>
	<?php if ($list_href || $is_checkbox || $write_href) { ?>
    <div class="bo_fx">
        <?php if ($list_href || $write_href) { ?>
        <ul class="btn_bo_user">
        	<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn" title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a></li><?php } ?>
            <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_b01 btn" title="RSS"><i class="fa fa-rss" aria-hidden="true"></i><span class="sound_only">RSS</span></a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <?php } ?>
	
	<!-- 페이지 -->
	<?php echo $write_pages; ?>
	<!-- 페이지 -->
    <!-- 게시판 검색 시작 { -->
    <div class="bo_sch_wrap ">
    <fieldset class="bo_sch">
        <h3>검색</h3>
        <form name="fsearch" method="get">
            <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
            <input type="hidden" name="sca" value="<?php echo $sca ?>">
            <input type="hidden" name="sop" value="and">
            <label for="sfl" class="sound_only">검색대상</label>
            <select name="sfl" id="sfl">
                <option value="wr_3" <?php echo get_selected($sfl, 'wr_3'); ?>>주소</option>
                <?php echo get_board_sfl_select_options($sfl); ?>
            </select>
            <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
            <div class="sch_bar ">
                <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx"
                    class="frm_input sch_input" size="25" maxlength="20" placeholder=" 검색어를 입력해주세요">
                <button type="submit" value="검색" class="sch_btn "><i class="bi bi-search" aria-hidden="true"></i><span class="sound_only">검색</span></button>
            </div>
            <button type="button" class="bo_sch_cls" title="닫기"><i class="bi bi-x-lg" aria-hidden="true"></i><span class="sound_only">닫기</span></button>
        </form>
    </fieldset>
    <div class="bo_sch_bg"></div>
</div>
<script>
jQuery(function($) {
    // 게시판 검색
    $(".btn_bo_sch").on("click", function() {
        $(".bo_sch_wrap").toggle();
    })
    $('.bo_sch_bg, .bo_sch_cls').click(function() {
        $('.bo_sch_wrap').hide();
    });
});
</script>
    <!-- } 게시판 검색 끝 --> 
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
<!------멀티타입 보기---{---->
<script>
// 현재 보기 타입을 변경하는 함수
function changeView(viewType) {
    // 모든 보기 타입을 숨김
    const views = document.querySelectorAll('.view-type');
    views.forEach(view => view.classList.remove('active'));

    // 선택한 보기 타입을 보임
    const selectedView = document.getElementById(viewType);
    if (selectedView) {
        selectedView.classList.add('active');
        // 현재 보기 타입을 로컬 스토리지에 저장
        localStorage.setItem('currentView', viewType);
    }
        
}

// 페이지 로드 시 저장된 보기 타입을 불러옴
window.onload = function() {
    const currentView = localStorage.getItem('currentView') || 'default';
    changeView(currentView);
};

// 버튼 클릭 이벤트
document.addEventListener('DOMContentLoaded', function() {
    const defaultBtn = document.getElementById('default-btn');
    const listBtn = document.getElementById('list-btn');
    const galleryBtn = document.getElementById('gallery-btn');
    const webzineBtn = document.getElementById('webzine-btn');

    if (defaultBtn) {
        defaultBtn.addEventListener('click', () => changeView('default'));
    }
    if (listBtn) {
        listBtn.addEventListener('click', () => changeView('list'));
    }
    if (galleryBtn) {
        galleryBtn.addEventListener('click', () => changeView('gallery'));
    }
    if (webzineBtn) {
        webzineBtn.addEventListener('click', () => changeView('webzine'));
    }
});
</script>
<!------멀티타입 보기---}--->

 <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
 <script>
      Fancybox.bind('[data-fancybox="gallery"]', {
        Toolbar: {
          display: {
            left: ["infobar"],
            middle: [
              "zoomIn",
              "zoomOut",
              "toggle1to1",
              "rotateCCW",
              "rotateCW",
              "flipX",
              "flipY",
            ],
            right: ["slideshow", "download", "thumbs", "close"],
          },
        },
      });    
    </script>