<?php
if (!defined('_GNUBOARD_')) exit;
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/ix_list.css">', 0);
?>

<!------------------------------------
IX Skin Design - Board [List]
-------------------------------------->

<!--시작 -->
<div id="ix_bbs_list"> 

<!-- 1. 상단 ------->
<section id="bl_sec_top">
<!-- 1-1. 카테고리 -->
<div id="bl_cate">
     <?php if ($is_category) { ?>
     <ul>
     <?php echo $category_option; ?>
     </ul>
     <?php } ?>
</div>

<!-- 1-2. 토탈 -->
<div id="bl_total"> Total <span><?php echo number_format($total_count); ?></span>/<span><?php echo $page; ?></span>Page</div>
<!-- 1-3. 정렬 -->
<?php
$current_sort = isset($_GET['sst']) ? $_GET['sst'] : ''; // 현재 정렬 상태 감지
?>

<div id="bl_sort">
     <?php echo subject_sort_link('wr_hit', $qstr2, 1); ?><div class="ls_hit <?php echo ($current_sort == 'wr_hit') ? 'ls_active' : ''; ?>">조회</div></a>
     <?php if ($is_good) { ?>
     <?php echo subject_sort_link('wr_good', $qstr2, 1); ?><div class="ls_rec <?php echo ($current_sort == 'wr_good') ? 'ls_active' : ''; ?>">추천</div></a>
     <?php } ?>
     <?php echo subject_sort_link('wr_datetime', $qstr2, 1); ?><div class="ls_date <?php echo ($current_sort == 'wr_datetime') ? 'ls_active' : ''; ?>">작성일</div></a>
</div>
<!-- 1-4. 관리자 버튼 -->
<?php if ($admin_href) { ?>
<div id="bl_admin"> 
     <a href="<?php echo $admin_href; ?>" title="관리자" class="bl_btn_adm" target="_blank"><i class="fa-solid fa-gear"></i></a>
     <a href="javascript:void(0);" id="chkall" class="bl_btn_chk" onclick="toggleCheckbox();"><i class="fa-solid fa-check"></i></a>
</div>
<?php } ?>
</section>

<!-- 2. 중간 (리스트) ------->
<form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="spt" value="<?php echo $spt ?>">
<input type="hidden" name="sca" value="<?php echo $sca ?>">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="sw" value="">
<section id="bl_sec_list">
<?php
// 리스트 개수 저장하여 count() 호출 최적화
$list_count = count($list);

// 현재 리스트의 wr_id 목록을 배열로 저장
$wr_ids = array_column($list, 'wr_id');
$fileData = [];
$imageExtensions = 'jpg|jpeg|png|gif';

if (!empty($wr_ids)) {
    $wr_id_list = implode(',', array_map('intval', $wr_ids)); // SQL 인젝션 방지를 위해 int 변환
    $sql = "SELECT wr_id, bf_source FROM g5_board_file 
                WHERE bo_table = '{$bo_table}' 
                AND wr_id IN ({$wr_id_list}) 
                ORDER BY bf_no";

    $fileResults = sql_query($sql);

    while ($row = sql_fetch_array($fileResults)) {
        $fileData[$row['wr_id']][] = $row['bf_source'];
    }
}
?>
<ul id="bl_list">
<?php for ($i = 0; $i < count($list); $i++) { ?>
<?php
     preg_match('/#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})/', strip_tags($list[$i]['wr_9']), $matches);
     $color_code = isset($matches[0]) ? $matches[0] : '#FFFFFF';
?>
    <li id="li_post" class="<?= $list[$i]['is_notice'] ? 'li_notice' : ''; ?>"  style="background-color: <?php echo strip_tags($color_code); ?>;">
          <?php if ($is_checkbox): ?>
         <div id="lp_check"><input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id']; ?>" id="chk_wr_id_<?php echo $i; ?>"></div>
         <?php endif; ?>
          <div id="lp_cont">
                    <div id="lc_head">
                         <?php if ($is_category) { ?>
                         <?php if (!empty($list[$i]['ca_name'])) { ?>
                         <div class="lch_cate"><a href="<?php echo $list[$i]['ca_name_href']; ?>"><?php echo $list[$i]['ca_name']; ?></a></div>
                         <?php } ?>
                         <?php } ?>
                         <div class="lch_title"><a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['subject'] ?> </a>
               <?php
               //     새 글 아이콘 출력
               if (!empty($list[$i]['icon_new'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_new.png">';
               }

               //     파일 및 이미지 아이콘 처리
               $hasImage = false;
               $hasFile = false;
               if (!empty($fileData[$list[$i]['wr_id']])) {
                    foreach ($fileData[$list[$i]['wr_id']] as $fileInfo) {
                         if (preg_match("/\.($imageExtensions)$/i", $fileInfo)) {
                              $hasImage = true;
                         }
                         if (!preg_match("/\.($imageExtensions)$/i", $fileInfo)) {
                              $hasFile = true;
                         }
                    }
               }
               if ($hasImage) {
                    echo '<img src="' . $board_skin_url . '/img/ico_img.png">';
               }
               if ($hasFile) {
                    echo '<img src="' . $board_skin_url . '/img/ico_file.png">';
               }
              
               //     추가 아이콘 출력
               if (!empty($list[$i]['icon_hot'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_hot.png">';
               }
               if (!empty($list[$i]['icon_link'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_link.png">';
               }
               ?>                      
                         
                         </div>

                         <?php 
                         $important_icon = ($list[$i]['wr_8'] == 1) ? '<img src="'.$board_skin_url.'/img/ico_important.png">' : ''; 
                         ?>
                         <div class="lch_img"><?php echo $important_icon; ?></div>        
                    </div>
                    
                    <!-- 콘텐츠 미리보기 -->
                    <div 
                        id="lc_text" 
                        class="content-preview" 
                        onclick="openModal(this)" 
                        data-content="<?= htmlspecialchars($list[$i]['wr_content']) ?>" 
                        data-title="<?= htmlspecialchars($list[$i]['subject']) ?>"
                        data-important="<?= $list[$i]['wr_8'] == 1 ? 'true' : 'false'; ?>">
                         <?php echo nl2br($list[$i]['wr_content']); ?>
                    </div>

                    <div id="lc_info">
                              <div class="lci_name">
                              <span class="lcn_name"><i class='fa-solid fa-user'></i><?php echo $list[$i]['name']; ?></span>
                              <span class="lcn_date"><?php echo date('y.m.d. H:i', strtotime($list[$i]['wr_datetime'])); ?></span>
                              </div>
                              <div class="lci_count">
                              <?php if ($list[$i]['comment_cnt']) { ?><i class="fa-regular fa-comment"></i><span><?php echo $list[$i]['wr_comment']; ?></span><?php } ?>
                              <?php if ($is_good && $list[$i]['wr_good'] > 0) { ?><i class="fa-regular fa-thumbs-up"></i><span><?php echo $list[$i]['wr_good'] ?></span><?php } ?>
                              <i class="fa-solid fa-book-open-reader"></i><span><?php echo $list[$i]['wr_hit'] ?></span>
                    </div>
          </div>
    </li>
<?php } ?>
<?php if (count($list) == 0) { echo "<li class=\"li_empty\">게시물이 없습니다.</li>"; } ?>
</ul>
</section>

<!-- 모달 창 (반복문 밖에서 단 하나만 존재) -->
<article id="contentModal" class="ict_modal" style="display: none;" onclick="closeModalOnBackgroundClick(event)">
    <div class="icm_rap">
        <div id="icm_title">
            <i class="fa-regular fa-message"></i> <span id="modalTitle"></span>
            <span id="modalImportant"></span> <!-- 중요 아이콘 표시 -->
        </div>
        <div id="icm_memo_box">
            <div id="icm_memo"></div>
        </div>
        <span class="icm_btn_close" onclick="closeModal()">
            <i class="fa-solid fa-xmark"></i>
        </span>
    </div>
</article>

<!-- JavaScript -->
<script>
function openModal(element) {
    const icm_memo = element.getAttribute("data-content"); // 전체 내용 가져오기
    const icm_title = element.getAttribute("data-title"); // 제목 가져오기
    const isImportant = element.getAttribute("data-important"); // 중요 여부

    // 모달 내용 및 제목 삽입
    document.getElementById("icm_memo").innerHTML = icm_memo.replace(/\n/g, "<br>");
    document.getElementById("modalTitle").innerText = icm_title;

    // 중요 아이콘 표시 여부
    if (isImportant === "true") {
        document.getElementById("modalImportant").innerHTML = '<img src="<?php echo $board_skin_url; ?>/img/ico_important.png">';
    } else {
        document.getElementById("modalImportant").innerHTML = ''; // 중요 아이콘 제거
    }

    document.getElementById("contentModal").style.display = "block"; // 모달 열기
}

function closeModal() {
    document.getElementById("contentModal").style.display = "none"; // 모달 닫기
}

// 배경 클릭 시 모달 닫기
function closeModalOnBackgroundClick(event) {
    const modalContent = document.querySelector(".icm_rap");
    
    // 클릭한 요소가 모달 내용(.icm_rap) 바깥이면 모달 닫기
    if (!modalContent.contains(event.target)) {
        closeModal();
    }
}
</script>


<!-- 3. 하단 (검색, 버튼) ------->
<section id="bl_sec_bt">
<!-- 3-1. 버튼 -->
<div id="bl_btn">
     <?php if ($is_admin == 'super' || $is_auth) {  ?>
     <?php if ($is_checkbox) { ?>    
     <button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value">삭제</button>
     <button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value">복사</button>
     <button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value">이동</button>
     <?php } ?>
     <?php }  ?>
     <?php if ($write_href) { ?>
          <a href="<?php echo $write_href ?>"  title="글쓰기">글쓰기</a></li>
     <?php } ?>
</div>
</form> 
<!-- 3-2. 검색 -->
<div id="bl_sch">
          <form name="fsearch" method="get">
          <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
          <input type="hidden" name="sca" value="<?php echo $sca ?>">
          <input type="hidden" name="sop" value="and">
          <select name="sfl" id="sfl">
               <option value="wr_subject"<?php echo get_selected($sfl, "wr_subject") ?>>제목</option>
               <option value="wr_content"<?php echo get_selected($sfl, "wr_content") ?>>내용</option>
               <option value="wr_subject||wr_content"<?php echo get_selected($sfl, "wr_subject||wr_content") ?>>제목+내용</option>
          </select>
          <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="bl_ip_sch" size="25" maxlength="20" placeholder="">
          <button type="submit" value="검색" class="bl_btn_sch"><i class="fa fa-search" aria-hidden="true"></i></button>
          </form>
</div>
</section>


</form> 
<!-- 4. 페이지 ------->
<?php if (!empty($write_pages)) : ?>
<section id="bl_sec_page">
<?php echo $write_pages; ?>
</section>
<?php endif; ?>

</div> 
<!--끝 -->


<?php if ($is_checkbox) { ?>
<script>
//전체 체크 버튼
function toggleCheckbox() {
    let checkboxes = document.querySelectorAll("input[name='chk_wr_id[]']");
    let isChecked = checkboxes.length > 0 && [...checkboxes].every(cb => cb.checked);

    checkboxes.forEach(cb => cb.checked = !isChecked);
}
function fboardlist_submit(f) {
    var chk_count = 0;
    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }
    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }
    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }
    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }
    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }
    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;
    if (sw == "copy")
        str = "복사";
    else
        str = "이동";
    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");
    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}
</script>
<?php } ?>