<?php
if (!defined("_GNUBOARD_")) exit;
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/ix_view.css">', 0);
?>
<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<!------------------------------------
IX Skin Design - Board [View]
-------------------------------------->

<!-- 시작 -->
<div id="ix_bbs_view"> 


<!-- 1. 상단 (카테고리, 제목, 작성일, 상단버튼) ------->
<section id="bv_sec_top">
<!-- 1-1. 카테고리 -->
<?php if ($category_name) { ?>
<div id="bv_cate"><span><?php echo $view['ca_name']; ?></span> </div>
<?php } ?>
<!-- 1-2. 글제목 -->
<div id="bv_title"><?php echo cut_str(get_text($view['wr_subject']), 70); // 글제목 출력 ?></div>
<!-- 1-3. 작성일 -->
<div id="bv_date">
     <span>작성일 : <?php echo date("y.m.d. H:i", strtotime($view['wr_datetime'])) ?></span>
     <?php
     $created_at = strtotime($view['wr_datetime']); // 작성일 (Unix 타임스탬프)
     $updated_at = strtotime($view['wr_10']); // 수정일 (Unix 타임스탬프)
     $time_difference = $updated_at - $created_at; // 두 시간의 차이 (초 단위)
     // 수정일이 작성일보다 1시간(3600초) 이상 클 경우에만 출력
     if ($time_difference > 3600) {
         echo '<span>수정일 : ' . date("y.m.d. H:i", $updated_at) . '</span>';
     }
     ?>
</div>

<!-- 1-4. 프로필, 상단버튼 -->
<div id="bv_tool">
     <div id="vt_profile">
          <div id="vp_img"><?php echo get_member_profile_img($view['mb_id']) ?></div>
          <div id="vp_info">
               <?php echo $view['name'] ?>
               <span class="vi_hit"><i class="fa-solid fa-book-open-reader"></i><?php echo $view['wr_hit'] ?></span>
               <span class="vi_ip"><?php if ($is_ip_view) { echo "[$ip]"; } ?></span>
          </div>
     </div>
     
     <div id="vt_btn">
          <div id="vb_etc">
               <a href="#" onclick="clip(); return false;" class="clip" title="주소복사"><i class="fa fa-link" aria-hidden="true"></i></a>
               <?php if ($scrap_href) { ?><a href="<?php echo $scrap_href;  ?>" target="_blank" onclick="win_scrap(this.href); return false;"  title="스크랩"><i class="fa-solid fa-bookmark"></i> </a><?php } ?>
          </div>
          <?php if($update_href || $delete_href || $copy_href || $move_href) { ?>
          <div id="vb_adm">
               <?php if ($copy_href) { ?><a href="<?php echo $copy_href ?>" onclick="board_move(this.href); return false;" title="복사"><i class="fa-regular fa-copy"></i></a><?php } ?>
               <?php if ($move_href) { ?><a href="<?php echo $move_href ?>" onclick="board_move(this.href); return false;" title="이동"><i class="fa-solid fa-up-down-left-right"></i></a><?php } ?>
               <?php if ($update_href) { ?><a href="<?php echo $update_href ?>"  title="수정"><i class="fa-solid fa-wrench"></i></a><?php } ?>
               <?php if ($delete_href) { ?><a href="<?php echo $delete_href ?>" onclick="del(this.href); return false;" title="삭제"><i class="fa-solid fa-trash"></i></a><?php } ?>
               <?php if ($admin_href) { ?><a href="<?php echo $admin_href ?>" title="관리자" class="bv_btn_admin" target="_blank"><i class="fa-solid fa-gear"></i></a><?php } ?>
          </div>
          <?php } ?> 
          <div id="vb_user">
               <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" title="글쓰기"><i class="fa-solid fa-pen-nib"></i></a><?php } ?>
               <a href="<?php echo $list_href ?>" title="목록"><i class="fa-solid fa-list"></i></a>
          </div>
     </div>
</div>
</section>


<!-- 2. 첨부 (파일) ------->
<?php
$cnt = 0;
if ($view['file']['count']) {
    for ($i=0; $i<count($view['file']); $i++) {
        if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view'])
            $cnt++;
    }
} ?>
<?php if($cnt) { ?>
<section id="bv_sec_attach">
      <ul>
          <?php
          // 가변 파일
          for ($i=0; $i<count($view['file']); $i++) {
               if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
          ?>
          <li id="li_attach">
               <div class="va_icon"><i class="fa-regular fa-folder"></i></div>
               <div class="va_line"></div>
               <div class="va_data"><a href="<?php echo $view['file'][$i]['href']; ?>"> <?php echo $view['file'][$i]['source'] ?><?php echo $view['file'][$i]['content'] ?></a><span>( <?php echo $view['file'][$i]['size'] ?> )</span></div>
               <div class="va_time"><?php echo date("y.m.d. H:i", strtotime($view['file'][$i]['datetime'])); ?></div>
               <div class="va_line"></div>
               <div class="va_info"><?php echo $view['file'][$i]['download'] ?></div>
          </li>
          <?php } } ?>
     </ul>
</section>
<?php } ?>


<!-- 3. 첨부 (링크) ------->
<?php if(isset($view['link']) && array_filter($view['link'])) { ?>
<section id="bv_sec_attach">
      <ul>
          <?php
          $cnt = 0;
          for ($i=1; $i<=count($view['link']); $i++) {
          if ($view['link'][$i]) {
               $cnt++;
               $link = cut_str($view['link'][$i], 70);
          ?>
          <li id="li_attach">
               <div class="va_icon"><i class="fa fa-link" aria-hidden="true"></i></div>
               <div class="va_line"></div>
               <div class="va_link"><a href="<?php echo $view['link_href'][$i] ?>" target="_blank"><?php echo $link ?></a></div>
               <div class="va_line"></div>
               <div class="va_info"><?php echo $view['link_hit'][$i] ?></div>
          </li>
          <?php } } ?>
     </ul>
</section>
<?php } ?>


<!-- 4. 본문 ------->
<section id="bv_sec_article">
<div id="bv_d-day">
    <?php
    // 서버의 현재 날짜 (시간 무시)
    $current_date = new DateTime();
    $current_date->setTime(0, 0, 0); // 시간을 00:00:00으로 고정

    $wr_9_date = $view['wr_9']; // 게시물 날짜 (예: '2025-03-31')

    $class = ""; // 기본 클래스 초기화
    $d_day_display = ""; // D-Day 텍스트 초기화

    if (!empty($wr_9_date)) {
        // 목표 날짜 설정 (시간 무시)
        $target_date = new DateTime($wr_9_date);
        $target_date->setTime(0, 0, 0); // 시간을 00:00:00으로 고정

        // 날짜 차이 계산 (시간 무시)
        $interval = $current_date->diff($target_date);
        $remaining_days = (int) $interval->format('%r%a'); // 양수: 미래, 음수: 과거, 0: 오늘

        if ($remaining_days == 0) {
            // 목표 날짜가 오늘인 경우
            $class = "vda_today";
            $d_day_display = '<div class="vdm_today">Today</div>';
        } elseif ($remaining_days > 0) {
            // 목표 날짜가 미래인 경우 (D-)
            $class = "vda_day";
            $d_day_display = '<div class="vdm_day">D-<span>' . $remaining_days . '</span></div>';
        } else {
            // 목표 날짜가 과거인 경우 (D+)
            $class = "vda_after";
            $d_day_display = '<div class="vdm_after">D+<span>' . abs($remaining_days) . '</span></div>';
        }
    }
    ?>
     <div id="vd_day_box" class="<?php echo $class; ?>">
          <div class="vd_display">
               <?php 
               // 요일을 한글로 표시
               $days = ['일', '월', '화', '수', '목', '금', '토'];
               $dayOfWeek = date('w', strtotime($view['wr_9']));
               echo date("y.m.d", strtotime($view['wr_9'])) . " (" . $days[$dayOfWeek] . ")";
               ?>
          </div>
          <div class="vd_count"><?php echo $d_day_display; ?></div>
     </div>
</div>

<div id="bv_article_rap">
     <?php
     // 파일 출력 (첨부 이미지)
     $thumbnails = array_filter(array_map('get_file_thumbnail', $view['file'] ?? []));
     if (!empty($thumbnails)) {
         echo '<div id="bv_img">';
         foreach ($thumbnails as $thumbnail) {
             echo $thumbnail;
         }
         echo '</div>';
     }
     ?>
     <?php
     // 유튜브 링크 추출 함수
     function get_youtube_embed_url($url) {
         if (!empty($url)) {
             $clean_url = strtok(trim($url), "&"); // 불필요한 파라미터 제거

             // 유튜브 영상 ID 추출 (다양한 링크 지원)
             if (preg_match('/(?:youtu\.be\/|youtube\.com\/(?:.*[?&]v=|embed\/|v\/|shorts\/|.*[?&]vi=))([a-zA-Z0-9_-]{11})/', $clean_url, $matches)) {
                 $video_id = $matches[1] ?? '';
                 if (!empty($video_id)) {
                     return "https://www.youtube.com/embed/" . htmlspecialchars($video_id, ENT_QUOTES, 'UTF-8');
                 }
             }
         }
         return ''; // 유튜브 링크가 아니면 빈 값 반환
     }

     // 유튜브 영상 URL 배열
     $embed_urls = [];

     // wr_link1과 wr_link2에서 유튜브 영상 URL을 추출하여 배열에 추가
     $embed_urls[] = get_youtube_embed_url($view['wr_link1']);
     $embed_urls[] = get_youtube_embed_url($view['wr_link2']);

     // 배열에서 빈 값 제거
     $embed_urls = array_filter($embed_urls);
     ?>
     
     <!-- 유튜브 영상 출력 (여러 개일 경우 모두 출력) -->
     <?php if (!empty($embed_urls)) : ?>
     <?php foreach ($embed_urls as $embed_url): ?>
     <div id="bv_ytv">
          <div class="vy_box">
              <iframe src="<?= $embed_url; ?>" frameborder="0" allowfullscreen></iframe>
          </div>
     </div>
     <?php endforeach; ?>
     <?php endif; ?>

     <!-- 본문 내용 출력 -->
     <div id="bv_article">
          <?= get_view_thumbnail($view['content']); ?>
     </div>
</div>
</section>



<!-- 5. 추천 ------->
<section id="bv_sec_rec">
          <?php if ($good_href) { ?>
          <div id="bv_rec_on">
               <span><a href="<?php echo $good_href.'&amp;'.$qstr ?>" id="good_button"><i class="fa-regular fa-thumbs-up"></i><strong><?php echo number_format($view['wr_good']) ?></strong></a></span>
          </div>
          <?php } else { if ($board['bo_use_good']) { ?>
          <div id="bv_rec_off">
               <?php if($board['bo_use_good']) { ?><span><i class="fa-regular fa-thumbs-up"></i><strong><?php echo number_format($view['wr_good']) ?></strong></span><?php } ?>
          </div>
          <?php } } ?>
          <div id="bv_rec_msg"><span id="rec_good"></span></div>
</section>


<!-- 6. 서명 ------->
<?php if ($is_signature && !empty($signature)) { ?>
<section id="bv_sec_sign">
    <div id="bv_sign"><?php echo nl2br($signature); ?></div>
</section>
<?php } ?>


<!-- 7. 코멘트 ------->
<?php    // 코멘트 입출력
    include_once(G5_BBS_PATH.'/view_comment.php');
?>


<!-- 8. 하단 버튼------->
<section id="bv_sec_bt">
<div id="bv_btnl">
     <?php if($update_href || $delete_href) { ?>
     <?php if ($delete_href) { ?><a href="<?php echo $delete_href ?>" onclick="del(this.href); return false;" title="삭제">삭제</a><?php } ?><?php if ($update_href) { ?><a href="<?php echo $update_href ?>"  title="수정">수정</a><?php } ?>
     <?php } ?>
</div>

<div id="bv_btnr">
     <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" title="글쓰기">글쓰기</a><?php } ?><a href="<?php echo $list_href ?>" title="목록">목록</a>
</div>
</section>


<!-- 9. 이전글, 다음글------->
<?php if ($prev_href || $next_href) { ?>
<section id="bv_sec_np">
<div id="bv_np"> 
     <?php if ($prev_href) { ?>
     <a href="<?php echo $prev_href ?>" id="bv_prev">
               <div class="vnp_icon"><i class="fa-solid fa-chevron-left"></i></div>
               <div class="vnp_title">
                    <span><?php echo $prev_wr_subject;?></span>
               </div>
     </a>
     <?php } ?>
</div>
<div id="bv_np"> 
     <?php if ($next_href) { ?>
     <a href="<?php echo $next_href ?>" id="bv_next">
               <div class="vnp_title">
                    <span><?php echo $next_wr_subject;?></span>
               </div>
               <div class="vnp_icon"><i class="fa-solid fa-chevron-right"></i></div>
     </a>
     <?php } ?>
</div>
</section>
<?php } ?>

</div> 
<!-- 끝 -->


<script>
// clip() 함수
function clip() {
    var url = ''; // URL을 저장할 변수 선언
    var textarea = document.createElement("textarea"); // 임시 textarea 엘리먼트 생성

    document.body.appendChild(textarea); // textarea 엘리먼트를 body에 추가
    url = window.document.location.href; // 현재 페이지의 URL을 가져와서 변수에 저장
    textarea.value = url; // textarea의 값에 URL 설정
    textarea.select(); // textarea 내용을 선택
    document.execCommand("copy"); // 복사 명령어 실행
    document.body.removeChild(textarea); // textarea 엘리먼트 제거

    alert("URL이 복사되었습니다."); // 사용자에게 복사 완료 메시지 표시
}
</script>

<script>
<?php if ($board['bo_download_point'] < 0) { ?>
$(function() {
    $("a.view_file_download").click(function() {
        if(!g5_is_member) {
            alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
            return false;
        }

        var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

        if(confirm(msg)) {
            var href = $(this).attr("href")+"&js=on";
            $(this).attr("href", href);

            return true;
        } else {
            return false;
        }
    });
});
<?php } ?>

function board_move(href)
{
    window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>

<script>
$(function() {
    $("a.view_image").click(function() {
        window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
        return false;
    });

    // 추천, 비추천
    $("#good_button, #nogood_button").click(function() {
        var $tx;
        if(this.id == "good_button")
            $tx = $("#rec_good");
        else
            $tx = $("#rec_nogood");

        excute_good(this.href, $(this), $tx);
        return false;
    });

    // 이미지 리사이즈
    $("#bo_v_atc").viewimageresize();
});

function excute_good(href, $el, $tx)
{
    $.post(
        href,
        { js: "on" },
        function(data) {
if(data.error) {
        $tx.text(data.error);
        $tx.fadeIn(0).delay(5000).fadeOut(0);
        return false;
            }

            if(data.count) {
                $el.find("strong").text(number_format(String(data.count)));
                if($tx.attr("id").search("nogood") > -1) {
                    $tx.text("이 글을 비추천하셨습니다.");
                    $tx.fadeIn(0).delay(5000).fadeOut(0);
                } else {
                    $tx.text("이 글을 추천하셨습니다.");
                    $tx.fadeIn(0).delay(5000).fadeOut(0);
                }
            }
        }, "json"
    );
}
</script>

<script>
$(document).ready(function() {
    // good_button 클릭 시 rec_msg 출력
    $("#good_button").click(function() {
        // 메시지 표시
        $("#bv_rec_msg").fadeIn(300).delay(2500).fadeOut(300);
    });
});
</script>