<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/ix_comment.css">', 0);
?>

<!-----------------------------------------
IX Skin Design - Board [Comment]
------------------------------------------->
<script>
// 글자수 제한
var char_min = parseInt(<?php echo $comment_min ?>); // 최소
var char_max = parseInt(<?php echo $comment_max ?>); // 최대
</script>

<!-- A. 리스트 시작 -->
<!-- A1. 댓글 카운트 -->
<div id="cl_count">
     <div><span><?php echo $view['wr_comment']; ?></span>개의 댓글</div>
</div>
<!-- A2. 댓글 리스트 -->
<section id="cmt_list">
<?php
$cmt_amt = count($list);
for ($i=0; $i<$cmt_amt; $i++) {
     $comment_id = $list[$i]['wr_id'];
     $cmt_depth = strlen($list[$i]['wr_comment_reply']) * 50;
     $comment = $list[$i]['content'];
     $comment = preg_replace("/\[\<a\s.*href\=\"(http|https|ftp|mms)\:\/\/([^[:space:]]+)\.(mp3|wma|wmv|asf|asx|mpg|mpeg)\".*\<\/a\>\]/i", "<script>doc_write(obj_movie('$1://$2.$3'));</script>", $comment);
     $cmt_sv = $cmt_amt - $i + 1; // 댓글 헤더 z-index 재설정 ie8 이하 사이드뷰 겹침 문제 해결
     $c_reply_href = $comment_common_url.'&amp;c_id='.$comment_id.'&amp;w=c#bo_vc_w';
     $c_edit_href = $comment_common_url.'&amp;c_id='.$comment_id.'&amp;w=cu#bo_vc_w';
     $is_comment_reply_edit = ($list[$i]['is_reply'] || $list[$i]['is_edit'] || $list[$i]['is_del']) ? 1 : 0;
?>
<!-- A2. 댓글 리스트 -->
<article id="c_<?php echo $comment_id ?>" <?php if ($cmt_depth) { ?>style="margin-left:<?php echo $cmt_depth ?>px;"<?php } ?>>
     <header id="cl_head">
          <?php echo get_member_profile_img($list[$i]['mb_id']); ?>
          <span class="ch_name"><?php echo $list[$i]['name'] ?></span>
          <span class="ch_ip"><?php if ($is_ip_view) { ?>[<?php echo $list[$i]['ip']; ?>]<?php } ?></span>
          <span class="ch_date"><?php echo date("y.m.d. H:i", strtotime($list[$i]['datetime'])) ?></span>
     </header>
     <div id="cl_view">
          <?php if (strstr($list[$i]['wr_option'], "secret")) { ?><img src="<?php echo $board_skin_url; ?>/img/icon_secret.gif" alt="비밀글"><?php } ?>
          <?php echo $comment ?>
          <?php if($is_comment_reply_edit) {
               if($w == 'cu') {
                    $sql = " select wr_id, wr_content, mb_id from $write_table where wr_id = '$c_id' and wr_is_comment = '1' ";
                    $cmt = sql_fetch($sql);
                    if (isset($cmt)) {
                         if (!($is_admin || ($member['mb_id'] == $cmt['mb_id'] && $cmt['mb_id']))) {
                              $cmt['wr_content'] = '';
                         }
                         $c_wr_content = $cmt['wr_content'];
                    }
               }
          } ?>
     </div>
     <div id="cl_edit">
          <span id="edit_<?php echo $comment_id ?>" class="bo_vc_w"></span><!-- 수정 -->
          <span id="reply_<?php echo $comment_id ?>" class="bo_vc_w"></span><!-- 답변 -->

          <input type="hidden" value="<?php echo strstr($list[$i]['wr_option'],"secret") ?>" id="secret_comment_<?php echo $comment_id ?>">
          <textarea id="save_comment_<?php echo $comment_id ?>" style="display:none"><?php echo get_text($list[$i]['content1'], 0) ?></textarea>
     </div>
     <?php if($is_comment_reply_edit) { ?>
     <div id="cl_btn">
          <button type="button" class="cl_btn_open"><i class="fa-solid fa-ellipsis-vertical"></i></button>
          <ul class="cb_box">
               <?php if ($list[$i]['is_reply']) { ?>
                    <li><a href="<?php echo $c_reply_href; ?>" onclick="comment_box('<?php echo $comment_id ?>', 'c'); return false;">답변</a></li>
               <?php } ?>
               <?php if ($list[$i]['is_edit']) { ?>
                    <li><a href="<?php echo $c_edit_href; ?>" onclick="comment_box('<?php echo $comment_id ?>', 'cu'); return false;">수정</a></li>
               <?php } ?>
               <?php if ($list[$i]['is_del']) { ?>
                    <li><a href="<?php echo $list[$i]['del_link']; ?>" onclick="return comment_delete();">삭제</a></li>
               <?php } ?>
          </ul>
     </div>
     <?php } ?>
</article>
<?php } ?>
     
<?php if ($i == 0) { //댓글이 없다면 ?>
<article id="cl_empty">등록된 댓글이 없습니다</article>
<?php } ?>
</section>
<!-- 리스트 끝 -->



<!-- B. 쓰기 시작 -->
<?php if ($is_comment_write) {
    if($w == '')
        $w = 'c';
?>
<aside id="cmt_write">
<form name="fviewcomment" id="fviewcomment" action="<?php echo $comment_action_url; ?>" onsubmit="return fviewcomment_submit(this);" method="post" autocomplete="off">
<input type="hidden" name="w" value="<?php echo $w ?>" id="w">
<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
<input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
<input type="hidden" name="comment_id" value="<?php echo $c_id ?>" id="comment_id">
<input type="hidden" name="sca" value="<?php echo $sca ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="spt" value="<?php echo $spt ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="is_good" value="">
     <div id="cmt_write_rap">
          <div id="cw_text">
               <textarea id="wr_content" name="wr_content" maxlength="1000" required  title="내용" placeholder="댓글을 입력해주세요" onkeyup="checkByte('wr_content', 'char_count');" onchange="checkByte('wr_content', 'char_count');"></textarea>
          </div>
          <div id="cw_etc">
               <div class="ce_count"><span id="char_count"></span> / 1000</div>
               <div class="ce_secret"><input type="checkbox" name="wr_secret" value="secret" id="wr_secret" class="selec_chk"> 비밀글</div>
               <div class="ce_btn"> <button type="submit" id="btn_submit" >댓글등록</button></div>
          </div>
    </div>
</form>
</aside>
<!-- 쓰기 끝 -->

<script>
    $(function() {
        // 댓글 옵션창 열기
        $(".cl_btn_open").on("click", function() {
            $(this).parent("div").children(".cb_box").show();
        });

        // 댓글 옵션창 닫기
        $(document).mouseup(function(e) {
            var container = $(".cb_box");
            if (container.has(e.target).length === 0)
                container.hide();
        });
    });
</script>

<script>
var save_before = '';
var save_html = document.getElementById('cmt_write').innerHTML;

function getStringLength(str) {
    return str.length; // JavaScript의 length는 문자 단위로 계산
}

// 글자 수를 확인하고 상태를 업데이트하는 함수
function checkByte(textareaId, counterId) {
    var textarea = document.getElementById(textareaId);
    var counter = document.getElementById(counterId);
    var maxLength = parseInt(textarea.getAttribute("maxlength"));

    var length = getStringLength(textarea.value); // 문자 단위 길이 계산
    if (length > maxLength) {
        textarea.value = textarea.value.substr(0, maxLength); // 초과된 부분 제거
    }

    counter.textContent = length; // 현재 문자 수 업데이트
}

// 댓글 작성 버튼 클릭 시 처리
function good_and_write() {
    var f = document.fviewcomment;
    if (fviewcomment_submit(f)) {
        f.is_good.value = 1;
        f.submit();
    } else {
        f.is_good.value = 0;
    }
}

// 댓글 작성 유효성 검사
function fviewcomment_submit(f) {
    var pattern = /(^\s*)|(\s*$)/g; // \s 공백 문자

    f.is_good.value = 0;

    var subject = "";
    var content = "";
    $.ajax({
        url: g5_bbs_url + "/ajax.filter.php",
        type: "POST",
        data: {
            "subject": "",
            "content": f.wr_content.value
        },
        dataType: "json",
        async: false,
        cache: false,
        success: function(data, textStatus) {
            subject = data.subject;
            content = data.content;
        }
    });

    if (content) {
        alert("내용에 금지단어('" + content + "')가 포함되어 있습니다.");
        f.wr_content.focus();
        return false;
    }

    // 공백 제거
    document.getElementById('wr_content').value = document.getElementById('wr_content').value.replace(pattern, "");

    // 최소 및 최대 글자 수 검사
    if (char_min > 0 || char_max > 0) {
        checkByte('wr_content', 'char_count');
        var cnt = parseInt(document.getElementById('char_count').textContent);
        if (char_min > 0 && char_min > cnt) {
            alert("댓글은 " + char_min + "글자 이상 쓰셔야 합니다.");
            return false;
        } else if (char_max > 0 && char_max < cnt) {
            alert("댓글은 " + char_max + "글자 이하로 쓰셔야 합니다.");
            return false;
        }
    } else if (!document.getElementById('wr_content').value) {
        alert("댓글을 입력하여 주십시오.");
        return false;
    }

     <?php if ($is_guest) echo chk_captcha_js(); ?>

    set_comment_token(f);

    document.getElementById("btn_submit").disabled = "disabled";

    return true;
}

// 댓글 작성 폼 전환
function comment_box(comment_id, work) {
    var el_id,
        form_el = 'fviewcomment',
        respond = document.getElementById(form_el);

    // 댓글 아이디가 넘어오면 답변, 수정
    if (comment_id) {
        if (work == 'c')
            el_id = 'reply_' + comment_id;
        else
            el_id = 'edit_' + comment_id;
    } else {
        el_id = 'bo_vc_w';
    }

    if (save_before != el_id) {
        if (save_before) {
            document.getElementById(save_before).style.display = 'none';
        }

        document.getElementById(el_id).style.display = '';
        document.getElementById(el_id).appendChild(respond);

        // 입력값 초기화
        document.getElementById('wr_content').value = '';

        // 댓글 수정
        if (work == 'cu') {
            document.getElementById('wr_content').value = document.getElementById('save_comment_' + comment_id).value;
            checkByte('wr_content', 'char_count');
        }

        document.getElementById('comment_id').value = comment_id;
        document.getElementById('w').value = work;

        if (save_before)
            $("#captcha_reload").trigger("click");

        save_before = el_id;
    }
}

// 댓글 삭제 확인
function comment_delete() {
    return confirm("이 댓글을 삭제하시겠습니까?");
}

// 초기화
document.addEventListener("DOMContentLoaded", function () {
    var textarea = document.getElementById("wr_content");
    textarea.addEventListener("keyup", function () {
        checkByte("wr_content", "char_count");
    });
    textarea.addEventListener("change", function () {
        checkByte("wr_content", "char_count");
    });
});

comment_box('', 'c'); // 댓글 입력폼이 보이도록 처리하기위해서 추가 (root님)

</script>


<?php } ?>