<?php
if (!defined('_GNUBOARD_')) exit;
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/ix_list.css">', 0);
?>

<!------------------------------------
IX Skin Design - Board [List]
-------------------------------------->

<!--시작 -->
<div id="ix_bbs_list"> 

<!-- 1. 상단 ------->
<section id="bl_sec_top">
<!-- 1-1. 카테고리 -->
<div id="bl_cate">
     <?php if ($is_category) { ?>
     <ul>
     <?php echo $category_option; ?>
     </ul>
     <?php } ?>
</div>
<!-- 1-2. 토탈 -->
<div id="bl_total"> Total <span><?php echo number_format($total_count); ?></span>/<span><?php echo $page; ?></span>Page</div>
<!-- 1-3. 정렬 -->
<?php
$current_sort = isset($_GET['sst']) ? $_GET['sst'] : ''; // 현재 정렬 상태 감지
?>
<div id="bl_sort">
     <?php echo subject_sort_link('wr_hit', $qstr2, 1); ?><div class="ls_hit <?php echo ($current_sort == 'wr_hit') ? 'ls_active' : ''; ?>">조회</div></a>
     <?php if ($is_good) { ?>
     <?php echo subject_sort_link('wr_good', $qstr2, 1); ?><div class="ls_rec <?php echo ($current_sort == 'wr_good') ? 'ls_active' : ''; ?>">추천</div></a>
     <?php } ?>
     <?php echo subject_sort_link('wr_datetime', $qstr2, 1); ?><div class="ls_date <?php echo ($current_sort == 'wr_datetime') ? 'ls_active' : ''; ?>">날짜</div></a>
</div>
<!-- 1-4. 관리자 버튼 -->
<?php if ($admin_href) { ?>
<div id="bl_admin"> 
     <a href="<?php echo $admin_href; ?>" title="관리자" class="bl_btn_adm" target="_blank"><i class="fa-solid fa-gear"></i></a>
     <a href="javascript:void(0);" id="chkall" class="bl_btn_chk" onclick="toggleCheckbox();"><i class="fa-solid fa-check"></i></a>
</div>
<?php } ?>
</section>


<!-- 2. 중간 (리스트) ------->
<form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="spt" value="<?php echo $spt ?>">
<input type="hidden" name="sca" value="<?php echo $sca ?>">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="sw" value="">
<section id="bl_sec_list">
<!-- 2-1. 리스트 헤드 -->
<header id="bl_list_head">
     <?php if ($is_checkbox) { ?>
     <div class="list_chk"></div>
     <?php } ?>
     <?php if ($is_category) { ?>
     <div class="list_cate"></div>
     <?php } ?>
     <div class="list_title">프로젝트</div>
     <div class="list_pro">진행률</div>
     <div class="list_date">목표일</div>
     <div class="list_time">R-time</div>
</header>

<!-- 2-2. 리스트 -->
<?php
// 리스트 개수 저장하여 count() 호출 최적화
$list_count = count($list);

// 현재 리스트의 wr_id 목록을 배열로 저장
$wr_ids = array_column($list, 'wr_id');
$fileData = [];
$imageExtensions = 'jpg|jpeg|png|gif';

if (!empty($wr_ids)) {
    $wr_id_list = implode(',', array_map('intval', $wr_ids)); // SQL 인젝션 방지를 위해 int 변환
    $sql = "SELECT wr_id, bf_source FROM g5_board_file 
                WHERE bo_table = '{$bo_table}' 
                AND wr_id IN ({$wr_id_list}) 
                ORDER BY bf_no";

    $fileResults = sql_query($sql);

    while ($row = sql_fetch_array($fileResults)) {
        $fileData[$row['wr_id']][] = $row['bf_source'];
    }
}
?>
<ul id="bl_list">
     <?php for ($i = 0; $i < $list_count; $i++) { ?>
     <?php
     // 서버의 현재 날짜 (시간 무시)
     $current_date = new DateTime();
     $current_date->setTime(0, 0, 0); // 시간을 00:00:00으로 고정

     $wr_9_date = $list[$i]['wr_9']; // 게시물 날짜 (예: '2025-03-31')
     $wr_8_value = isset($list[$i]['wr_8']) ? (int)$list[$i]['wr_8'] : 0; // wr_8 값 (0~100 숫자만 사용)

     $class = ""; // 기본 클래스 초기화
     $d_day_display = ""; // D-Day 텍스트 초기화

     if ($wr_8_value === 100) {
         // wr_8 값이 100이면 "Finish" 표시
         $class = "lda_finish";
         $d_day_display = '<div class="ldm_finish">Finish</div>';
     } elseif (!empty($wr_9_date)) {
         // 목표 날짜 설정 (시간 무시)
         $target_date = new DateTime($wr_9_date);
         $target_date->setTime(0, 0, 0); // 시간을 00:00:00으로 고정

         // 날짜 차이 계산 (시간 무시)
         $interval = $current_date->diff($target_date);
         $remaining_days = (int) $interval->format('%r%a'); // 양수: 미래, 음수: 과거, 0: 오늘

         if ($remaining_days == 0) {
             // 목표 날짜가 오늘인 경우
             $class = "lda_today";
             $d_day_display = '<div class="ldm_today">Today</div>';
         } elseif ($remaining_days > 0) {
             // 목표 날짜가 미래인 경우 (D-)
             $class = "lda_day";
             $d_day_display = '<div class="ldm_day">D-<span>' . $remaining_days . '</span></div>';
         } else {
             // 목표 날짜가 과거인 경우 (D+)
             $class = "lda_after";
             $d_day_display = '<div class="ldm_after">D+<span>' . abs($remaining_days) . '</span></div>';
         }
     }
     ?>
     <li id="li_post" class="<?php echo $list[$i]['is_notice'] ? 'li_notice' : ''; ?> <?php echo $class; ?>">
          <?php if ($is_checkbox) { ?>
          <div class="list_chk">
               <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id']; ?>" id="chk_wr_id_<?php echo $i; ?>">
          </div>
          <?php } ?>
          <?php if ($is_category) { ?>
          <div class="list_cate">
               <?php if (!empty($list[$i]['ca_name'])) { ?>
               <a href="<?php echo $list[$i]['ca_name_href']; ?>"><?php echo $list[$i]['ca_name']; ?></a>
               <?php } ?>
          </div>
          <?php } ?>
          <div class="list_title">
               <?php if (isset($list[$i]['icon_secret'])) echo rtrim($list[$i]['icon_secret']); ?>
               <a href="<?php echo $list[$i]['href']; ?>" class="lt_subject"><?php echo $list[$i]['subject']; ?></a>
              
               <?php
               //     새 글 아이콘 출력
               if (!empty($list[$i]['icon_new'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_new.png">';
               }

               //     파일 및 이미지 아이콘 처리
               $hasImage = false;
               $hasFile = false;
               if (!empty($fileData[$list[$i]['wr_id']])) {
                    foreach ($fileData[$list[$i]['wr_id']] as $fileInfo) {
                         if (preg_match("/\.($imageExtensions)$/i", $fileInfo)) {
                              $hasImage = true;
                         }
                         if (!preg_match("/\.($imageExtensions)$/i", $fileInfo)) {
                              $hasFile = true;
                         }
                    }
               }
               if ($hasImage) {
                    echo '<img src="' . $board_skin_url . '/img/ico_img.png">';
               }
               if ($hasFile) {
                    echo '<img src="' . $board_skin_url . '/img/ico_file.png">';
               }
              
               //     추가 아이콘 출력
               if (!empty($list[$i]['icon_hot'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_hot.png">';
               }
               if (!empty($list[$i]['icon_link'])) {
                    echo '<img src="' . $board_skin_url . '/img/ico_link.png">';
               }
               ?>
              
               <?php if ($list[$i]['comment_cnt']) { ?>
               <span class="bl_cmt">[<?php echo $list[$i]['wr_comment']; ?>]</span>
               <?php } ?>
          </div>
          <div class="list_pro">
               <div id="lp_rap">
               <?php 
               // 기본 클래스 설정
               $lp_class = '';
               
               // wr_8 값에 따라 클래스를 다르게 설정
               if ($list[$i]['wr_8'] >= 0 && $list[$i]['wr_8'] <= 49) {
                    $lp_class = 'lp_low'; // 0 ~ 49
               } elseif ($list[$i]['wr_8'] >= 50 && $list[$i]['wr_8'] <= 79) {
                    $lp_class = 'lp_medium'; // 50 ~ 79
               } elseif ($list[$i]['wr_8'] >= 80 && $list[$i]['wr_8'] <= 99) {
                    $lp_class = 'lp_high'; // 80 ~ 99
               } elseif ($list[$i]['wr_8'] == 100) {
                    $lp_class = 'lp_end'; // 100
               }
               ?>
               <span class="lp_bar <?php echo $lp_class; ?>" style="width: <?php echo $list[$i]['wr_8']; ?>%;"><?php echo $list[$i]['wr_8']; ?></span>
               </div>
          </div>
          <div class="list_date">
               <span>
                    <?php 
                    $days = ['일', '월', '화', '수', '목', '금', '토'];
                    $dayOfWeek = date('w', strtotime($list[$i]['wr_9']));
                    echo date("y.m.d", strtotime($list[$i]['wr_9'])) . " (" . $days[$dayOfWeek] . ")";                         
                    ?>                         
               </span>
          </div>
          <div class="list_time"><?php echo $d_day_display; ?></div>
     </li>
     <?php } ?>
     <?php if ($list_count == 0) { ?>
     <li class="li_empty">게시물이 없습니다.</li>
     <?php } ?>
</ul>
</section>


<!-- 3. 하단 (검색, 버튼) ------->
<section id="bl_sec_bt">
<!-- 3-1. 버튼 -->
<div id="bl_btn">
     <?php if ($is_admin == 'super' || $is_auth) {  ?>
     <?php if ($is_checkbox) { ?>    
     <button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value">삭제</button>
     <button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value">복사</button>
     <button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value">이동</button>
     <?php } ?>
     <?php }  ?>
     <?php if ($write_href) { ?>
          <a href="<?php echo $write_href ?>"  title="글쓰기">글쓰기</a></li>
     <?php } ?>
</div>
</form> 
<!-- 3-2. 검색 -->
<div id="bl_sch">
          <form name="fsearch" method="get">
          <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
          <input type="hidden" name="sca" value="<?php echo $sca ?>">
          <input type="hidden" name="sop" value="and">
          <select name="sfl" id="sfl">
               <option value="wr_subject"<?php echo get_selected($sfl, "wr_subject") ?>>제목</option>
               <option value="wr_content"<?php echo get_selected($sfl, "wr_content") ?>>내용</option>
               <option value="wr_subject||wr_content"<?php echo get_selected($sfl, "wr_subject||wr_content") ?>>제목+내용</option>
          </select>
          <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="bl_ip_sch" size="25" maxlength="20" placeholder="">
          <button type="submit" value="검색" class="bl_btn_sch"><i class="fa fa-search" aria-hidden="true"></i></button>
          </form>
</div>
</section>

<!-- 4. 페이지 ------->
<?php if (!empty($write_pages)) : ?>
<section id="bl_sec_page">
<?php echo $write_pages; ?>
</section>
<?php endif; ?>

</div> 
<!--끝 -->

<?php if ($is_checkbox) { ?>
<script>
//전체 체크 버튼
function toggleCheckbox() {
    let checkboxes = document.querySelectorAll("input[name='chk_wr_id[]']");
    let isChecked = checkboxes.length > 0 && [...checkboxes].every(cb => cb.checked);

    checkboxes.forEach(cb => cb.checked = !isChecked);
}
function fboardlist_submit(f) {
    var chk_count = 0;
    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }
    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }
    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }
    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }
    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }
    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;
    if (sw == "copy")
        str = "복사";
    else
        str = "이동";
    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");
    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}
</script>
<?php } ?>

