<?php
if (!defined('_GNUBOARD_')) exit;
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/ix_write.css">', 0);
?>

<!------------------------------------
IX Skin Design - Board [Write]
-------------------------------------->

<!-- 시작 -->
<div id="ix_bbs_write"> 

<form name="fwrite" id="fwrite" action="<?php echo $action_url ?>" onsubmit="return fwrite_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" style="width:<?php echo $width; ?>">
<input type="hidden" name="uid" value="<?php echo get_uniqid(); ?>">
<input type="hidden" name="w" value="<?php echo $w ?>">
<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
<input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
<input type="hidden" name="sca" value="<?php echo $sca ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="spt" value="<?php echo $spt ?>">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type='hidden' name='wr_10' value='<?php echo G5_TIME_YMDHIS?>'>
<?php
$option = '';
$option_hidden = '';
if ($is_notice || $is_html || $is_secret || $is_mail) { 
     $option = '';
     if ($is_notice) {
         $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="notice" name="notice"  class="selec_chk" value="1" '.$notice_checked.'>'.PHP_EOL.'<label for="notice"><span></span>공지</label></li>';
     }
     if ($is_html) {
         if ($is_dhtml_editor) {
             $option_hidden .= '<input type="hidden" value="html1" name="html">';
         } else {
             $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="html" name="html" onclick="html_auto_br(this);" class="selec_chk" value="'.$html_value.'" '.$html_checked.'>'.PHP_EOL.'<label for="html"><span></span>html</label></li>';
         }
     }
     if ($is_secret) {
         if ($is_admin || $is_secret==1) {
             $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="secret" name="secret"  class="selec_chk" value="secret" '.$secret_checked.'>'.PHP_EOL.'<label for="secret"><span></span>비밀글</label></li>';
         } else {
             $option_hidden .= '<input type="hidden" name="secret" value="secret">';
         }
     }
     if ($is_mail) {
         $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="mail" name="mail"  class="selec_chk" value="mail" '.$recv_email_checked.'>'.PHP_EOL.'<label for="mail"><span></span>답변메일받기</label></li>';
     }
}
echo $option_hidden;
?>

<!-- 1. 옵션 ------->
<section id="bw_sec_top">
<?php if ($is_category) { ?>
<div id="wo_cate">
    <select name="ca_name" id="ca_name" required>
          <option value="">분류를 선택하세요</option>
          <?php echo $category_option ?>
     </select>
</div>
<?php } ?>  
     
<?php if ($option) { ?>
<div id="wo_opt"><ul><?php echo $option ?></ul></div>
<?php } ?>
     
<div id="wo_date">
          <span>목표일 :</span>
          <input type="date" name="wr_9" id="wr_9"  value="<?php echo isset($write['wr_9']) ? $write['wr_9'] : ''; ?>"  min="<?php echo date('Y-m-d'); ?>" required>
</div>

<div id="wo_pro">
        <!-- 진행률 입력 필드 -->
       <span class="wp_text">진행율 :</span>
        <input type="text" name="wr_8" value="<?= isset($write['wr_8']) ? $write['wr_8'] : '0'; ?>" id="wr_8" maxlength="3" placeholder="" oninput="validateNumber(this)">
        <span class="wp_per">%</span>
        
        <!-- 드롭다운 메뉴를 나타내는 버튼 -->
        <div id="wp_drop">
            <button type="button" id="wp_dropButton"><i class="fa-solid fa-caret-down"></i></button>
            <ul id="wp_dropMenu">
                <?php
                // 진행률 값 배열
                $percentages = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100];
                
                // 배열을 돌면서 li 항목을 생성
                foreach ($percentages as $value) {
                    echo "<li class=\"wp_drop-item\" data-value=\"$value\">$value</li>";
                }
                ?>
            </ul>
        </div>

</div>
</section>


<!-- 2. 제목 ------->
<section id="bw_sec_title">
<div id="wo_title">
          <input type="text" name="wr_subject" value="<?php echo $subject ?>" id="wr_subject" required class="bw_input" size="50" maxlength="100" placeholder="제목">
</div>
<?php if ($is_member) { // 임시 저장된 글 기능 ?>
<div id="wo_save">
    <script src="<?php echo G5_JS_URL; ?>/autosave.js"></script>
    <?php if($editor_content_js) echo $editor_content_js; ?>
    <button type="button" id="btn_autosave" class="ws_btn_list" tabindex="-1">임시 저장된 글 [<span id="autosave_count"><?php echo $autosave_count; ?></span>]</button>
    <div id="autosave_pop">
         <div class="ws_title">임시 저장된 글 목록</div>
              <ul></ul>
         <div class="ws_close"><button type="button" class="autosave_close">닫기</button></div>
    </div>
</div>
<?php } ?>
</section>


<!-- 3. 본문 ------->
<section id="bw_sec_cont">
<div class="wt_content <?php echo $is_dhtml_editor ? $config['cf_editor'] : ''; ?>">
     <?php echo $editor_html; // 에디터 사용시는 에디터로, 아니면 textarea 로 노출 ?>
</div>
<div id="wt_count"><span id="char_count"></span> 글자</div>
</section>


<!-- 4. 링크 ------->
<?php if ($is_link): ?>
<section id="bw_sec_link">
<div id="wl_link">
     <div id="wl_icon"><i class="fa-solid fa-link"></i></div>
     <div id="wl_input">
          <input type="text" name="wr_link1" value="<?php if($w == "u"){ echo $write['wr_link1']; } ?>" id="wr_link1" size="50" placeholder="https://">
     </div>
</div>
<div id="wl_link">
     <div id="wl_icon"></div>
     <div id="wl_input">
          <input type="text" name="wr_link2" value="<?php if($w == "u"){ echo $write['wr_link2']; } ?>" id="wr_link2" size="50" placeholder="https://">
     </div>
</div>
</section>
<?php endif; ?>

     
<!-- 5. 첨부 ------->
<?php if ($is_file) { ?>
<section id="bw_sec_file">
<?php for ($i = 0; $i < $file_count; $i++) { ?>
<div id="wf_file">
     <div id="wf_icon"><?php if ($i == 0) { ?><i class="fa-regular fa-folder"></i><?php } ?></div>
     <div id="wf_box">
          <div id="wb_input">
               <input type="file" name="bf_file[]" id="bf_file_<?php echo $i+1 ?>" title="파일첨부 <?php echo $i+1 ?>">
               <span>최대 : <?php $upload_max_filesize_numeric = (int)preg_replace('/[^0-9]/', '', $upload_max_filesize); $upload_max_filesize_mb = $upload_max_filesize_numeric / 1048576; echo number_format($upload_max_filesize_mb, 2) . ' MB'; ?></span>
          </div>
          <?php if($w == 'u' && $file[$i]['file']) { ?>
          <div id="wb_del">
               <label for="bf_file_del<?php echo $i ?>">
                    <?php
                    $source = $file[$i]['source'];
                    $maxLength = 35;
                    if (strlen($source) > $maxLength) {
                        $source = substr($source, 0, $maxLength - 4) . '~' . substr($source, -4);
                    }
                    echo $source;
                    ?>
                    <?php echo ' (' . $file[$i]['size'] . ')'; ?> 삭제
               </label>
               <input type="checkbox" id="bf_file_del<?php echo $i ?>" name="bf_file_del[<?php echo $i; ?>]" value="1">
          </div>
          <?php } ?>
     </div>
</div>
<?php } ?>
</section>
<?php } ?>


<!-- 6. 버튼 ------->
<section id="bw_sec_btn">
     <a href="<?php echo get_pretty_url($bo_table); ?>">취소</a>
     <button type="submit" id="btn_submit" accesskey="s">작성완료</button>
</section>

</form>
</div>
<!-- 끝 -->

<script>
    // 숫자만 입력되도록 제한하고 100 이하로만 입력
    function validateNumber(input) {
        // 입력 값이 숫자가 아니면 지우기
        input.value = input.value.replace(/[^0-9]/g, '');

        // 100을 초과하면 100으로 설정
        if (parseInt(input.value) > 100) {
            input.value = '100';
        }

        // 최대 3자리로 제한 (0부터 100 사이의 숫자만 입력)
        if (input.value.length > 3) {
            input.value = input.value.slice(0, 3);
        }
    }
</script>

<script>
    // 드롭다운 버튼 클릭 시 드롭다운 메뉴 표시
    document.getElementById('wp_dropButton').addEventListener('click', function() {
        var menu = document.getElementById('wp_dropMenu');
        menu.style.display = menu.style.display === 'block' ? 'none' : 'block';  // 메뉴 보이기/숨기기
    });

    // 드롭다운 항목 클릭 시 해당 값 입력 필드에 적용
    var items = document.querySelectorAll('.wp_drop-item');
    items.forEach(function(item) {
        item.addEventListener('click', function() {
            var input = document.getElementById('wr_8');
            input.value = item.getAttribute('data-value'); // data-value 속성으로 값을 설정
            document.getElementById('wp_dropMenu').style.display = 'none'; // 드롭다운 메뉴 숨기기
        });
    });

    // 드롭다운 외부 클릭 시 메뉴 숨기기
    window.addEventListener('click', function(event) {
        var menu = document.getElementById('wp_dropMenu');
        if (!event.target.closest('#wp_drop') && menu.style.display === 'block') {
            menu.style.display = 'none'; // 메뉴 숨기기
        }
    });
</script>


<script>
// JavaScript로 글자 수 카운트
document.addEventListener('DOMContentLoaded', function() {
    // textarea 또는 에디터 요소 가져오기
    const textarea = document.querySelector('textarea'); // 에디터가 아닌 textarea만 대상으로 지정
    const charCount = document.getElementById('char_count');

    if (textarea && charCount) {
        // textarea의 입력 이벤트 감지
        textarea.addEventListener('input', function() {
            // 글자 수 계산 (공백 포함)
            const textLength = textarea.value.length;
            charCount.textContent = textLength; // 글자 수 업데이트
        });
    }
});
</script>


<script>
    function html_auto_br(obj) {
        if (obj.checked) {
            let result = confirm("자동 줄바꿈을 하시겠습니까?\n\n자동 줄바꿈은 게시물 내용 중 줄바뀐 곳을 <br> 태그로 변환하는 기능입니다.");
            obj.value = result ? "html2" : "html1";
        } else {
            obj.value = "";
        }
    }

    function fwrite_submit(f) {
        <?php echo $editor_js; // 에디터 사용 시 내용을 폼필드로 넣고 입력 여부 검사 ?>

        let subject = "";
        let content = "";

        $.ajax({
            url: g5_bbs_url + "/ajax.filter.php",
            type: "POST",
            data: {
                "subject": f.wr_subject.value,
                "content": f.wr_content.value
            },
            dataType: "json",
            async: false,
            cache: false,
            success: function (data, textStatus) {
                subject = data.subject;
                content = data.content;
            }
        });

        if (subject) {
            alert("제목에 금지단어('" + subject + "')가 포함되어 있습니다.");
            f.wr_subject.focus();
            return false;
        }

        if (content) {
            alert("내용에 금지단어('" + content + "')가 포함되어 있습니다.");
            if (typeof ed_wr_content !== "undefined") {
                ed_wr_content.returnFalse();
            } else {
                f.wr_content.focus();
            }
            return false;
        }

        // 글자 수 제한 검사
        let charCountElem = document.getElementById("char_count");
        if (charCountElem) {
            if (char_min > 0 || char_max > 0) {
                let cnt = parseInt(check_byte("wr_content", "char_count"));

                if (char_min > 0 && char_min > cnt) {
                    alert("내용은 " + char_min + "글자 이상 작성해야 합니다.");
                    return false;
                } else if (char_max > 0 && char_max < cnt) {
                    alert("내용은 " + char_max + "글자 이하로 작성해야 합니다.");
                    return false;
                }
            }
        }

        <?php echo $captcha_js; // 캡차 사용 시 입력된 캡차 검사 ?>

        document.getElementById("btn_submit").disabled = true;

        return true;
    }
</script>