<?php
/**
 * skin file : /theme/THEME_NAME/skin/connect/basic/current_connect.skin.html.php
 */
if (!defined('_EYOOM_')) exit;

//==============================================================================
// 관리자 국가,IP정보 기본 출력
//------------------------------------------------------------------------------
$token = '';		// ipinfo.io 개인 액세스 토큰
$is_flag = true;	// 국가 출력여부 설정
$is_ipInfo = false;	// IP정보 출력여부 설정

function getIpInfo($ip)
{
	$access_token = $token; // ipinfo.io 개인 액세스 토큰
    $url = 'https://ipinfo.io/' . $ip . '?token=' . $access_token;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (!$data) {
        return "IP 정보를 가져오는 데 실패했습니다.";
    }

    // 국가 코드 소문자로 변환
    $countryCode = strtolower($data['country']);
    $flagUrl = "https://flagcdn.com/w80/{$countryCode}.png"; // 80px 크기의 국기 이미지

    // IP 대역 정보 가져오기
    $ipRanges = getIpRanges($ip);

    // 정보 배열로 분리하여 반환
    $info = [
        'ip' => $data['ip'],
        'hostname' => $data['hostname'],
        'city' => $data['city'],
        'region' => $data['region'],
        'country' => $data['country'],
        'flag_url' => $flagUrl,
        'loc' => $data['loc'],
        'postal' => $data['postal'],
        'org' => $data['org'],
        'timezone' => $data['timezone'],
        'asn' => $data['asn'],
        'ip_ranges' => displayIpRanges($ipRanges)
    ];

    return $info;
}

function getIpRanges($ip)
{
    $hierarchy = [];
    $ranges[] = getBaseIp($ip, 8) . "/8";
    $ranges[] = getBaseIp($ip, 16) . "/16";
    $ranges[] = getBaseIp($ip, 24) . "/24";


    $ranges[] = $ip; // 현재 IP 추가

    return $ranges;
}

function getBaseIp($ip, $prefix)
{
    $ipParts = explode('.', $ip);

    if ($prefix <= 8) {
        return "{$ipParts[0]}.0.0.0";
    } elseif ($prefix <= 16) {
        return "{$ipParts[0]}.{$ipParts[1]}.0.0";
    } elseif ($prefix <= 24) {
        return "{$ipParts[0]}.{$ipParts[1]}.{$ipParts[2]}.0";
    }

    return $ip;
}

function displayIpRanges($ipRanges)
{
    $output = implode(' > ', $ipRanges);
    return $output;
}
?>

<style>
.current-connect {font-size:.9375rem}
.current-connect .table-list-eb .td-location {white-space:normal;word-break:break-all;}
.current-connect .table-list-eb .td-mobile td {padding-top:0;color:#959595;white-space:normal;word-break:break-all;}
.current-connect .table-list-eb .td-mobile td a {color:#959595}
.current-connect .connect-nameview {color:#3949ab !important}
.current-connect .connect-nameview .sv_wrap > a {color:#3949ab}
.current-connect .connect-nameview .sv_wrap .profile_img {display:none}
.current-connect .connect-nameview .sv_wrap .sv {text-align:left;color:#151515}
.current-connect .connect-url:hover {color:#000;text-decoration:underline}
@media (max-width:767px) {
    .current-connect .table-list-eb table {white-space:inherit}
    .current-connect .table-list-eb .td-mlt td {border-bottom:0}
    .current-connect .table-list-eb .td-num {font-weight:700}
}
</style>

<div class="current-connect">
    <div class="table-list-eb">
        <div class="board-list-body">
            <table class="table">
                <thead>
                    <tr>
                        <th class="text-start width-60px">번호</th>
						<?php if($is_flag || $is_admin == 'super'){ ?>
						<th class="width-60px">국가</th>
						<?php } ?>
                        <th class="width-120px">접속자 (IP)</th>
                        <th class="hidden-xs">위치</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
					for ($i=0; $i<count((array)$list); $i++) {

						$ipInfo = getIpInfo($list[$i]['lo_ip']);
						$data_ipInfo = htmlspecialchars(json_encode($ipInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8');
					?>
                    <tr class="td-mlt">
                        <td class="td-num text-start"><?php echo $list[$i]['num']; ?></td>
						<?php if($is_flag || $is_admin == 'super'){ ?>
						<td class="text-center"><img src='<?php echo $ipInfo['flag_url'];?>' alt='<?php echo $ipInfo['country'];?> flag' style='vertical-align:middle;border:1px solid #ccc;width:25px;height:auto;'></td>
						<?php } ?>
                        <td class="text-center">
                            <?php
							if ($list[$i]['mb_id']) {

								if($is_ipInfo || $is_admin == 'super'){
									echo '<span class="connect-nameview"><a href="#" class="crt_ipInfo" data-info="'.$data_ipInfo.'" data-bs-toggle="modal" data-bs-target=".search-modal">'.eb_nameview($eyoom['nameview_skin'], $list[$i]['mb_nick'], $list[$i]['mb_id'], $list[$i]['mb_email'], $list[$i]['mb_homepage']).'</a></span>';
								}else{
									echo '<span class="connect-nameview">'.eb_nameview($eyoom['nameview_skin'], $list[$i]['mb_nick'], $list[$i]['mb_id'], $list[$i]['mb_email'], $list[$i]['mb_homepage']).'</span>';
								}

							} else {
								echo ($is_ipInfo || $is_admin == 'super') ? '<span><a href="#" class="crt_ipInfo" data-info="'.$data_ipInfo.'" data-bs-toggle="modal" data-bs-target=".search-modal">'.$list[$i]['name'].'</a></span>':'<span>'.$list[$i]['name'].'</span>';
							}
							?>
                        </td>
                        <td class="hidden-xs td-location">
                            <?php if ($list[$i]['lo_url'] && $is_admin == 'super') { ?>
                            <a href="<?php echo $list[$i]['lo_url']; ?>" class="connect-url"><?php echo $list[$i]['lo_location']; ?></a>
                            <?php } else { ?>
                            <?php echo $list[$i]['lo_location']; ?>
                            <?php } ?>
                        </td>
                    </tr>
                    <tr class="td-mobile visible-xs">
                        <td colspan="<?php echo ($is_flag || $is_admin == 'super')?"3":"2";?>">
                            <?php if ($list[$i]['lo_url'] && $is_admin == 'super') { ?>
                            <a href="<?php echo $list[$i]['lo_url']; ?>"><?php echo $list[$i]['lo_location']; ?></a>
                            <?php } else { ?>
                            <?php echo $list[$i]['lo_location']; ?>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if (count((array)$list) == 0) { ?>
                    <tr><td colspan="3" class="text-center"><span class="text-gray"><i class="fas fa-exclamation-circle"></i> 현재 접속자가 없습니다.</span></td></tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php /* IP정보 모달 시작 */ ?>
<style>
.ip_info_wrap {display: none;width: 100%;height: 100%;position: fixed;top: 0;left: 0;z-index: 9999;}
.ip_info {position: absolute;top: 50%;left: 50%;background: #fff;text-align: left;z-index: 99999;width: 90%;max-width: 530px;max-height: 80vh;transform: translate(-50%, -50%);overflow-y: auto;border-radius: 5px;box-shadow: 1px 1px 18px rgba(0, 0, 0, 0.2);border: 1px solid #dde7e9;}
.ip_info h3 {padding: 15px;margin: 0;font-size: 18px;border-bottom: 1px solid #e8e8e8;}
.ip_info .ip_info_cls {position: absolute;right: 10px;top: 10px;cursor: pointer;border: 0;background: none;width: 30px;height: 30px;display: flex;align-items: center;justify-content: center;}
.ip_info .ip_info_cls img {width: 100%;height: auto;}
.ip_info_bg {background: rgba(0, 0, 0, 0.3);width: 100%;height: 100%;position: absolute;top: 0;left: 0;}
.cont_info_wrap {border-bottom: 1px solid #eee;padding: 10px 15px;font-size: 14px;}
.cont_info_wrap dl {display: flex;flex-wrap: wrap;align-items: center;}
.cont_info_wrap dt {width: 30%;font-weight: bold;color: #666;}
.cont_info_wrap dd {width: 70%;color: #000;margin: 0;word-break: break-word;}
#flag {vertical-align: middle;width: 25px;height: auto;margin-left: 5px;border: 1px solid #ccc;}
</style>
<div class="ip_info_wrap">
    <div class="ip_info">
        <h3>접속자 IP정보</h3>
        <button type="button" class="ip_info_cls">
            <img src="<?php echo EYOOM_THEME_URL ?>/skin/connect/basic_ipinfo/img/icon_close.svg">
        </button>
        <div id="ip_info">
            <div class="cont_info_wrap">
                <dl>
                    <dt>IP 주소</dt>
                    <dd id="ip_address"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>국가</dt>
                    <dd>
                        <span id="country"></span>
                        <img id="flag" src="" alt="국기">
                    </dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역</dt>
                    <dd id="city"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역 코드</dt>
                    <dd id="region"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>위치</dt>
                    <dd id="loc"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>시간대</dt>
                    <dd id="timezone"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>ISP</dt>
                    <dd id="org"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>Ranges</dt>
                    <dd id="ip_ranges"></dd>
                </dl>
            </div>
        </div>
    </div>
    <div class="ip_info_bg"></div>
</div>

<script>
$(".crt_ipInfo").on("click", function () {
    var info = $(this).attr("data-info"); // data-info 값 가져오기
    info = JSON.parse(info); // JSON 문자열을 JavaScript 객체로 변환

    // 정보 업데이트
    $("#ip_address").text(info.ip);
    $("#city").text(info.city);
    $("#region").text(info.region);
    $("#country").text(info.country);
    $("#flag").attr("src", info.flag_url);
    $("#loc").text(info.loc);
    $("#org").text(info.org);
    $("#timezone").text(info.timezone);
    $("#ip_ranges").text(info.ip_ranges);

    $(".ip_info_wrap").show();
});

$(".ip_info_bg, .ip_info_cls").click(function () {
    $(".ip_info_wrap").hide();
});
</script>
<?php /* IP정보 모달 끝 */ ?>