<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 데모 메시지
na_demo_msg('skin');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$connect_skin_url.'/style.css">', 0);

// 스킨 설정값
$wset = na_skin_config('connect');

// 초기값
$wset['head_color'] = isset($wset['head_color']) ? $wset['head_color'] : '';
$wset['head_skin'] = isset($wset['head_skin']) ? $wset['head_skin'] : '';

// 목록헤드
$head_color = ($wset['head_color']) ? $wset['head_color'] : 'primary';
if($wset['head_skin']) {
	add_stylesheet('<link rel="stylesheet" href="'.NA_URL.'/skin/head/'.$wset['head_skin'].'.css">', 0);
	$head_class = 'list-head';
} else {
	$head_class = 'na-table-head border-'.$head_color;
}

function getIpInfo($ip)
{
	$access_token = $wset['token']; // ipinfo.io 개인 액세스 토큰
    $url = 'https://ipinfo.io/' . $ip . '?token=' . $access_token;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (!$data) {
        return "IP 정보를 가져오는 데 실패했습니다.";
    }

    // 국가 코드 소문자로 변환
    $countryCode = strtolower($data['country']);
    $flagUrl = "https://flagcdn.com/w80/{$countryCode}.png"; // 80px 크기의 국기 이미지

    // IP 대역 정보 가져오기
    $ipRanges = getIpRanges($ip);

    // 정보 배열로 분리하여 반환
    $info = [
        'ip' => $data['ip'],
        'hostname' => $data['hostname'],
        'city' => $data['city'],
        'region' => $data['region'],
        'country' => $data['country'],
        'flag_url' => $flagUrl,
        'loc' => $data['loc'],
        'postal' => $data['postal'],
        'org' => $data['org'],
        'timezone' => $data['timezone'],
        'asn' => $data['asn'],
        'ip_ranges' => displayIpRanges($ipRanges)
    ];

    return $info;
}

function getIpRanges($ip)
{
    $hierarchy = [];
    $ranges[] = getBaseIp($ip, 8) . "/8";
    $ranges[] = getBaseIp($ip, 16) . "/16";
    $ranges[] = getBaseIp($ip, 24) . "/24";


    $ranges[] = $ip; // 현재 IP 추가

    return $ranges;
}

function getBaseIp($ip, $prefix)
{
    $ipParts = explode('.', $ip);

    if ($prefix <= 8) {
        return "{$ipParts[0]}.0.0.0";
    } elseif ($prefix <= 16) {
        return "{$ipParts[0]}.{$ipParts[1]}.0.0";
    } elseif ($prefix <= 24) {
        return "{$ipParts[0]}.{$ipParts[1]}.{$ipParts[2]}.0";
    }

    return $ip;
}

function displayIpRanges($ipRanges)
{
    $output = implode(' > ', $ipRanges);
    return $output;
}
?>

<section id="connect_list" class="mb-4">

	<h2 class="sr-only">현재 접속자 목록</h2>

	<div class="na-table d-table w-100 mb-0">
		<div class="<?php echo $head_class ?> d-table-row">
			<div class="d-table-cell nw-6">번호</div>
			<?php if($wset['flag']){ ?>
			<div class="d-table-cell nw-3">국가</div>
			<?php } ?>
			<div class="d-table-cell nw-10">IP</div>
			<div class="d-table-cell text-left text-sm-center">
				<?php if($is_admin == 'super' ||IS_DEMO) { ?>
					<?php if(is_file($connect_skin_path.'/setup.skin.php')) { ?>
						<a class="btn_b01 btn-setup float-right mr-3" href="<?php echo na_setup_href('connect') ?>" title="스킨 설정">
							<i class="fa fa-cogs fa-fw fa-md" aria-hidden="true"></i>
							<span class="sr-only">스킨 설정</span>
						</a>
					<?php } ?>
				<?php } ?>
				접속자 위치
			</div>
		</div>
	</div>

	<ul class="na-table d-table w-100">
    <?php
	$n = 0;
	$admin_list = (isset($nariya['cf_admin']) && $nariya['cf_admin']) ? $config['cf_admin'].','.$nariya['cf_admin'] : $config['cf_admin'];
	$admin_arr = na_explode(",", $admin_list);
	$list_cnt = count($list);
    for ($i=0; $i < $list_cnt; $i++) {
		// 최고관리자 제외
		if($list[$i]['mb_id'] && in_array($list[$i]['mb_id'], $admin_arr))
			continue;

		$n++;
		$list[$i]['num'] = sprintf('%03d', $n);

		//$location = conv_content($list[$i]['lo_location'], 0);
        $location = $list[$i]['lo_location'];
        // 최고관리자에게만 허용
        // 이 조건문은 가능한 변경하지 마십시오.
        if ($list[$i]['lo_url'] && $is_admin == 'super') $display_location = "<a href=\"".$list[$i]['lo_url']."\">".$location."</a>";
        else $display_location = $location;

		$ipInfo = getIpInfo($list[$i]['lo_ip']);
		$data_ipInfo = htmlspecialchars(json_encode($ipInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8');
    ?>
		<li class="d-table-row border-bottom">
			<div class="d-table-cell text-center nw-6 py-2 py-md-2 f-sm">
				<span class="sr-only">번호</span>
				<?php echo $list[$i]['num'] ?>
			</div>
			<?php if($wset['flag'] || $is_admin == 'super'){ ?>
			<div class="d-table-cell text-center nw-3 py-2 py-md-2">
				<span class="sr-only">국가</span>
				<img src='<?php echo $ipInfo['flag_url'];?>' alt='<?php echo $ipInfo['country'];?> flag' style='vertical-align:middle;border:1px solid #ccc;width:25px;height:auto;margin-right:5px;'>
			</div>
			<?php } ?>
			<div class="d-table-cell text-center nw-10 py-2 py-md-2">
				<span class="sr-only">IP</span>
				<?php
				if($wset['ipInfo'] || $is_admin == 'super'){
					echo "<a href='javascript:;' class='crt_ipInfo' data-info='{$data_ipInfo}'>".na_name_photo($list[$i]['mb_id'], $list[$i]['name'])."</a>";
				}else{
					echo na_name_photo($list[$i]['mb_id'], $list[$i]['name']);
				}
				?>
			</div>
			<div class="d-table-cell py-2 py-md-2 pr-3">
				<div class="na-title">
					<div class="na-item">
						<div class="na-subject">
							<?php echo $display_location ?>
						</div>
					</div>
				</div>
			</div>
        </li>
    <?php } ?>
    </ul>
</section>

<?php /* IP정보 모달 시작 */ ?>
<style>
.ip_info_wrap {display: none;width: 100%;height: 100%;position: fixed;top: 0;left: 0;z-index: 9999;}
.ip_info {position: absolute;top: 50%;left: 50%;background: #fff;text-align: left;z-index: 99999;width: 90%;max-width: 530px;max-height: 80vh;transform: translate(-50%, -50%);overflow-y: auto;border-radius: 5px;box-shadow: 1px 1px 18px rgba(0, 0, 0, 0.2);border: 1px solid #dde7e9;}
.ip_info h3 {padding: 15px;margin: 0;font-size: 18px;border-bottom: 1px solid #e8e8e8;}
.ip_info .ip_info_cls {position: absolute;right: 10px;top: 10px;cursor: pointer;border: 0;background: none;width: 30px;height: 30px;display: flex;align-items: center;justify-content: center;}
.ip_info .ip_info_cls img {width: 100%;height: auto;}
.ip_info_bg {background: rgba(0, 0, 0, 0.3);width: 100%;height: 100%;position: absolute;top: 0;left: 0;}
.cont_info_wrap {border-bottom: 1px solid #eee;padding: 10px 15px;font-size: 14px;}
.cont_info_wrap dl {display: flex;flex-wrap: wrap;align-items: center;}
.cont_info_wrap dt {width: 30%;font-weight: bold;color: #666;}
.cont_info_wrap dd {width: 70%;color: #000;margin: 0;word-break: break-word;}
#flag {vertical-align: middle;width: 25px;height: auto;margin-left: 5px;border: 1px solid #ccc;}
</style>
<div class="ip_info_wrap">
    <div class="ip_info">
        <h3>접속자 IP정보</h3>
        <button type="button" class="ip_info_cls">
            <img src="<?php echo $connect_skin_url ?>/img/icon_close.svg">
        </button>
        <div id="ip_info">
            <div class="cont_info_wrap">
                <dl>
                    <dt>IP 주소</dt>
                    <dd id="ip_address"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>국가</dt>
                    <dd>
                        <span id="country"></span>
                        <img id="flag" src="" alt="국기">
                    </dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역</dt>
                    <dd id="city"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역 코드</dt>
                    <dd id="region"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>위치</dt>
                    <dd id="loc"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>시간대</dt>
                    <dd id="timezone"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>ISP</dt>
                    <dd id="org"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>Ranges</dt>
                    <dd id="ip_ranges"></dd>
                </dl>
            </div>
        </div>
    </div>
    <div class="ip_info_bg"></div>
</div>

<script>
$(".crt_ipInfo").on("click", function () {
    var info = $(this).attr("data-info"); // data-info 값 가져오기
    info = JSON.parse(info); // JSON 문자열을 JavaScript 객체로 변환

    // 정보 업데이트
    $("#ip_address").text(info.ip);
    $("#city").text(info.city);
    $("#region").text(info.region);
    $("#country").text(info.country);
    $("#flag").attr("src", info.flag_url);
    $("#loc").text(info.loc);
    $("#org").text(info.org);
    $("#timezone").text(info.timezone);
    $("#ip_ranges").text(info.ip_ranges);

    $(".ip_info_wrap").show();
});

$(".ip_info_bg, .ip_info_cls").click(function () {
    $(".ip_info_wrap").hide();
});
</script>
<?php /* IP정보 모달 끝 */ ?>