<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$connect_skin_url.'/style.css">', 0);

//==============================================================================
// 관리자 국가,IP정보 기본 출력
//------------------------------------------------------------------------------
$token = 'ACCESS_TOKEN';	// ipinfo.io 개인 액세스 토큰
$is_flag = true;			// 국가 출력여부 설정
$is_ipInfo = true;			// IP정보 출력여부 설정

function getIpInfo($ip, $token = null)
{
	global $is_admin;

	// 로컬 IP 처리
    if ($ip === '127.0.0.1' || $ip === '::1') {

		$info = [
            'ip' => $ip,
            'hostname' => 'localhost',
            'city' => 'N/A',
            'region' => 'N/A',
            'country' => 'N/A',
            'flag_url' => 'https://flagcdn.com/w80/un.png',
            'loc' => 'N/A',
            'postal' => 'N/A',
            'org' => 'N/A',
            'timezone' => 'N/A',
            'asn' => 'N/A',
            'ip_ranges' => 'N/A'
		];

		return $info;
    }

    $url = 'https://ipinfo.io/' . $ip . '?token=' . $token;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (!$data) {
        return "IP 정보를 가져오는 데 실패했습니다.";
    }

	// IP 마스킹
    $data['ip'] = $is_admin ? $data['ip'] : preg_replace("/(\d+)\.(\d+)\.(\d+)\.(\d+)/", G5_IP_DISPLAY, $data['ip']);

    // 국가 코드 소문자로 변환
    $countryCode = strtolower($data['country'] ?? '');
    $flagUrl = $countryCode ? "https://flagcdn.com/w80/$countryCode.png" : 'https://flagcdn.com/w80/un.png';

    // IP 대역 정보 가져오기
    $ipRanges = getIpRanges($data['ip']);

    // 정보 배열로 분리하여 반환
	$info = [
		'ip' => isset($data['ip']) ? $data['ip'] : '',
		'hostname' => isset($data['hostname']) ? $data['hostname'] : '',
		'city' => isset($data['city']) ? $data['city'] : '',
		'region' => isset($data['region']) ? $data['region'] : '',
		'country' => isset($data['country']) ? $data['country'] : '',
		'flag_url' => $flagUrl,
		'loc' => isset($data['loc']) ? $data['loc'] : '',
		'postal' => isset($data['postal']) ? $data['postal'] : '',
		'org' => isset($data['org']) ? $data['org'] : '',
		'timezone' => isset($data['timezone']) ? $data['timezone'] : '',
		'asn' => isset($data['asn']) ? $data['asn'] : '',
		'ip_ranges' => displayIpRanges($ipRanges)
	];

    return $info;
}

function getIpRanges($ip)
{
    $hierarchy = [];
    $ranges[] = getBaseIp($ip, 8) . "/8";
    $ranges[] = getBaseIp($ip, 16) . "/16";
    $ranges[] = getBaseIp($ip, 24) . "/24";


    $ranges[] = $ip; // 현재 IP 추가

    return $ranges;
}

function getBaseIp($ip, $prefix)
{
    $ipParts = explode('.', $ip);

    if ($prefix <= 8) {
        return "{$ipParts[0]}.0.0.0";
    } elseif ($prefix <= 16) {
        return "{$ipParts[0]}.{$ipParts[1]}.0.0";
    } elseif ($prefix <= 24) {
        return "{$ipParts[0]}.{$ipParts[1]}.{$ipParts[2]}.0";
    }

    return $ip;
}

function displayIpRanges($ipRanges)
{
    $output = implode(' > ', $ipRanges);
    return $output;
}

?>

<!-- 현재접속자 목록 시작 { -->
<div id="current_connect">
    <ul>
		<?php
		for ($i=0; $i<count($list); $i++) {
			//$location = conv_content($list[$i]['lo_location'], 0);
			$location = $list[$i]['lo_location'];
			// 최고관리자에게만 허용
			// 이 조건문은 가능한 변경하지 마십시오.
			if ($list[$i]['lo_url'] && $is_admin == 'super') $display_location = "<a href=\"".$list[$i]['lo_url']."\">".$location."</a>";
			else $display_location = $location;

			$ipInfo = getIpInfo($list[$i]['lo_ip'], $token);
			$data_ipInfo = htmlspecialchars(json_encode($ipInfo, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8');
		?>
        <li>
            <span class="crt_num"><?php echo $list[$i]['num'] ?></span>
			<?php if($is_flag || $is_admin == 'super'){ ?>
			<span class="crt_flag"><img src="<?php echo $ipInfo['flag_url'];?>" alt="<?php echo $ipInfo['country'];?>" style='vertical-align:middle;border:1px solid #ccc;width:25px;height:auto;'></span>
			<?php } ?>
            <span class="crt_profile"><?php echo get_member_profile_img($list[$i]['mb_id']); ?></span>
            <div class="crt_info">
            	<span class="crt_name">
					<?php if($is_ipInfo || $is_admin == 'super'){ ?>
					<a href="javascript:;" class="crt_ipInfo" data-info='<?php echo $data_ipInfo;?>'><?php echo $list[$i]['name'] ?></a>
					<?php }else{ ?>
					<?php echo $list[$i]['name'] ?>
					<?php } ?>
				</span>
            	<span class="crt_lct"><?php echo $display_location ?></span>
            </div>
        </li>
		<?php
		}
		if ($i == 0)
			echo "<li class=\"empty_li\">현재 접속자가 없습니다.</li>";
		?>
    </ul>
</div>
<!-- } 현재접속자 목록 끝 -->

<!-- IP정보 모달 시작 { -->
<div id="ip_info_wrap">
    <div class="ip_info">
        <h3>접속자 IP 정보</h3>
        <button type="button" class="ip_info_cls">
            <img src="<?php echo $connect_skin_url ?>/img/icon_close.svg" alt="닫기">
        </button>
        <div id="ip_info">
            <div class="cont_info_wrap">
                <dl>
                    <dt>IP 주소</dt>
                    <dd id="ip_address"></dd>
                </dl>
            </div>
			<?php if($is_admin){ ?>
            <div class="cont_info_wrap">
                <dl>
                    <dt></dt>
                    <dd>
                        <a href="#" class="block-ip" data-ip-type="full">차단: 전체 IP</a>
                        <a href="#" class="block-ip" data-ip-type="range">차단: IP 대역 <span id="block-ip-range"></span></a>
                    </dd>
                </dl>
            </div>
			<?php } ?>
            <div class="cont_info_wrap">
                <dl>
                    <dt>국가</dt>
                    <dd>
                        <span id="country"></span>
                        <img id="flag" src="" alt="국기">
                    </dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역</dt>
                    <dd id="city"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>지역 코드</dt>
                    <dd id="region"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>위치</dt>
                    <dd id="loc"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>시간대</dt>
                    <dd id="timezone"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>ISP</dt>
                    <dd id="org"></dd>
                </dl>
            </div>
            <div class="cont_info_wrap">
                <dl>
                    <dt>Ranges</dt>
                    <dd id="ip_ranges"></dd>
                </dl>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
	// IP 정보 표시
    $(".crt_ipInfo").on("click", function(e) {
        e.preventDefault();
        var info = $(this).attr("data-info"); // data-info 값 가져오기
        try {
            info = JSON.parse(info); // JSON 문자열을 JavaScript 객체로 변환
            // 모달 내 요소 업데이트
            $("#ip_address").text(info.ip || "N/A");
            $("#country").text(info.country || "N/A");
            $("#flag").attr("src", info.flag_url || "");
            $("#city").text(info.city || "N/A");
            $("#region").text(info.region || "N/A");
            $("#loc").text(info.loc || "N/A");
            $("#timezone").text(info.timezone || "N/A");
            $("#org").text(info.org || "N/A");
            $("#ip_ranges").text(info.ip_ranges || "N/A");

			// IP 대역 계산 및 링크 텍스트 설정
            var ipAddress = info.ip || "";
            var ipRangeText = "N/A";
            if (ipAddress && ipAddress.split(".").length === 4) {
                var ipParts = ipAddress.split(".");
                ipRangeText = ipParts[0] + "." + ipParts[1] + ".+";
            }
            $("#block-ip-range").text(ipRangeText);

            $("#ip_info_wrap").show();
        } catch (err) {
            console.error("JSON 파싱 오류:", err);
            alert("IP 정보를 불러오는 데 실패했습니다.");
        }
    });

	<?php if($is_admin){ ?>
	// 차단 IP 등록
	$(".block-ip").on("click", function(e) {
		e.preventDefault();

		var ipAddress = $("#ip_address").text(); // 표시된 IP 주소 가져오기
		if (!ipAddress || ipAddress === "N/A") {
            alert("IP 주소가 없습니다.");
            return;
        }

		var ipType = $(this).data("ip-type");
		var ipToBlock;

		if (ipType === "full") {
			ipToBlock = ipAddress; // 전체 IP: 123.123.123.123
		} else if (ipType === "range") {
			// IP 대역: 123.123.*
			var ipParts = ipAddress.split(".");
			if (ipParts.length === 4) {
				ipToBlock = ipParts[0] + "." + ipParts[1] + ".+";
			} else {
				alert("유효하지 않은 IP 형식입니다.");
				return;
			}
		}

		// AJAX 요청
		$.ajax({
			url: "<?php echo $connect_skin_url ?>/block_ip_update.php",
			type: "POST",
			data: {
				ip_to_block: ipToBlock
			},
			success: function(response) {
				if (response.success) {
					alert("IP가 차단 목록에 추가되었습니다.");
					$("#ip_info_wrap").hide(); // 차단 후 창 닫기 (선택 사항)
				} else {
					alert("IP 차단에 실패했습니다: " + response.message);
					$("#ip_info_wrap").hide(); // 실패시 창 닫기 (선택 사항)
				}
			},
			error: function() {
				alert("서버와의 통신에 실패했습니다.");
			},
			dataType: "json"
		});
	});
	<?php } ?>

	$(".ip_info_bg, .ip_info_cls").click(function () {
		$("#ip_info_wrap").hide();
	});
});
</script>
<!-- } IP정보 모달 끝 -->