<?php
// 회원 정보 배열에서 회원 아이디를 변수에 저장
$mb_id = $member['mb_id'];
?>

<!-- 이모티콘 버튼: 사용자가 클릭하면 이모티콘 선택 모달창이 열립니다 -->
<button id="emojiBtn1">
  <!-- 버튼 내 표시할 이미지. 보드 스킨 경로 내 'emoicon.png' 파일 사용 -->
  <img src="<?php echo $board_skin_url ?>/img/emoicon.png" alt="이모지 선택">
  <span>이모티콘</span>
</button>

<!-- 이모티콘 선택 모달창: 초기에 display:none 으로 숨김 -->
<div id="emojiModal1" class="modal1" style="display:none;">
  <div class="modal-content1">
    <!-- 모달창 닫기 버튼 (클릭 시 모달창을 닫음) -->
    <span class="modalClose1">&times;</span>
    <h3>이모티콘을 선택하세요</h3>

    <div class="emoji-container1">
      <!-- 무료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 무료 이모티콘 제목 -->
        <div id="emoji-sub-free" class="emoji-sub1">무료 이모티콘</div>
        <div class="emoji-group">
          <?php
          // 1부터 121까지 반복하며 무료 이모티콘 이미지 태그를 동적으로 생성
          for ($i = 1; $i <= 121; $i++) {
            echo '<img src="'.G5_IMG_URL.'/emoticon/free/free_emoticon'.$i.'.png" alt="free_emoticon'.$i.'" class="emoticon-insert" data-code="[free_emoticon'.$i.']">';
          }
          ?>
        </div>
      </div>

      <!-- 기간제 무료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 기간제 무료 이모티콘 제목 -->
        <div id="emoji-sub-promo" class="emoji-sub1">기간제 무료 이모티콘</div>
        <?php
        // 사용자 보유의 기간제 이모티콘 패키지 정보를 데이터베이스에서 가져옴
        $sql = "SELECT package_code FROM g5_emoticon_user_package_promo WHERE mb_id = '{$mb_id}' AND is_active = '1'";
        $res_pkg = sql_query($sql);

        // 각 패키지 그룹(space, sport, object)의 보유 여부를 체크
        $hasGroupA = $hasGroupB = $hasGroupC = false;
        while ($row = sql_fetch_array($res_pkg)) {
          switch ($row['package_code']) {
            case 'space': 
              $hasGroupA = true; 
              break;
            case 'sport': 
              $hasGroupB = true; 
              break;
            case 'object': 
              $hasGroupC = true; 
              break;
          }
        }

        // 하나 이상의 패키지를 보유한 경우 해당 이모티콘들을 출력
        if ($hasGroupA || $hasGroupB || $hasGroupC) {
          // 그룹 A (space) 이모티콘 출력
          if ($hasGroupA) {
            echo '<div class="emoji-sub2">기간제 이모티콘 A (space)</div><div class="emoji-group">';
            for ($i = 1; $i <= 10; $i++) {
              $code = "space_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/space/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }

          // 그룹 B (sport) 이모티콘 출력
          if ($hasGroupB) {
            echo '<div class="emoji-sub2">기간제 이모티콘 B (sport)</div><div class="emoji-group">';
            for ($i = 1; $i <= 12; $i++) {
              $code = "sport_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/sport/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }

          // 그룹 C (object) 이모티콘 출력
          if ($hasGroupC) {
            echo '<div class="emoji-sub2">기간제 이모티콘 C (object)</div><div class="emoji-group">';
            for ($i = 1; $i <= 15; $i++) {
              $code = "object_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/object/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }
        } else {
          // 사용자가 보유한 기간제 무료 이모티콘이 없을 경우 안내 문구 출력
          echo '<p id="no_promo_emoticon">보유한 기간제 무료 <br> 이모티콘이 없습니다.</p>';
        }
        ?>
      </div>

      <!-- 유료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 유료 이모티콘 제목 -->
        <div id="emoji-sub-paid" class="emoji-sub1">유료 이모티콘</div>
        <?php
        // 사용자 보유 유료 이모티콘 정보를 데이터베이스에서 가져옴
        $res_paid = sql_query("SELECT paid_emoticon_code FROM g5_emoticon_user_paid WHERE mb_id = '{$mb_id}' AND is_active = 1");

        // DB에서 가져온 유료 이모티콘 코드를 배열에 저장
        $ownedPaid = [];
        while ($row = sql_fetch_array($res_paid)) {
          $ownedPaid[] = $row['paid_emoticon_code'];
        }

        $hasPaid = false;
        // 보유한 유료 이모티콘이 있는지 확인 후 해당 이모티콘들을 출력
		if (!empty($ownedPaid)) {
		  echo '<div class="emoji-group">';
		  // 1부터 30까지 유료 이모티콘을 순회하면서 사용자가 보유한 이모티콘이면 출력
		  for ($i = 1; $i <= 30; $i++) {
			$code = "paid1_emoticon{$i}";
			if (in_array($code, $ownedPaid)) {
			  $hasPaid = true;
			  echo '<img src="'.G5_IMG_URL.'/emoticon/paid/paid1/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">' . PHP_EOL;
			}
		  }
		  echo '</div>';
		}

        // 보유한 유료 이모티콘이 없을 경우 안내 문구 출력
        if (!$hasPaid) {
          echo '<p id="no_paid_emoticon">보유한 유료 이모티콘이 없습니다.</p>';
        }
        ?>
      </div>
    </div>
  </div>
</div>

<!-- 이모티콘 선택 기능과 텍스트 영역에 삽입을 위한 JavaScript 코드 -->
<script>
// DOM이 모두 로드된 후 실행
document.addEventListener('DOMContentLoaded', function () {
  // 이모티콘 버튼, 모달창, 모달 닫기 버튼 요소 선택
  const emojiBtn = document.getElementById('emojiBtn1');
  const emojiModal = document.getElementById('emojiModal1');
  const modalClose = document.querySelector('.modalClose1');

  // 이모티콘 버튼 클릭 시 모달창을 보이도록 처리
  if (emojiBtn && emojiModal) {
    emojiBtn.addEventListener('click', function (e) {
      e.preventDefault();      // 기본 동작 차단
      e.stopPropagation();     // 이벤트 전파 중지
      emojiModal.style.display = "block"; // 모달창 표시
    });
  }

  // 모달창 닫기 버튼 클릭 시 모달창을 숨김 처리
  if (modalClose) {
    modalClose.addEventListener('click', function () {
      emojiModal.style.display = "none";
    });
  }

  // 모든 이모티콘 이미지(클래스 이름: emoticon-insert)를 선택
  const emojiImgs = document.querySelectorAll('.emoticon-insert');
  if (emojiImgs.length > 0) {
    emojiImgs.forEach(function (img) {
      // 각 이미지에 클릭 이벤트 리스너 등록
      img.addEventListener('click', function () {
        // data-code 속성에 저장된 이모티콘 코드를 불러옴
        const code = this.getAttribute('data-code');
        // 텍스트 입력 영역 (textarea)의 id는 'wr_content'로 가정
        const textarea = document.getElementById('wr_content');

        // 이모티콘 코드와 텍스트 영역이 존재하면 이모티콘 코드를 텍스트 영역에 삽입
        if (code && textarea) {
          // 현재 커서의 시작 및 끝 위치를 가져옴
          const start = textarea.selectionStart;
          const end = textarea.selectionEnd;
          // 현재 텍스트 영역의 전체 텍스트 내용
          const text = textarea.value;
          // 커서 왼쪽과 오른쪽의 텍스트를 분리
          const before = text.substring(0, start);
          const after  = text.substring(end, text.length);
          // 이모티콘 코드와 한 칸의 공백을 사이에 두고 텍스트 내용 재설정
          textarea.value = before + code + " " + after;

          // 커서 위치를 이모티콘 코드가 추가된 후 위치로 이동
          const cursorPosition = start + code.length + 1;
          textarea.setSelectionRange(cursorPosition, cursorPosition);
          textarea.focus();
        }

        // 이모티콘 선택 후 모달창을 닫음
        emojiModal.style.display = "none";
      });
    });
  }

  // 모달창 바깥을 클릭하면 모달창을 닫도록 처리
  window.addEventListener('click', function (e) {
    if (e.target === emojiModal) {
      emojiModal.style.display = "none";
    }
  });
});
</script>
