<?php
// 회원 정보 배열에서 회원 아이디를 추출하여 변수에 저장
$mb_id = $member['mb_id'];
?>

<!-- 이모티콘 버튼: 사용자가 클릭하면 이모티콘 선택 모달창이 열립니다. -->
<button id="emojiBtn1">
  <!-- 버튼에 표시될 이미지 (보드 스킨 경로에 있는 이모티콘 이미지) -->
  <img src="<?php echo $board_skin_url ?>/img/emoicon.png" alt="이모지 선택">
  <span>이모티콘</span>
</button>

<!-- 이모티콘 선택 모달창 -->
<div id="emojiModal1" class="modal1" style="display:none;">
  <div class="modal-content1">
    <!-- 모달창 닫기 버튼 -->
    <span class="modalClose1">&times;</span>
    <h3>이모티콘을 선택하세요</h3>

    <div class="emoji-container1">
      <!-- 무료 이모티콘 영역 -->
	  <div class="emoji-section1">
	    <!-- 섹션 제목: 무료 이모티콘 -->
	    <div id="emoji-sub-free" class="emoji-sub1">무료 이모티콘</div>
	    <div class="emoji-group">
		<?php
		// 1부터 121까지의 번호를 반복하며, 각 번호에 해당하는 무료 이모티콘 이미지 태그를 생성
		for ($i = 1; $i <= 121; $i++) {
		  echo '<img src="'.G5_IMG_URL.'/emoticon/free/free_emoticon'.$i.'.png" alt="free_emoticon'.$i.'" class="emoticon-insert" data-code="[free_emoticon'.$i.']">';
		}
		?>
	    </div>
	  </div>

      <!-- 기간제 무료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 섹션 제목: 기간제 무료 이모티콘 -->
        <div id="emoji-sub-promo" class="emoji-sub1">기간제 무료 이모티콘</div>
        <?php
        // 사용자 보유 기간제 이모티콘 패키지 정보를 DB에서 가져오기 위한 SQL 쿼리
        $sql = "SELECT package_code FROM g5_emoticon_user_package_promo WHERE mb_id = '{$mb_id}' AND is_active = '1'";
        $res_pkg = sql_query($sql);

        // 각 패키지 그룹별로 사용자가 보유 여부를 체크 (space, sport, object)
        $hasGroupA = $hasGroupB = $hasGroupC = false;
        while ($row = sql_fetch_array($res_pkg)) {
          switch ($row['package_code']) {
            case 'space': $hasGroupA = true; break;
            case 'sport': $hasGroupB = true; break;
            case 'object': $hasGroupC = true; break;
          }
        }

        // 하나 이상의 패키지를 보유한 경우 해당 이모티콘들을 출력
        if ($hasGroupA || $hasGroupB || $hasGroupC) {
          // 그룹 A (space) 이모티콘 출력
          if ($hasGroupA) {
            echo '<div class="emoji-sub2">기간제 이모티콘 A (space)</div><div class="emoji-group">';
            for ($i = 1; $i <= 10; $i++) {
              $code = "space_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/space/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }

          // 그룹 B (sport) 이모티콘 출력
          if ($hasGroupB) {
            echo '<div class="emoji-sub2">기간제 이모티콘 B (sport)</div><div class="emoji-group">';
            for ($i = 1; $i <= 12; $i++) {
              $code = "sport_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/sport/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }

          // 그룹 C (object) 이모티콘 출력
          if ($hasGroupC) {
            echo '<div class="emoji-sub2">기간제 이모티콘 C (object)</div><div class="emoji-group">';
            for ($i = 1; $i <= 15; $i++) {
              $code = "object_emoticon{$i}";
              echo '<img src="'.G5_IMG_URL.'/emoticon/promo/object/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">';
            }
            echo '</div>';
          }
        } else {
          // 보유한 기간제 무료 이모티콘이 없을 경우 안내 메시지 출력
          echo '<p id="no_promo_emoticon">보유한 기간제 무료 <br> 이모티콘이 없습니다.</p>';
        }
        ?>
      </div>

      <!-- 유료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 섹션 제목: 유료 이모티콘 -->
        <div id="emoji-sub-paid" class="emoji-sub1">유료 이모티콘</div>
        <?php
        // 사용자 보유 유료 이모티콘 정보를 DB에서 가져오기 위한 SQL 쿼리
        $res_paid = sql_query("SELECT paid_emoticon_code FROM g5_emoticon_user_paid WHERE mb_id = '{$mb_id}' AND is_active = 1");

        // 가져온 유료 이모티콘 코드를 배열에 저장
        $ownedPaid = [];
        while ($row = sql_fetch_array($res_paid)) {
          $ownedPaid[] = $row['paid_emoticon_code'];
        }

        $hasPaid = false;
		// 보유한 유료 이모티콘이 존재하면 출력
		if (!empty($ownedPaid)) {
		  echo '<div class="emoji-group">';
		  // 1부터 30까지의 번호에 대해 유료 이모티콘 출력
		  for ($i = 1; $i <= 30; $i++) {
			$code = "paid1_emoticon{$i}";
			// 사용자가 해당 이모티콘을 보유하고 있는지 확인 후 출력
			if (in_array($code, $ownedPaid)) {
			  $hasPaid = true;
			  echo '<img src="'.G5_IMG_URL.'/emoticon/paid/paid1/'.$code.'.png" alt="'.$code.'" class="emoticon-insert" data-code="['.$code.']">' . PHP_EOL;
			}
		  }
		  echo '</div>';
		}
        // 보유한 유료 이모티콘이 없으면 안내 메시지 출력
        if (!$hasPaid) {
          echo '<p id="no_paid_emoticon">보유한 유료 이모티콘이 없습니다.</p>';
        }
        ?>
      </div>
    </div>
  </div>
</div>

<!-- 이모티콘 선택 기능 관련 JavaScript -->
<script>
// DOM이 완전히 로드된 후 실행
document.addEventListener('DOMContentLoaded', function () {
  // 버튼, 모달창, 모달 닫기 버튼 요소 참조
  const emojiBtn = document.getElementById('emojiBtn1');
  const emojiModal = document.getElementById('emojiModal1');
  const modalClose = document.querySelector('.modalClose1');

  // 이모티콘 버튼 클릭시 모달창을 보이도록 설정
  if (emojiBtn && emojiModal) {
    emojiBtn.addEventListener('click', function (e) {
      e.preventDefault();      // 기본 이벤트 막음
      e.stopPropagation();     // 이벤트 전파 방지
      emojiModal.style.display = "block"; // 모달창 표시
    });
  }

  // 모달창 닫기 버튼 클릭시 모달창을 숨김
  if (modalClose) {
    modalClose.addEventListener('click', function () {
      emojiModal.style.display = "none";
    });
  }

  // 모든 이모티콘 이미지에 대해 클릭 이벤트를 등록
  const emojiImgs = document.querySelectorAll('.emoticon-insert');
  if (emojiImgs.length > 0) {
    emojiImgs.forEach(function (img) {
      img.addEventListener('click', function () {
        // data-code 속성에 있는 이모티콘 코드를 가져옴
        const code = this.getAttribute('data-code');
        // oEditors (에디터 객체)가 존재하고 해당 아이디의 에디터가 존재하면 해당 위치에 이모티콘 HTML 코드 삽입
        if (code && window.oEditors && oEditors.getById["wr_content"]) {
          oEditors.getById["wr_content"].exec("PASTE_HTML", [code + "&nbsp;"]);
        }
        // 이모티콘 선택 후 모달창 숨김
        emojiModal.style.display = "none";
      });
    });
  }

  // 모달창 바깥 영역을 클릭할 경우 모달창을 숨김
  window.addEventListener('click', function (e) {
    if (e.target === emojiModal) {
      emojiModal.style.display = "none";
    }
  });
});
</script>
