<script>
  // DOM이 모두 로드된 후 실행하기 위한 이벤트 리스너 등록
  document.addEventListener("DOMContentLoaded", function () {
    // #bo_v_con과 #bo_vc 선택자에 해당하는 요소들을 모두 선택
    const contentEls = document.querySelectorAll("#bo_v_con, #bo_vc");
    // 선택된 요소가 하나도 없으면 이후 코드를 실행하지 않고 종료
    if (!contentEls.length) return;

    // 이모티콘 문자열과 해당 이미지 폴더 정보를 담은 배열 정의
    // 각각의 배열은 특정 이모티콘 그룹을 나타내며, emoiticons 배열에는 이모티콘 코드를 생성
    const replacements = [
      {
        // 무료 이모티콘: free_emoticon1 ~ free_emoticon121
        emoticons: Array.from({ length: 121 }, (_, i) => `free_emoticon${i + 1}`),
        folder: "free"
      }
    ];

    // 선택된 각 요소에 대하여 이모티콘 태그로 대체하는 작업 수행
    contentEls.forEach(contentEl => {
      // 현재 요소의 HTML 내용을 변수에 저장
      let html = contentEl.innerHTML;

      // replacements 배열 내 각 이모티콘 그룹 처리
      replacements.forEach(rep => {
        // 각 이모티콘 코드를 순회하면서 현재 HTML 내용에서 해당 이모티콘 코드를 찾음
        rep.emoticons.forEach(emo => {
          // 정규표현식을 통해 '[이모티콘코드]' 패턴과 일치하는 부분을 찾음 (전역 검색)
          const regex = new RegExp(`\\[${emo}\\]`, "g");
          // 해당 이모티콘 코드를 이미지 태그로 변환하는 HTML 문자열 생성
          const imgTag = `<img src="<?php echo G5_IMG_URL ?>/emoticon/${rep.folder}/${emo}.png" alt="${emo}" class="emoticon-img">`;
          // 정규표현식과 일치하는 텍스트를 이미지 태그로 교체
          html = html.replace(regex, imgTag);
        });
      });

      // 변환된 HTML 내용을 다시 요소에 적용
      contentEl.innerHTML = html;
    });
  });
</script>
