<?php
// 회원 정보 배열에서 회원 아이디를 변수에 저장
$mb_id = $member['mb_id'];
?>

<!-- 이모티콘 버튼: 사용자가 클릭하면 이모티콘 선택 모달창이 열립니다 -->
<button id="emojiBtn1">
  <!-- 버튼 내 표시할 이미지. 보드 스킨 경로 내 'emoicon.png' 파일 사용 -->
  <img src="<?php echo $board_skin_url ?>/img/emoicon.png" alt="이모지 선택">
  <span>이모티콘</span>
</button>

<!-- 이모티콘 선택 모달창: 초기에 display:none 으로 숨김 -->
<div id="emojiModal1" class="modal1" style="display:none;">
  <div class="modal-content1">
    <!-- 모달창 닫기 버튼 (클릭 시 모달창을 닫음) -->
    <span class="modalClose1">&times;</span>
    <h3>이모티콘을 선택하세요</h3>

    <div class="emoji-container1">
      <!-- 무료 이모티콘 영역 -->
      <div class="emoji-section1">
        <!-- 무료 이모티콘 제목 -->
        <div id="emoji-sub-free" class="emoji-sub1">무료 이모티콘</div>
        <div class="emoji-group">
          <?php
          // 1부터 121까지 반복하며 무료 이모티콘 이미지 태그를 동적으로 생성
          for ($i = 1; $i <= 121; $i++) {
            echo '<img src="'.G5_IMG_URL.'/emoticon/free/free_emoticon'.$i.'.png" alt="free_emoticon'.$i.'" class="emoticon-insert" data-code="[free_emoticon'.$i.']">';
          }
          ?>
        </div>
      </div>
  </div>
</div>

<!-- 이모티콘 선택 기능과 텍스트 영역에 삽입을 위한 JavaScript 코드 -->
<script>
// DOM이 모두 로드된 후 실행
document.addEventListener('DOMContentLoaded', function () {
  // 이모티콘 버튼, 모달창, 모달 닫기 버튼 요소 선택
  const emojiBtn = document.getElementById('emojiBtn1');
  const emojiModal = document.getElementById('emojiModal1');
  const modalClose = document.querySelector('.modalClose1');

  // 이모티콘 버튼 클릭 시 모달창을 보이도록 처리
  if (emojiBtn && emojiModal) {
    emojiBtn.addEventListener('click', function (e) {
      e.preventDefault();      // 기본 동작 차단
      e.stopPropagation();     // 이벤트 전파 중지
      emojiModal.style.display = "block"; // 모달창 표시
    });
  }

  // 모달창 닫기 버튼 클릭 시 모달창을 숨김 처리
  if (modalClose) {
    modalClose.addEventListener('click', function () {
      emojiModal.style.display = "none";
    });
  }

  // 모든 이모티콘 이미지(클래스 이름: emoticon-insert)를 선택
  const emojiImgs = document.querySelectorAll('.emoticon-insert');
  if (emojiImgs.length > 0) {
    emojiImgs.forEach(function (img) {
      // 각 이미지에 클릭 이벤트 리스너 등록
      img.addEventListener('click', function () {
        // data-code 속성에 저장된 이모티콘 코드를 불러옴
        const code = this.getAttribute('data-code');
        // 텍스트 입력 영역 (textarea)의 id는 'wr_content'로 가정
        const textarea = document.getElementById('wr_content');

        // 이모티콘 코드와 텍스트 영역이 존재하면 이모티콘 코드를 텍스트 영역에 삽입
        if (code && textarea) {
          // 현재 커서의 시작 및 끝 위치를 가져옴
          const start = textarea.selectionStart;
          const end = textarea.selectionEnd;
          // 현재 텍스트 영역의 전체 텍스트 내용
          const text = textarea.value;
          // 커서 왼쪽과 오른쪽의 텍스트를 분리
          const before = text.substring(0, start);
          const after  = text.substring(end, text.length);
          // 이모티콘 코드와 한 칸의 공백을 사이에 두고 텍스트 내용 재설정
          textarea.value = before + code + " " + after;

          // 커서 위치를 이모티콘 코드가 추가된 후 위치로 이동
          const cursorPosition = start + code.length + 1;
          textarea.setSelectionRange(cursorPosition, cursorPosition);
          textarea.focus();
        }

        // 이모티콘 선택 후 모달창을 닫음
        emojiModal.style.display = "none";
      });
    });
  }

  // 모달창 바깥을 클릭하면 모달창을 닫도록 처리
  window.addEventListener('click', function (e) {
    if (e.target === emojiModal) {
      emojiModal.style.display = "none";
    }
  });
});
</script>
