<?php
// 회원 정보 배열에서 회원 아이디를 추출하여 변수에 저장
$mb_id = $member['mb_id'];
?>

<!-- 이모티콘 버튼: 사용자가 클릭하면 이모티콘 선택 모달창이 열립니다. -->
<button id="emojiBtn1">
  <!-- 버튼에 표시될 이미지 (보드 스킨 경로에 있는 이모티콘 이미지) -->
  <img src="<?php echo $board_skin_url ?>/img/emoicon.png" alt="이모지 선택">
  <span>이모티콘</span>
</button>

<!-- 이모티콘 선택 모달창 -->
<div id="emojiModal1" class="modal1" style="display:none;">
  <div class="modal-content1">
    <!-- 모달창 닫기 버튼 -->
    <span class="modalClose1">&times;</span>
    <h3>이모티콘을 선택하세요</h3>

    <div class="emoji-container1">
      <!-- 무료 이모티콘 영역 -->
	  <div class="emoji-section1">
	    <!-- 섹션 제목: 무료 이모티콘 -->
	    <div id="emoji-sub-free" class="emoji-sub1">무료 이모티콘</div>
	    <div class="emoji-group">
		<?php
		// 1부터 121까지의 번호를 반복하며, 각 번호에 해당하는 무료 이모티콘 이미지 태그를 생성
		for ($i = 1; $i <= 121; $i++) {
		  echo '<img src="'.G5_IMG_URL.'/emoticon/free/free_emoticon'.$i.'.png" alt="free_emoticon'.$i.'" class="emoticon-insert" data-code="[free_emoticon'.$i.']">';
		}
		?>
	    </div>
	  </div>
  </div>
</div>

<!-- 이모티콘 선택 기능 관련 JavaScript -->
<script>
// DOM이 완전히 로드된 후 실행
document.addEventListener('DOMContentLoaded', function () {
  // 버튼, 모달창, 모달 닫기 버튼 요소 참조
  const emojiBtn = document.getElementById('emojiBtn1');
  const emojiModal = document.getElementById('emojiModal1');
  const modalClose = document.querySelector('.modalClose1');

  // 이모티콘 버튼 클릭시 모달창을 보이도록 설정
  if (emojiBtn && emojiModal) {
    emojiBtn.addEventListener('click', function (e) {
      e.preventDefault();      // 기본 이벤트 막음
      e.stopPropagation();     // 이벤트 전파 방지
      emojiModal.style.display = "block"; // 모달창 표시
    });
  }

  // 모달창 닫기 버튼 클릭시 모달창을 숨김
  if (modalClose) {
    modalClose.addEventListener('click', function () {
      emojiModal.style.display = "none";
    });
  }

  // 모든 이모티콘 이미지에 대해 클릭 이벤트를 등록
  const emojiImgs = document.querySelectorAll('.emoticon-insert');
  if (emojiImgs.length > 0) {
    emojiImgs.forEach(function (img) {
      img.addEventListener('click', function () {
        // data-code 속성에 있는 이모티콘 코드를 가져옴
        const code = this.getAttribute('data-code');
        // oEditors (에디터 객체)가 존재하고 해당 아이디의 에디터가 존재하면 해당 위치에 이모티콘 HTML 코드 삽입
        if (code && window.oEditors && oEditors.getById["wr_content"]) {
          oEditors.getById["wr_content"].exec("PASTE_HTML", [code + "&nbsp;"]);
        }
        // 이모티콘 선택 후 모달창 숨김
        emojiModal.style.display = "none";
      });
    });
  }

  // 모달창 바깥 영역을 클릭할 경우 모달창을 숨김
  window.addEventListener('click', function (e) {
    if (e.target === emojiModal) {
      emojiModal.style.display = "none";
    }
  });
});
</script>
