<?php
include_once('./_common.php');

// 로그인 확인
if (!$is_member) {
    die(json_encode(array('error' => '로그인이 필요합니다.')));
}

// 필수 파라미터 확인
if (!isset($_POST['bo_table']) || !isset($_POST['wr_id']) || !isset($_POST['point_amount'])) {
    die(json_encode(array('error' => '잘못된 요청입니다.')));
}

$bo_table = isset($_POST['bo_table']) ? clean_xss_tags($_POST['bo_table']) : '';
$wr_id = isset($_POST['wr_id']) ? (int)$_POST['wr_id'] : 0;
$point_amount = isset($_POST['point_amount']) ? (int)$_POST['point_amount'] : 0;

// 게시물 정보 확인
$write_table = $g5['write_prefix'] . $bo_table;
$write = sql_fetch(" select * from $write_table where wr_id = '$wr_id' ");

if (!$write) {
    die(json_encode(array('error' => '존재하지 않는 게시물입니다.')));
}

// 자신의 게시물에는 포인트 선물 불가
if ($write['mb_id'] == $member['mb_id']) {
    die(json_encode(array('error' => '자신의 게시물에는 포인트를 선물할 수 없습니다.')));
}

// 포인트 설정 가져오기
$sql = " select * from g5_point_gift where bo_table = '{$bo_table}' ";
$point_gift = sql_fetch($sql);

// 반복 선물 허용 여부 확인
if ($point_gift['allow_repeat'] == 0) {
    // 이미 선물한 내역이 있는지 확인
    $sql = " select count(*) as cnt from {$g5['point_table']} 
             where mb_id = '{$member['mb_id']}' 
             and po_rel_table = '{$bo_table}' 
             and po_rel_id = '{$wr_id}' 
             and po_rel_action = 'gift' ";
    $row = sql_fetch($sql);
    
    if ($row['cnt'] > 0) {
        die(json_encode(array('error' => '이미 이 게시물에 포인트를 선물하셨습니다.')));
    }
}

// 포인트 선물 최소 및 최대값 체크
if ($point_amount < $point_gift['min_point']) {
    die(json_encode(array('error' => '최소 '.number_format($point_gift['min_point']).'포인트 이상 선물해야 합니다.')));
}

if ($point_amount > $point_gift['max_point']) {
    die(json_encode(array('error' => '최대 '.number_format($point_gift['max_point']).'포인트까지 선물할 수 있습니다.')));
}

// 보유 포인트 확인
if ($point_amount > $member['mb_point']) {
    die(json_encode(array('error' => '보유하신 포인트보다 많은 포인트를 선물할 수 없습니다.')));
}

// 포인트 차감 및 지급 처리
$content = $board['bo_subject'].' '.$wr_id.' 게시물에 포인트 선물';

// 선물을 준 사람 포인트 차감 (고유값 추가)
$unique_id = uniqid();
insert_point($member['mb_id'], -$point_amount, $content, $bo_table, $wr_id, 'gift_'.$unique_id);

// 글 작성자에게 포인트 지급 (고유값 추가)
insert_point($write['mb_id'], $point_amount, $member['mb_id'].'님의 포인트 선물', $bo_table, $wr_id, 'gift_receive_'.$unique_id);

// 현재 남은 포인트 계산
$remain_point = $member['mb_point'] - $point_amount;

// 성공 응답
echo json_encode(array(
    'message' => number_format($point_amount).'포인트가 성공적으로 선물되었습니다.',
    'remain_point' => number_format($remain_point),
    'success' => true
));
exit;
?>
