<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 관리자가 아니면 접근 제한
if ($is_admin != 'super' && !$is_admin)
    alert('관리자만 접근 가능합니다.');

// 설정 저장 처리
if (isset($_POST['point_gift_submit']) && $_POST['point_gift_submit']) {
    $use_paging = isset($_POST['use_paging']) ? 1 : 0;
    $list_count = isset($_POST['list_count']) ? (int)$_POST['list_count'] : 10;
    $use_asta = isset($_POST['use_asta']) ? 1 : 0;
    $use_count = isset($_POST['use_count']) ? 1 : 0;
    $allow_repeat = isset($_POST['allow_repeat']) ? 1 : 0;
    $select_point = trim($_POST['select_point']);
    $min_point = (int)$_POST['min_point'];
    $max_point = (int)$_POST['max_point'];
    
    // 페이지 목록 개수 유효성 검사
    if ($list_count < 1) {
        alert('페이지 목록 개수는 1보다 작을 수 없습니다.');
    }
    
    if ($list_count > 100) {
        alert('페이지 목록 개수는 100보다 클 수 없습니다.');
    }
    // 최소값과 최대값 체크
    if ($min_point <= 0) {
        alert('최소 포인트는 0보다 커야 합니다.');
    }
    
    if ($max_point <= 0) {
        alert('최대 포인트는 0보다 커야 합니다.');
    }
    
    if ($min_point >= $max_point) {
        alert('최소 포인트는 최대 포인트보다 작아야 합니다.');
    }
    
    // 콤마로 구분된 값의 유효성 검사
    if ($select_point) {
        $point_values = explode(',', $select_point);
        foreach ($point_values as $value) {
            $value = trim($value);
            if (!is_numeric($value) || $value <= 0) {
                alert('선택 포인트는 콤마로 구분된 양수여야 합니다.');
            }
        }
    }
    
    // DB 업데이트
    $sql = " UPDATE g5_point_gift
                SET use_paging = '{$use_paging}',
                    list_count = '{$list_count}',
                    use_asta = '{$use_asta}',
                    use_count = '{$use_count}',
                    allow_repeat = '{$allow_repeat}',
                    select_point = '{$select_point}',
                    min_point = '{$min_point}',
                    max_point = '{$max_point}'
                WHERE bo_table = '{$bo_table}' ";
    sql_query($sql);
    
    // 설정 완료 후 알림창 표시를 위한 자바스크립트 추가
    echo '<script>
        alert("포인트 선물 설정이 저장되었습니다.");
        location.href = "'.G5_BBS_URL.'/board.php?bo_table='.$bo_table.'";
    </script>';
    exit;
}

?>

<div class="point_gift_admin">
    <h2><i class="fa fa-gift"></i> 포인트 선물 설정</h2>
    <form method="post" id="pointGiftForm">
        <div class="tbl_frm01 tbl_wrap">
            <table>
                <caption>포인트 선물 설정</caption>
                <colgroup>
                    <col class="grid_4">
                    <col>
                </colgroup>
                <tbody>
                    <tr>
                        <th scope="row"><label for="use_paging">페이징 사용</label></th>
                        <td>
                            <input type="checkbox" name="use_paging" id="use_paging" value="1" <?php echo $point_gift['use_paging'] ? 'checked' : ''; ?>>
                            <label for="use_paging">페이징 기능을 사용합니다.</label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="list_count">페이지 목록 개수</label></th>
                        <td>
                            <input type="number" name="list_count" id="list_count" value="<?php echo $point_gift['list_count']; ?>" class="frm_input" min="1" max="100">
                            <span class="frm_info">한 페이지에 표시할 게시물 개수를 입력합니다. (1~100)</span>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="use_asta">애스터리스크(*) 사용</label></th>
                        <td>
                            <input type="checkbox" name="use_asta" id="use_asta" value="1" <?php echo $point_gift['use_asta'] ? 'checked' : ''; ?>>
                            <label for="use_asta">포인트 표시에 애스터리스크(*)를 사용합니다.</label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="use_count">카운트 사용</label></th>
                        <td>
                            <input type="checkbox" name="use_count" id="use_count" value="1" <?php echo $point_gift['use_count'] ? 'checked' : ''; ?>>
                            <label for="use_count">포인트 선물 횟수를 표시합니다.</label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="allow_repeat">반복선물 허용</label></th>
                        <td>
                            <input type="checkbox" name="allow_repeat" id="allow_repeat" value="1" <?php echo $point_gift['allow_repeat'] ? 'checked' : ''; ?>>
                            <label for="allow_repeat">동일 게시물에 반복 선물을 허용합니다.</label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="select_point">선택 포인트</label></th>
                        <td>
                            <input type="text" name="select_point" id="select_point" value="<?php echo $point_gift['select_point']; ?>" class="frm_input">
                            <span class="frm_info">콤마(,)로 구분하여 입력합니다. <br>예: 1000,3000,5000,10000</span>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="min_point">최소 포인트</label></th>
                        <td>
                            <input type="number" name="min_point" id="min_point" value="<?php echo $point_gift['min_point']; ?>" class="frm_input" min="1">
                            <span class="frm_info">직접 입력 시 최소 포인트 값입니다.</span>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="max_point">최대 포인트</label></th>
                        <td>
                            <input type="number" name="max_point" id="max_point" value="<?php echo $point_gift['max_point']; ?>" class="frm_input" min="1">
                            <span class="frm_info">직접 입력 시 최대 포인트 값입니다.</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="btn_confirm01 btn_confirm">
            <input type="submit" name="point_gift_submit" value="설정 저장" class="btn_submit btn">
            <a href="javascript:void(0);" onclick="closeDrawer();" class="btn_cancel btn">취소</a>
        </div>
    </form>
</div>

<script>
jQuery(function($){
    $('.point_gift_admin').parent().css('padding', '20px');
    
    // 설정 변경 시 확인 메시지
    $('#pointGiftForm').on('submit', function() {
        return confirm('포인트 선물 설정을 저장하시겠습니까?');
    });
});

// 드로어 닫기 함수
function closeDrawer() {
    jQuery('.point_gift_drawer').removeClass('open');
    jQuery('.point_gift_overlay').removeClass('open');
    jQuery('body').css('overflow', '');
}
</script> 