<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// DB 테이블 및 초기 설정 확인
include_once($board_skin_path.'/point_gift_install.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/gift.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<!-- 게시물 읽기 시작 { -->

<article id="bo_v" style="width:<?php echo $width; ?>">
    <header>
        <h2 id="bo_v_title">
            <?php if ($category_name) { ?>
            <span class="bo_v_cate"><?php echo $view['ca_name']; // 분류 출력 끝 ?></span> 
            <?php } ?>
            <span class="bo_v_tit">
            <?php
            echo cut_str(get_text($view['wr_subject']), 70); // 글제목 출력
            ?></span>
        </h2>
    </header>

    <section id="bo_v_info">
        <h2>페이지 정보</h2>
        <div class="profile_info">
        	<div class="pf_img"><?php echo get_member_profile_img($view['mb_id']) ?></div>
        	<div class="profile_info_ct">
        		<span class="sound_only">작성자</span> <strong><?php echo $view['name'] ?><?php if ($is_ip_view) { echo "&nbsp;($ip)"; } ?></strong><br>
       		 	<span class="sound_only">댓글</span><strong><a href="#bo_vc"> <i class="fa fa-commenting-o" aria-hidden="true"></i> <?php echo number_format($view['wr_comment']) ?>건</a></strong>
        		<span class="sound_only">조회</span><strong><i class="fa fa-eye" aria-hidden="true"></i> <?php echo number_format($view['wr_hit']) ?>회</strong>
        		<strong class="if_date"><span class="sound_only">작성일</span><i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo date("y-m-d H:i", strtotime($view['wr_datetime'])) ?></strong>
    		</div>
    	</div>

    	<!-- 게시물 상단 버튼 시작 { -->
	    <div id="bo_v_top">
	        <?php ob_start(); ?>

	        <ul class="btn_bo_user bo_v_com">
				<li><a href="<?php echo $list_href ?>" class="btn_b01 btn" title="목록"><i class="fa fa-list" aria-hidden="true"></i><span class="sound_only">목록</span></a></li>
	            <?php if ($reply_href) { ?><li><a href="<?php echo $reply_href ?>" class="btn_b01 btn" title="답변"><i class="fa fa-reply" aria-hidden="true"></i><span class="sound_only">답변</span></a></li><?php } ?>
	            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b01 btn" title="글쓰기"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
	        	<?php if($update_href || $delete_href || $copy_href || $move_href || $search_href) { ?>
	        	<li>
	        		<button type="button" class="btn_more_opt is_view_btn btn_b01 btn"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트 옵션</span></button>
		        	<ul class="more_opt is_view_btn"> 
			            <?php if ($update_href) { ?><li><a href="<?php echo $update_href ?>">수정<i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></li><?php } ?>
			            <?php if ($delete_href) { ?><li><a href="<?php echo $delete_href ?>" onclick="del(this.href); return false;">삭제<i class="fa fa-trash-o" aria-hidden="true"></i></a></li><?php } ?>
			            <?php if ($copy_href) { ?><li><a href="<?php echo $copy_href ?>" onclick="board_move(this.href); return false;">복사<i class="fa fa-files-o" aria-hidden="true"></i></a></li><?php } ?>
			            <?php if ($move_href) { ?><li><a href="<?php echo $move_href ?>" onclick="board_move(this.href); return false;">이동<i class="fa fa-arrows" aria-hidden="true"></i></a></li><?php } ?>
			            <?php if ($search_href) { ?><li><a href="<?php echo $search_href ?>">검색<i class="fa fa-search" aria-hidden="true"></i></a></li><?php } ?>
			        </ul> 
	        	</li>
	        	<?php } ?>
	        </ul>
	        <script>

            jQuery(function($){
                // 게시판 보기 버튼 옵션
				$(".btn_more_opt.is_view_btn").on("click", function(e) {
                    e.stopPropagation();
				    $(".more_opt.is_view_btn").toggle();
				})
;
                $(document).on("click", function (e) {
                    if(!$(e.target).closest('.is_view_btn').length) {
                        $(".more_opt.is_view_btn").hide();
                    }
                });
            });
            </script>
	        <?php
	        $link_buttons = ob_get_contents();
	        ob_end_flush();
			?>
	    </div>
	    <!-- } 게시물 상단 버튼 끝 -->
    </section>

    <section id="bo_v_atc">
        <h2 id="bo_v_atc_title">본문</h2>
        <div id="bo_v_share">
        	<?php include_once(G5_SNS_PATH."/view.sns.skin.php"); ?>
	        <?php if ($scrap_href) { ?><a href="<?php echo $scrap_href;  ?>" target="_blank" class="btn btn_b03" onclick="win_scrap(this.href); return false;"><i class="fa fa-bookmark" aria-hidden="true"></i> 스크랩</a><?php } ?>
	    </div>

        <?php
        // 파일 출력
        $v_img_count = count($view['file']);
        if($v_img_count) {
            echo "<div id=\"bo_v_img\">\n";

            foreach($view['file'] as $view_file) {
                echo get_file_thumbnail($view_file);
            }

            echo "</div>\n";
        }
         ?>

        <!-- 본문 내용 시작 { -->
        <div id="bo_v_con"><?php echo get_view_thumbnail($view['content']); ?></div>
        <?php //echo $view['rich_content']; // {이미지:0} 과 같은 코드를 사용할 경우 ?>
        <!-- } 본문 내용 끝 -->

        <?php if ($is_signature) { ?><p><?php echo $signature ?></p><?php } ?>


        <!--  추천 비추천 시작 { -->
        <?php if ( $good_href || $nogood_href) { ?>
        <div id="bo_v_act">
            <?php if ($good_href) { ?>
            <span class="bo_v_act_gng">
                <a href="<?php echo $good_href.'&amp;'.$qstr ?>" id="good_button" class="bo_v_good"><i class="fa fa-thumbs-o-up" aria-hidden="true"></i><span class="sound_only">추천</span><strong><?php echo number_format($view['wr_good']) ?></strong></a>
                <b id="bo_v_act_good"></b>
            </span>
            <?php } ?>
            <?php if ($nogood_href) { ?>
            <span class="bo_v_act_gng">
                <a href="<?php echo $nogood_href.'&amp;'.$qstr ?>" id="nogood_button" class="bo_v_nogood"><i class="fa fa-thumbs-o-down" aria-hidden="true"></i><span class="sound_only">비추천</span><strong><?php echo number_format($view['wr_nogood']) ?></strong></a>
                <b id="bo_v_act_nogood"></b>
            </span>
            <?php } ?>
        </div>
        <?php } else {
            if($board['bo_use_good'] || $board['bo_use_nogood']) {
        ?>
        <div id="bo_v_act">
            <?php if($board['bo_use_good']) { ?><span class="bo_v_good"><i class="fa fa-thumbs-o-up" aria-hidden="true"></i><span class="sound_only">추천</span><strong><?php echo number_format($view['wr_good']) ?></strong></span><?php } ?>
            <?php if($board['bo_use_nogood']) { ?><span class="bo_v_nogood"><i class="fa fa-thumbs-o-down" aria-hidden="true"></i><span class="sound_only">비추천</span><strong><?php echo number_format($view['wr_nogood']) ?></strong></span><?php } ?>
        </div>
        <?php
            }
        }
        ?>
        <!-- }  추천 비추천 끝 -->
        <!-- 포인트 선물 기능 시작 { -->
        <?php 
        if ($is_member && $view['mb_id'] != $member['mb_id']) { 
            // 이미 선물했는지 확인
            $already_gifted = false;
            if(!$point_gift['allow_repeat']) {
                $sql = " select count(*) as cnt from {$g5['point_table']} 
                          where mb_id = '{$member['mb_id']}' 
                          and po_rel_table = '$bo_table' 
                          and po_rel_id = '$wr_id' 
                          and po_rel_action = 'gift' ";
                $gift_check = sql_fetch($sql);
                if($gift_check['cnt'] > 0) {
                    $already_gifted = true;
                }
            }
            
            // 반복 선물 허용이거나 아직 선물하지 않은 경우에만 선물창 표시
            if($point_gift['allow_repeat'] || !$already_gifted) {
        ?>
        <div id="bo_v_gift">
            <h2><i class="fa fa-gift"></i> 포인트 선물</h2>
            <div class="gift_area">
                <form name="fgift" id="fgift" method="post">
                    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                    <input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
                    <div class="gift_input">
                        <?php if($point_gift['select_point']) { ?>
                        <div class="gift_select">
                            <label for="select_point">선택 포인트</label>
                            <div class="point_buttons">
                                <?php
                                $point_values = explode(',', $point_gift['select_point']);
                                foreach($point_values as $pvalue) {
                                    $pvalue = trim($pvalue);
                                    if(!$pvalue) continue;
                                    echo '<button type="button" class="point_btn" data-point="'.$pvalue.'">'.number_format($pvalue).'</button>';
                                }
                                ?>
                            </div>
                        </div>
                        <?php } ?>
                        <div class="gift_manual">
                            <label for="point_amount">선물할 포인트</label>
                            <div class="point_manual_input">
                                <input type="number" name="point_amount" id="point_amount" required class="frm_input required" min="<?php echo $point_gift['min_point']; ?>" max="<?php echo min($point_gift['max_point'], $member['mb_point']); ?>" placeholder="<?php echo number_format($point_gift['min_point']); ?> ~ <?php echo number_format(min($point_gift['max_point'], $member['mb_point'])); ?>">
                                <button type="button" id="btn_gift_submit" class="btn_submit">선물하기</button>
                            </div>
                        </div>
                        <div class="gift_info">
                            <span id="user_point">* 현재 보유 포인트: <?php echo number_format($member['mb_point']); ?> 점</span>
                            <span>* 최소 <?php echo number_format($point_gift['min_point']); ?>점 ~ 최대 <?php echo number_format($point_gift['max_point']); ?>점까지 선물 가능</span>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <script>
        jQuery(function($) {
            // 선택 포인트 버튼 클릭
            $(".point_btn").on("click", function() {
                var point = $(this).data("point");
                $("#point_amount").val(point);
            });
            
            // 포인트 선물 버튼 클릭 시
            $("#btn_gift_submit").on("click", function() {
                var f = document.getElementById("fgift");
                var point_amount = f.point_amount.value;
                var min_point = <?php echo $point_gift['min_point']; ?>;
                var max_point = <?php echo min($point_gift['max_point'], $member['mb_point']); ?>;
                
                if (point_amount <= 0) {
                    alert("선물할 포인트를 입력해주세요.");
                    f.point_amount.focus();
                    return false;
                }
                
                if (point_amount < min_point) {
                    alert("최소 " + min_point + "포인트 이상 선물해야 합니다.");
                    f.point_amount.focus();
                    return false;
                }
                
                if (point_amount > max_point) {
                    alert("최대 " + max_point + "포인트까지 선물할 수 있습니다.");
                    f.point_amount.focus();
                    return false;
                }
                
                if (!confirm("정말 " + point_amount + "포인트를 선물하시겠습니까?")) {
                    return false;
                }
                
                // AJAX 요청
                $.ajax({
                    url: "<?php echo G5_BBS_URL ?>/ajax.point_gift.php",
                    type: "POST",
                    data: $("#fgift").serialize(),
                    dataType: "json",
                    success: function(data) {
                        if (data.error) {
                            alert(data.error);
                            return false;
                        }
                        
                        // 성공 메시지 출력
                        alert(data.message);
                        
                        // 선물 내역 업데이트 (페이지 새로고침)
                        location.reload();
                    },
                    error: function(xhr, status, error) {
                        alert("오류가 발생했습니다. 다시 시도해주세요.");
                    }
                });
            });
        });
        </script>
        <?php 
            } 
        } 
        ?>
        <!-- } 포인트 선물 기능 끝 -->
        
        <!-- 포인트 선물 내역 시작 { -->
        <?php
        // 페이징 처리
        $page = isset($_GET['gift_page']) ? intval($_GET['gift_page']) : 1;
        $list_count = isset($point_gift['list_count']) ? $point_gift['list_count'] : 10;
        
        $sql_common = " from {$g5['point_table']} a
                        left join {$g5['member_table']} b on a.mb_id = b.mb_id
                        where a.po_rel_table = '$bo_table'
                          and a.po_rel_id = '$wr_id'
                          and a.po_rel_action like '%gift%' 
                          and a.po_point < 0 ";
                          
        $sql = " select count(*) as cnt $sql_common ";
        $row = sql_fetch($sql);
        $total_count = $row['cnt'];
        
        $total_page = ceil($total_count / $list_count);
        if ($page < 1) $page = 1;
        if ($page > $total_page) $page = $total_page;
        
        $start = ($page - 1) * $list_count;
        
        // 포인트 선물 내역 가져오기
        $sql = " select a.po_id, a.mb_id, a.po_datetime, a.po_content, a.po_point, b.mb_nick
                $sql_common
                order by a.po_id desc
                limit $start, $list_count ";
        $gift_result = sql_query($sql);
        $gift_count = 0;
        
        if ($gift_result) {
            $gift_count = sql_num_rows($gift_result);
        }
        
        if ($gift_count > 0) {
        ?>
        <div id="bo_v_gift_list">
            <h2><i class="fa fa-list"></i> 포인트 선물 내역 <?php if($point_gift['use_count']) { ?>(총 <?php echo $total_count; ?>건)<?php } ?></h2>
            <ul>
            <?php 
            for ($i=0; $row=sql_fetch_array($gift_result); $i++) { 
                // 선물한 포인트 표시를 위한 처리
                $point_display = abs($row['po_point']);
                $nick_display = $row['mb_nick'];
                // 아스터리스크(*) 사용 여부 확인
                if($point_gift['use_asta']) {
                    // 관리자이거나 글쓴이면 모든 정보 표시
                    if($is_admin || $view['mb_id'] == $member['mb_id']) {
                        $point_display = number_format($point_display);
                    }
                    // 선물한 본인이면 본인 정보만 표시
                    else if($member['mb_id'] && $member['mb_id'] == $row['mb_id']) {
                        $point_display = number_format($point_display);
                    }
                    // 그 외에는 별표(*)로 표시
                    else {
                        $point_length = strlen(number_format($point_display));
                        $point_display = str_repeat('*', $point_length);
                        
                        // 닉네임도 별표(*) 처리
                        $nick_length = mb_strlen($nick_display, 'UTF-8');
                        $nick_display = str_repeat('*', $nick_length);
                    }
                } else {
                    $point_display = number_format($point_display);
                }
            ?>
                <li>
                    <span class="gift_nick"><?php echo $nick_display; ?></span>님이 
                    <span class="gift_point"><?php echo $point_display; ?></span>포인트를 선물하였습니다.
                    <span class="gift_datetime">(<?php echo substr($row['po_datetime'], 2, 14); ?>)</span>
                </li>
            <?php } ?>
            </ul>
            
            <?php if($point_gift['use_paging'] && $total_page > 1) { ?>
            <div class="gift_pg_wrap">
                <ul class="gift_pg">
                    <?php
                    $start_page = (floor(($page - 1) / 10) * 10) + 1;
                    $end_page = $start_page + 9;
                    if ($end_page > $total_page) $end_page = $total_page;
                    
                    // 이전 페이지
                    if ($start_page > 1) {
                        echo '<li><a href="javascript:void(0);" onclick="loadGiftPage('.($start_page-1).')" class="pg_page pg_prev" style="height:auto; line-height:1"><i class="fa fa-chevron-left"></i></a></li>';
                    }
                    
                    // 페이지 번호
                    for ($i=$start_page; $i<=$end_page; $i++) {
                        if ($i == $page) {
                            echo '<li><a href="javascript:void(0);" onclick="loadGiftPage('.$i.')" class="pg_page pg_current" style="height:auto; line-height:1">'.$i.'</a></li>';
                        } else {
                            echo '<li><a href="javascript:void(0);" onclick="loadGiftPage('.$i.')" class="pg_page" style="height:auto; line-height:1">'.$i.'</a></li>';
                        }
                    }
                    
                    // 다음 페이지
                    if ($end_page < $total_page) {
                        echo '<li><a href="javascript:void(0);" onclick="loadGiftPage('.($end_page+1).')" class="pg_page pg_next" style="height:auto; line-height:1"><i class="fa fa-chevron-right"></i></a></li>';
                    }
                    ?>
                </ul>
                
                <script>
                function loadGiftPage(page) {
                    $.ajax({
                        url: g5_bbs_url + '/board.php?bo_table=<?php echo $bo_table; ?>&wr_id=<?php echo $wr_id; ?>&gift_page=' + page,
                        type: 'POST',
                        dataType: 'html',
                        success: function(data) {
                            if(data.error) {
                                alert(data.error);
                                return;
                            }
                            
                            var $responseData = $(data);
                            var giftListHtml = $responseData.find('#bo_v_gift_list').html();
                            $('#bo_v_gift_list').html(giftListHtml);
                        }
                    })
                }
                </script>
            </div>
            </div>
            <?php } ?>
        <?php } ?>
        <!-- } 포인트 선물 내역 끝 -->
    </section>

    <?php
    $cnt = 0;
    if ($view['file']['count']) {
        for ($i=0; $i<count($view['file']); $i++) {
            if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view'])
                $cnt++;
        }
    }
	?>

    <?php if($cnt) { ?>
    <!-- 첨부파일 시작 { -->
    <section id="bo_v_file">
        <h2>첨부파일</h2>
        <ul>
        <?php
        // 가변 파일
        for ($i=0; $i<count($view['file']); $i++) {
            if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
         ?>
            <li>
               	<i class="fa fa-folder-open" aria-hidden="true"></i>
                <a href="<?php echo $view['file'][$i]['href'];  ?>" class="view_file_download">
                    <strong><?php echo $view['file'][$i]['source'] ?></strong> <?php echo $view['file'][$i]['content'] ?> (<?php echo $view['file'][$i]['size'] ?>)
                </a>
                <br>
                <span class="bo_v_file_cnt"><?php echo $view['file'][$i]['download'] ?>회 다운로드 | DATE : <?php echo $view['file'][$i]['datetime'] ?></span>
            </li>
        <?php
            }
        }
         ?>
        </ul>
    </section>
    <!-- } 첨부파일 끝 -->
    <?php } ?>

    <?php if(isset($view['link']) && array_filter($view['link'])) { ?>
    <!-- 관련링크 시작 { -->
    <section id="bo_v_link">
        <h2>관련링크</h2>
        <ul>
        <?php
        // 링크
        $cnt = 0;
        for ($i=1; $i<=count($view['link']); $i++) {
            if ($view['link'][$i]) {
                $cnt++;
                $link = cut_str($view['link'][$i], 70);
            ?>
            <li>
                <i class="fa fa-link" aria-hidden="true"></i>
                <a href="<?php echo $view['link_href'][$i] ?>" target="_blank">
                    <strong><?php echo $link ?></strong>
                </a>
                <br>
                <span class="bo_v_link_cnt"><?php echo $view['link_hit'][$i] ?>회 연결</span>
            </li>
            <?php
            }
        }
        ?>
        </ul>
    </section>
    <!-- } 관련링크 끝 -->
    <?php } ?>
    
    <?php if ($prev_href || $next_href) { ?>
    <ul class="bo_v_nb">
        <?php if ($prev_href) { ?><li class="btn_prv"><span class="nb_tit"><i class="fa fa-chevron-up" aria-hidden="true"></i> 이전글</span><a href="<?php echo $prev_href ?>"><?php echo $prev_wr_subject;?></a> <span class="nb_date"><?php echo str_replace('-', '.', substr($prev_wr_date, '2', '8')); ?></span></li><?php } ?>
        <?php if ($next_href) { ?><li class="btn_next"><span class="nb_tit"><i class="fa fa-chevron-down" aria-hidden="true"></i> 다음글</span><a href="<?php echo $next_href ?>"><?php echo $next_wr_subject;?></a>  <span class="nb_date"><?php echo str_replace('-', '.', substr($next_wr_date, '2', '8')); ?></span></li><?php } ?>
    </ul>
    <?php } ?>

    <?php
    // 코멘트 입출력
    include_once(G5_BBS_PATH.'/view_comment.php');
	?>
</article>
<!-- } 게시판 읽기 끝 -->

<script>
<?php if ($board['bo_download_point'] < 0) { ?>
$(function() {
    $("a.view_file_download").click(function() {
        if(!g5_is_member) {
            alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
            return false;
        }

        var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

        if(confirm(msg)) {
            var href = $(this).attr("href")+"&js=on";
            $(this).attr("href", href);

            return true;
        } else {
            return false;
        }
    });
});
<?php } ?>

function board_move(href)
{
    window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>

<script>
$(function() {
    $("a.view_image").click(function() {
        window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
        return false;
    });

    // 추천, 비추천
    $("#good_button, #nogood_button").click(function() {
        var $tx;
        if(this.id == "good_button")
            $tx = $("#bo_v_act_good");
        else
            $tx = $("#bo_v_act_nogood");

        excute_good(this.href, $(this), $tx);
        return false;
    });

    // 이미지 리사이즈
    $("#bo_v_atc").viewimageresize();
});

function excute_good(href, $el, $tx)
{
    $.post(
        href,
        { js: "on" },
        function(data) {
            if(data.error) {
                alert(data.error);
                return false;
            }

            if(data.count) {
                $el.find("strong").text(number_format(String(data.count)));
                if($tx.attr("id").search("nogood") > -1) {
                    $tx.text("이 글을 비추천하셨습니다.");
                    $tx.fadeIn(200).delay(2500).fadeOut(200);
                } else {
                    $tx.text("이 글을 추천하셨습니다.");
                    $tx.fadeIn(200).delay(2500).fadeOut(200);
                }
            }
        }, "json"
    );
}
</script>
<!-- } 게시글 읽기 끝 -->