<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

$g5['g5_point_gift_moa'] = G5_TABLE_PREFIX.'point_gift_moa';

// 포인트 선물 테이블 생성
$sql = " CREATE TABLE IF NOT EXISTS {$g5['g5_point_gift_moa']} (
    pg_id int(11) NOT NULL AUTO_INCREMENT,
    pg_datetime datetime NOT NULL DEFAULT current_timestamp(),
    pg_sender_mb_id varchar(20) NOT NULL COMMENT '포인트 선물한 회원 아이디',
    pg_receiver_mb_id varchar(20) NOT NULL COMMENT '포인트 받은 회원 아이디',
    pg_point int(11) NOT NULL DEFAULT 0 COMMENT '선물한 포인트',
    pg_content text NULL COMMENT '메시지',
    pg_wr_id int(11) NOT NULL DEFAULT 0 COMMENT '관련 게시글 번호',
    pg_bo_table varchar(20) NOT NULL COMMENT '관련 게시판',
    PRIMARY KEY (pg_id),
    KEY sender_idx (pg_sender_mb_id),
    KEY receiver_idx (pg_receiver_mb_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
sql_query($sql, false);

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<!-- 포인트 선물 모달 스타일 -->
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@400;500;700&display=swap">
<style>
/* 포인트 선물 모달 스타일 */
.gift-point-modal {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.5);
  z-index: 9999;
  align-items: center;
  justify-content: center;
}

.gift-point-modal.active {
  display: flex;
}

.gift-point-container {
  max-width: 500px;
  width: 90%;
  padding: 20px;
  font-family: 'Noto Sans KR', sans-serif;
  border-radius: 10px;
  box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
  background-color: #fff;
  animation: fadeIn 0.5s ease-out;
}

/* 타이틀 스타일 */
.gift-point-title {
  background: linear-gradient(135deg, #ff3b30, #c70039);
  padding: 15px 20px;
  margin: 10px 0 20px 0;
  border-radius: 8px;
  font-size: 20px;
  font-weight: bold;
  color: white;
  text-align: center;
  box-shadow: 0 4px 6px rgba(199, 0, 57, 0.2);
  position: relative;
}

.gift-point-title:before {
  content: "🎁";
  margin-right: 10px;
  font-size: 22px;
}

/* 안내 섹션 */
.gift-point-desc {
  background: #f9f2f2;
  border-left: 4px solid #c70039;
  padding: 15px 20px;
  margin: 15px 0;
  border-radius: 4px;
  line-height: 1.6em;
}

.gift-point-desc p {
  padding: 0;
  line-height: 1.8em;
  font-size: 15px;
  color: #333;
}

/* 폼 스타일 */
.gift-point-form ul {
  padding: 0;
  margin: 25px 0;
}

.gift-point-form li {
  margin-bottom: 20px !important;
  list-style-type: none;
}

.gift-point-input {
  width: 100%;
  padding: 12px 15px;
  border: 1px solid #ddd;
  border-radius: 6px;
  font-size: 15px;
  transition: all 0.3s ease;
  box-sizing: border-box;
}

.gift-point-input:focus {
  border-color: #ff3b30;
  box-shadow: 0 0 0 2px rgba(255, 59, 48, 0.2);
  outline: none;
}

.gift-point-input::placeholder {
  color: #aaa;
}

/* 버튼 스타일 */
.gift-point-btn-wrap {
  display: flex;
  justify-content: center;
  gap: 10px;
  margin-top: 20px;
}

.gift-point-submit {
  background: linear-gradient(to right, #ff3b30, #c70039);
  color: white;
  border: none;
  padding: 12px 25px;
  border-radius: 6px;
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
  transition: all 0.3s ease;
  box-shadow: 0 4px 6px rgba(199, 0, 57, 0.2);
}

.gift-point-submit:hover {
  background: linear-gradient(to right, #d9302a, #a80030);
  transform: translateY(-2px);
  box-shadow: 0 6px 8px rgba(199, 0, 57, 0.3);
}

.gift-point-close {
  background: #f2f2f2;
  color: #555;
  border: 1px solid #ddd;
  padding: 12px 25px;
  border-radius: 6px;
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
  transition: all 0.3s ease;
}

.gift-point-close:hover {
  background: #e6e6e6;
}

/* 입력 라벨 */
.gift-point-label {
  display: block;
  margin-bottom: 8px;
  font-size: 14px;
  color: #333;
  font-weight: bold;
}

/* 애니메이션 효과 */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* 반응형 조정 */
@media (max-width: 480px) {
  .gift-point-container {
    padding: 15px;
  }
  
  .gift-point-submit, .gift-point-close {
    padding: 10px 20px;
    font-size: 15px;
  }
}

/* 선물 버튼 추가 */
.gift-point-btn {
  display: inline-block;
  padding: 6px 12px;
  background: linear-gradient(to right, #ff3b30, #c70039);
  color: white;
  border-radius: 4px;
  font-size: 12px;
  margin-left: 10px;
  cursor: pointer;
  transition: all 0.3s ease;
}

.gift-point-btn:hover {
  background: linear-gradient(to right, #d9302a, #a80030);
  transform: translateY(-2px);
}

/* 포인트 선물 내역 스타일 */
.gift-point-history {
  margin-top: 30px;
  border-top: 1px solid #eee;
  padding-top: 20px;
}

.gift-point-history h3 {
  font-size: 18px;
  margin: 0 0 15px 0;
  color: #333;
  font-weight: bold;
}

.gift-point-history-table {
  width: 100%;
  border-collapse: collapse;
}

.gift-point-history-table th,
.gift-point-history-table td {
  padding: 12px 8px;
  text-align: center;
  border-bottom: 1px solid #eee;
}

.gift-point-history-table th {
  background: #f7f7f7;
  font-size: 14px;
  color: #555;
}

.gift-point-history-table td {
  font-size: 14px;
}

.gift-point-sender {
  font-weight: bold;
  color: #c70039;
}

.gift-point-amount {
  font-weight: bold;
  color: #ff3b30;
}

.gift-point-date {
  color: #888;
  font-size: 13px;
}

.gift-point-paginate {
  margin-top: 15px;
  text-align: center;
}

.gift-point-paginate a {
  display: inline-block;
  padding: 5px 10px;
  margin: 0 2px;
  border: 1px solid #ddd;
  border-radius: 3px;
  font-size: 13px;
  color: #555;
}

.gift-point-paginate a.active {
  background: #ff3b30;
  color: #fff;
  border-color: #ff3b30;
}

.gift-point-no-data {
  text-align: center;
  padding: 30px 0;
  color: #888;
}

.gift-point-textarea {
  width: 100%;
  min-height: 80px;
  padding: 12px 15px;
  border: 1px solid #ddd;
  border-radius: 6px;
  font-size: 15px;
  margin-bottom: 10px;
  transition: all 0.3s ease;
  box-sizing: border-box;
  resize: vertical;
  font-family: 'Noto Sans KR', sans-serif;
}

.gift-point-textarea:focus {
  border-color: #ff3b30;
  box-shadow: 0 0 0 2px rgba(255, 59, 48, 0.2);
  outline: none;
}
</style>

<!-- 게시물 읽기 시작 { -->

<!-- 게시물 상단 버튼 시작 { -->
<div class="board-btn bo-v-btn-wrap">
	<div class="bo-v-btn-left">
		<?php if ($update_href) { ?><a href="<?php echo $update_href ?>" class="btn-bo-modify">수정</a><?php } ?>
		<?php if ($delete_href) { ?><a href="<?php echo $delete_href ?>" class="btn-bo-delete" onclick="del(this.href); return false;">삭제</a><?php } ?>
		<?php if ($copy_href) { ?><a href="<?php echo $copy_href ?>" class="btn-bo-copy" onclick="board_move(this.href); return false;">복사</a><?php } ?>
		<?php if ($move_href) { ?><a href="<?php echo $move_href ?>" class="btn-bo-move" onclick="board_move(this.href); return false;">이동</a><?php } ?>
	</div>
	<div class="bo-v-btn-right">
		<?php if ($search_href) { ?><a href="<?php echo $search_href ?>" class="btn-bo-search">검색목록</a><?php } ?>
		<a href="<?php echo $list_href ?>" class="btn-bo-list" title="목록">목록</a>
		<?php if ($reply_href) { ?><a href="<?php echo $reply_href ?>" class="btn-bo-reply" title="답변">답변</a><?php } ?>
		<?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="btn-bo-write" title="글쓰기">글쓰기</a><?php } ?>
	</div>
</div>
<!-- } 게시물 상단 버튼 끝 -->

<article id="bo_v" style="width:<?php echo $width; ?>">
	<header>
		<h2 id="bo-v-title">
			<span class="bo-v-tit">
				<?php if ($category_name) { ?>
				<span class="bo-v-cate">[<?php echo $view['ca_name']; // 분류 출력 끝 ?>]</span> 
				<?php } ?>
				<?php echo get_text($view['wr_subject']); // 글제목 출력?>
			</span>
		</h2>
	</header>
    <section id="bo-v-info">
        <h2>페이지 정보</h2>
        <div class="profile-info">
			<?php if($board['bo_use_sideview']){?>
        	<span class="pf-img"><?php echo get_member_profile_img($view['mb_id']) ?></span>
			<?php }?>
			<strong>
                <span class="sound_only">작성자</span><?php echo $view['name'] ?>
                <?php if ($is_ip_view) { echo "<span class=\"article-ip\">[{$ip}]</span>"; } ?>
                
                
                <span class="gift-point-btn" id="openGiftPoint">포인트 선물</span>
                
                
            </strong>
    	</div>
		<div class="article-info">
			<strong class="article-comment"><span class="sound_only">댓글</span><a href="#bo_vc"><?php echo number_format($view['wr_comment']) ?>건</a></strong>
			<strong class="article-hit"><span class="sound_only">조회</span><?php echo number_format($view['wr_hit']) ?>회</strong>
			<strong class="article-date"><span class="sound_only">작성일</span><?php echo str_replace("-", ".", date("y-m-d H:i", strtotime($view['wr_datetime'])));?></strong>
		</div>
	</section>

    <section id="bo_v_atc">
        <h2 id="bo_v_atc_title">본문</h2>
		
		
		    <?php
    $cnt = 0;
    if ($view['file']['count']) {
        for ($i=0; $i<count($view['file']); $i++) {
            if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view'])
                $cnt++;
        }
    }
	?>

    <?php if($cnt) { ?>
    <!-- 첨부파일 시작 { -->
    <section id="bo_v_file">
        <h2>첨부파일</h2>
        <ul>
        <?php
        // 가변 파일
        for ($i=0; $i<count($view['file']); $i++) {
            if (isset($view['file'][$i]['source']) && $view['file'][$i]['source'] && !$view['file'][$i]['view']) {
         ?>
            <li>
                <a href="<?php echo $view['file'][$i]['href'];  ?>" class="view_file_download">
                    <strong><?php echo $view['file'][$i]['source'] ?></strong> <?php echo $view['file'][$i]['content'] ?> (<?php echo $view['file'][$i]['size'] ?>)
                </a>
                <span class="bo_v_file_cnt"><?php echo $view['file'][$i]['download'] ?>회 다운로드 | DATE : <?php echo $view['file'][$i]['datetime'] ?></span>
            </li>
        <?php
            }
        }
         ?>
        </ul>
    </section>
    <!-- } 첨부파일 끝 -->
    <?php } ?>

    <?php if(isset($view['link']) && array_filter($view['link'])) { ?>
    <!-- 관련링크 시작 { -->
    <section id="bo_v_link">
        <h2>관련링크</h2>
        <ul>
        <?php
        // 링크
        $cnt = 0;
        for ($i=1; $i<=count($view['link']); $i++) {
            if ($view['link'][$i]) {
                $cnt++;
                $link = cut_str($view['link'][$i], 70);
            ?>
            <li>
                <a href="<?php echo $view['link_href'][$i] ?>" target="_blank">
                    <strong><?php echo $link ?></strong>
                </a>
                <span class="bo_v_link_cnt"><?php echo $view['link_hit'][$i] ?>회 연결</span>
            </li>
            <?php
            }
        }
        ?>
        </ul>
    </section>
    <!-- } 관련링크 끝 -->
    <?php } ?>
		
        <div id="bo_v_share">
			<div class="board-btn">
				<?php if ($scrap_href) { ?><a href="<?php echo $scrap_href;  ?>" target="_blank" class="scrap-btn" onclick="win_scrap(this.href); return false;">스크랩</a><?php } ?>
				<a href="#" class="share-btn">공유</a>
			</div>
        	<?php include_once(G5_SNS_PATH."/view.sns.skin.php"); ?>
	    </div>

		<script>
		$(function(){
			$(".share-btn").click(function(e){
				e.stopPropagation();
				if(!$(this).hasClass('active'))
				{
					$(this).addClass('active');
					$("#bo_v_sns").addClass('active');
				}
				else
				{
					$(this).removeClass('active');
					$("#bo_v_sns").removeClass('active');
				}
				return false;
			});
			$(document).on("click", function (e) {
				if(!$(e.target).closest('#bo_v_sns.active').length) {
					$(".share-btn").removeClass('active');
					$("#bo_v_sns").removeClass('active');
				}
			});
		});
		</script>

        <?php
        // 파일 출력
        $v_img_count = count($view['file']);
        if($v_img_count) {
            echo "<div id=\"bo_v_img\">\n";

            foreach($view['file'] as $view_file) {
                echo get_file_thumbnail($view_file);
            }

            echo "</div>\n";
        }
         ?>

        <!-- 본문 내용 시작 { -->
        <div id="bo_v_con"><?php echo get_view_thumbnail($view['content']); ?></div>
        <?php //echo $view['rich_content']; // {이미지:0} 과 같은 코드를 사용할 경우 ?>
        <!-- } 본문 내용 끝 -->

        <?php if ($is_signature) { ?><p><?php echo $signature ?></p><?php } ?>


        <!--  추천 비추천 시작 { -->
        <?php if ( $good_href || $nogood_href) { ?>
        <div id="bo_v_act">
            <?php if ($good_href) { ?>
            <span class="bo_v_act_gng">
                <a href="<?php echo $good_href.'&amp;'.$qstr ?>" id="good_button" class="bo_v_good"><span class="sound_only">추천</span><strong><?php echo number_format($view['wr_good']) ?></strong></a><b id="bo_v_act_good"></b>
            </span>
            <?php } ?>
            <?php if ($nogood_href) { ?>
            <span class="bo_v_act_gng">
                <a href="<?php echo $nogood_href.'&amp;'.$qstr ?>" id="nogood_button" class="bo_v_nogood"><span class="sound_only">비추천</span><strong><?php echo number_format($view['wr_nogood']) ?></strong></a><b id="bo_v_act_nogood"></b>
            </span>
            <?php } ?>
        </div>
        <?php } else {
            if($board['bo_use_good'] || $board['bo_use_nogood']) {
        ?>
        <div id="bo_v_act">
            <?php if($board['bo_use_good']) { ?><span class="bo_v_good"><span class="sound_only">추천</span><strong><?php echo number_format($view['wr_good']) ?></strong></span><?php } ?>
            <?php if($board['bo_use_nogood']) { ?><span class="bo_v_nogood"><span class="sound_only">비추천</span><strong><?php echo number_format($view['wr_nogood']) ?></strong></span><?php } ?>
        </div>
        <?php
            }
        }
        ?>
        <!-- }  추천 비추천 끝 -->
        
        <?php 
        // 포인트 선물 내역 표시
        if(isset($g5['g5_point_gift_moa'])) {
            // 페이징 처리
            $gifts_per_page = 5;
            $gifts_page = isset($_GET['gifts_page']) ? intval($_GET['gifts_page']) : 1;
            $gifts_start = ($gifts_page - 1) * $gifts_per_page;
            
            // 총 선물 내역 수
            $sql = " select count(*) as cnt 
                     from {$g5['g5_point_gift_moa']} 
                     where pg_receiver_mb_id = '{$view['mb_id']}' 
                     and pg_bo_table = '{$bo_table}' 
                     and pg_wr_id = '{$wr_id}' ";
            $row = sql_fetch($sql);
            $total_gifts = $row['cnt'];
            
            if($total_gifts > 0) {
                $total_pages = ceil($total_gifts / $gifts_per_page);
                
                // 현재 페이지의 선물 내역 가져오기
                $sql = " select a.*, b.mb_nick as sender_nick
                         from {$g5['g5_point_gift_moa']} a
                         left join {$g5['member_table']} b on a.pg_sender_mb_id = b.mb_id 
                         where a.pg_receiver_mb_id = '{$view['mb_id']}' 
                         and a.pg_bo_table = '{$bo_table}' 
                         and a.pg_wr_id = '{$wr_id}' 
                         order by a.pg_datetime desc
                         limit {$gifts_start}, {$gifts_per_page} ";
                $result = sql_query($sql);
                
                echo '
                <div class="gift-point-history">
                    <h3>포인트 선물 내역</h3>
                    <table class="gift-point-history-table">
                        <thead>
                            <tr>
                                <th>선물한 분</th>
                                <th>포인트</th>
                                <th>메시지</th>
                                <th>날짜</th>
                            </tr>
                        </thead>
                        <tbody>';
                
                for($i=0; $row=sql_fetch_array($result); $i++) {
                    echo '
                        <tr>
                            <td class="gift-point-sender">'.$row['sender_nick'].'</td>
                            <td class="gift-point-amount">'.number_format($row['pg_point']).' P</td>
                            <td>'.($row['pg_content'] ? $row['pg_content'] : '-').'</td>
                            <td class="gift-point-date">'.date('y.m.d H:i', strtotime($row['pg_datetime'])).'</td>
                        </tr>';
                }
                
                echo '
                        </tbody>
                    </table>';
                
                // 페이징 링크 생성
                if($total_pages > 1) {
                    echo '<div class="gift-point-paginate">';
                    
                    // 현재 URL에서 gifts_page 파라미터만 변경
                    $current_url = preg_replace('/&?gifts_page=[0-9]*/', '', $_SERVER['REQUEST_URI']);
                    $join_char = (strpos($current_url, '?') !== false) ? '&' : '?';
                    
                    // 이전 페이지
                    if($gifts_page > 1) {
                        echo '<a href="'.$current_url.$join_char.'gifts_page='.($gifts_page-1).'">이전</a>';
                    }
                    
                    // 페이지 번호
                    $start_page = max(1, $gifts_page - 2);
                    $end_page = min($total_pages, $gifts_page + 2);
                    
                    for($i=$start_page; $i<=$end_page; $i++) {
                        $active = ($i == $gifts_page) ? 'active' : '';
                        echo '<a href="'.$current_url.$join_char.'gifts_page='.$i.'" class="'.$active.'">'.$i.'</a>';
                    }
                    
                    // 다음 페이지
                    if($gifts_page < $total_pages) {
                        echo '<a href="'.$current_url.$join_char.'gifts_page='.($gifts_page+1).'">다음</a>';
                    }
                    
                    echo '</div>';
                }
                
                echo '</div>';
            }
        }
        ?>
    </section>


    
    <?php if ($prev_href || $next_href) { ?>
    <ul class="bo_v_nb">
        <?php if ($prev_href) { ?><li class="btn_prv"><span class="nb_tit"><i class="fa fa-chevron-up" aria-hidden="true"></i> 이전글</span><a href="<?php echo $prev_href ?>"><?php echo $prev_wr_subject;?></a> <span class="nb_date"><?php echo str_replace('-', '.', substr($prev_wr_date, '2', '8')); ?></span></li><?php } ?>
        <?php if ($next_href) { ?><li class="btn_next"><span class="nb_tit"><i class="fa fa-chevron-down" aria-hidden="true"></i> 다음글</span><a href="<?php echo $next_href ?>"><?php echo $next_wr_subject;?></a>  <span class="nb_date"><?php echo str_replace('-', '.', substr($next_wr_date, '2', '8')); ?></span></li><?php } ?>
    </ul>
    <?php } ?>

    <?php
    // 코멘트 입출력
    include_once(G5_BBS_PATH.'/view_comment.php');
	?>
</article>
<!-- } 게시판 읽기 끝 -->

<!-- 포인트 선물 모달 시작 -->
<div id="giftPointModal" class="gift-point-modal">
    <div class="gift-point-container">
        <div class="gift-point-title">포인트 선물하기</div>
        <div class="gift-point-desc">
            <p>최소 선물 포인트: 100 포인트</p>
            <p>최대 선물 포인트: 1,000,000 포인트</p>
            <p>내 보유 포인트: <?php echo number_format($member['mb_point']); ?> 포인트</p>
        </div>
        <div class="gift-point-form-container">
            <form name="fgiftform" id="fgiftform" action="<?php echo G5_HTTPS_BBS_URL; ?>/point_gift_update_moa.php" method="post" autocomplete="off">
                <input type="hidden" name="me_recv_mb_id" value="<?php echo $view['mb_id']; ?>">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
                <input type="hidden" name="wr_id" value="<?php echo $wr_id; ?>">
                <div class="gift-point-form">
                    <ul>
                        <li>
                            <label for="point" class="gift-point-label">선물할 포인트</label>
                            <input type="text" name="point" id="point" required class="gift-point-input" placeholder="선물할 포인트 금액을 입력하세요">
                        </li>
                        <li>
                            <label for="content" class="gift-point-label">메시지 (선택사항)</label>
                            <textarea name="content" id="content" class="gift-point-textarea" placeholder="선물과 함께 보낼 메시지를 입력하세요"></textarea>
                        </li>
                    </ul>
                </div>
                <div class="gift-point-btn-wrap">
                    <button type="submit" class="gift-point-submit">선물하기</button>
                    <button type="button" class="gift-point-close" id="closeGiftPoint">취소</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- 포인트 선물 모달 끝 -->

<script>
<?php if ($board['bo_download_point'] < 0) { ?>
$(function() {
    $("a.view_file_download").click(function() {
        if(!g5_is_member) {
            alert("다운로드 권한이 없습니다.\n회원이시라면 로그인 후 이용해 보십시오.");
            return false;
        }

        var msg = "파일을 다운로드 하시면 포인트가 차감(<?php echo number_format($board['bo_download_point']) ?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?";

        if(confirm(msg)) {
            var href = $(this).attr("href")+"&js=on";
            $(this).attr("href", href);

            return true;
        } else {
            return false;
        }
    });
});
<?php } ?>

function board_move(href)
{
    window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>

<script>
$(function() {
    $("a.view_image").click(function() {
        window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
        return false;
    });

    // 추천, 비추천
    $("#good_button, #nogood_button").click(function() {
        var $tx;
        if(this.id == "good_button")
            $tx = $("#bo_v_act_good");
        else
            $tx = $("#bo_v_act_nogood");

        excute_good(this.href, $(this), $tx);
        return false;
    });

    // 이미지 리사이즈
    $("#bo_v_atc").viewimageresize();
    
    // 포인트 선물 모달 열기
    $("#openGiftPoint").click(function() {
        $("#giftPointModal").addClass("active");
    });
    
    // 포인트 선물 모달 닫기
    $("#closeGiftPoint").click(function() {
        $("#giftPointModal").removeClass("active");
    });
    
    // 모달 외부 클릭 시 닫기
    $(document).on("click", function(e) {
        if($(e.target).hasClass("gift-point-modal")) {
            $("#giftPointModal").removeClass("active");
        }
    });
    
    // 포인트 선물 폼 제출
    $("#fgiftform").submit(function(e) {
        var point = parseInt($("#point").val().replace(/[^0-9]/g, ""));
        
        if (isNaN(point) || point < 100) {
            alert("최소 100 포인트 이상 선물할 수 있습니다.");
            $("#point").focus();
            return false;
        }
        
        if (point > 1000000) {
            alert("최대 1,000,000 포인트까지 선물할 수 있습니다.");
            $("#point").focus();
            return false;
        }
        
        // 보유 포인트 체크
        var mb_point = <?php echo $member['mb_point']; ?>;
        if (point > mb_point) {
            alert("보유하신 포인트가 부족합니다.");
            $("#point").focus();
            return false;
        }
        
        if (!confirm("<?php echo $view['wr_name']; ?>님에게 " + point.toLocaleString() + "포인트를 선물하시겠습니까?")) {
            return false;
        }
        
        return true;
    });
    
    // 천 단위 구분 기능
    $("#point").on('input', function(e) {
        var value = $(this).val().replace(/[^0-9]/g, "");
        if (value) {
            $(this).val(parseInt(value).toLocaleString());
        }
    });
});

function excute_good(href, $el, $tx)
{
    $.post(
        href,
        { js: "on" },
        function(data) {
            if(data.error) {
                alert(data.error);
                return false;
            }

            if(data.count) {
                $el.find("strong").text(number_format(String(data.count)));
                if($tx.attr("id").search("nogood") > -1) {
                    $tx.text("이 글을 비추천하셨습니다.");
                    $tx.fadeIn(200).delay(2500).fadeOut(200);
                } else {
                    $tx.text("이 글을 추천하셨습니다.");
                    $tx.fadeIn(200).delay(2500).fadeOut(200);
                }
            }
        }, "json"
    );
}
</script>
<!-- } 게시글 읽기 끝 -->