<?php
if (!defined('_GNUBOARD_')) exit;

add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);
$list_count = (is_array($list) && $list) ? count($list) : 0;

$latest_title = strip_tags($list[0]['subject']);
if (empty($latest_title)) {
    $latest_title = "게시물이 없습니다.";
}
$title_characters = preg_split('//u', $latest_title, -1, PREG_SPLIT_NO_EMPTY);
$title_json = json_encode($title_characters);
?>

<div id="trail-container" style="position: relative; width: 0; height: 0;"></div>

<script>
var titleChars = <?php echo $title_json; ?>;
var trailDots = [];
var cursorPosition = { x: 0, y: 0 };

var TrailChar = function (char) {
    this.x = 0;
    this.y = 0;
    this.element = (function () {
        var el = document.createElement("div");
        el.className = "trail-char";
        el.style.display = "none"; // 처음엔 숨겨진 상태
        document.body.appendChild(el);
        return el;
    })();
    this.element.textContent = char;
};

TrailChar.prototype.render = function () {
    this.element.style.left = this.x + "px";
    this.element.style.top = this.y + "px";
    this.element.style.color = getRandomColor();
};

function getRandomColor() {
    const r = (Math.random() > 0.5 ? 255 : 0);
    const g = (Math.random() > 0.5 ? 255 : 0);
    const b = (r === 0 && g === 0) ? 255 : (Math.random() > 0.5 ? 255 : 0);
    return `rgb(${r}, ${g}, ${b})`;
}

for (var i = 0; i < titleChars.length; i++) {
    var charDot = new TrailChar(titleChars[i]);
    trailDots.push(charDot);
}

function updateTrail() {
    var x = cursorPosition.x + 10;
    var y = cursorPosition.y + 10;

    trailDots.forEach(function (dot, index, dots) {
        var nextDot = dots[index + 1] || dots[0];
        dot.x = x;
        dot.y = y;
        dot.render();
        x += (nextDot.x - dot.x) * 0.8;
        y += (nextDot.y - dot.y) * 0.8;
    });
}

function showTrail() {
    trailDots.forEach(dot => {
        dot.element.style.display = "block";
    });
}

function hideTrail() {
    trailDots.forEach(dot => {
        dot.element.style.display = "none";
    });
}

addEventListener("mousemove", function (event) {
    cursorPosition.x = event.pageX;
    cursorPosition.y = event.pageY;
    showTrail();
});

addEventListener("touchmove", function (event) {
    if (event.touches && event.touches.length > 0) {
        cursorPosition.x = event.touches[0].pageX;
        cursorPosition.y = event.touches[0].pageY;
        showTrail();
    }
}, { passive: true });

addEventListener("touchend", function () {
    hideTrail();
});

function animateTrail() {
    updateTrail();
    requestAnimationFrame(animateTrail);
}

animateTrail();
</script>
