<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

include_once("./_common.php");
include_once(G5_LIB_PATH.'/get_data.lib.php');
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.G5_URL.'/popular/style.css">', 0);
add_javascript('<script src="'.G5_URL.'/popular/script.js"></script>', 0);

$bo_tables = array('free', 'gallery');
$rows = 10; // 출력할 게시물 수

// 각 기간별 게시물을 가져오는 함수
function get_popular_posts($period, $rows) {
    global $g5, $bo_tables;
    
    $today = date('Y-m-d');
    
    switch($period) {
        case 'daily':
            $start_date = date('Y-m-d', strtotime('-1 day'));
            break;
        case 'weekly':
            $start_date = date('Y-m-d', strtotime('-7 days'));
            break;
        case 'monthly':
            $start_date = date('Y-m-d', strtotime('-30 days'));
            break;
        default:
            $start_date = date('Y-m-d', strtotime('-1 day'));
    }
    
    $list = array();
    
    // 모든 게시판의 인기글을 통합하여 가져옴
    $sql = " SELECT 
                a.bo_table,
                a.wr_id,
                a.wr_subject,
                a.wr_comment,
                a.wr_hit,
                a.wr_datetime
            FROM (";
    
    $union_sql = array();
    foreach ($bo_tables as $bo_table) {
        $union_sql[] = " SELECT 
                '{$bo_table}' as bo_table,
                wr_id,
                wr_subject,
                wr_comment,
                wr_hit,
                wr_datetime
            FROM {$g5['write_prefix']}{$bo_table}
            WHERE wr_is_comment = 0
                AND wr_datetime BETWEEN '{$start_date} 00:00:00' AND '{$today} 23:59:59'";
    }
    
    $sql .= implode(" UNION ALL ", $union_sql);
    $sql .= ") a ORDER BY a.wr_hit DESC, a.wr_comment DESC LIMIT 0, {$rows} ";
    
    $result = sql_query($sql);
    
    for ($i=0; $row = sql_fetch_array($result); $i++) {
        $list[$i]['bo_table'] = $row['bo_table'];
        $list[$i]['wr_id'] = $row['wr_id'];
        $list[$i]['subject'] = $row['wr_subject'];
        $list[$i]['comment_cnt'] = $row['wr_comment'];
        $list[$i]['hit'] = $row['wr_hit'];
        $list[$i]['datetime'] = $row['wr_datetime'];
        
        // 게시판 제목 가져오기
        $board_info = sql_fetch("SELECT bo_subject FROM {$g5['board_table']} WHERE bo_table = '{$row['bo_table']}'");
        $list[$i]['bo_subject'] = $board_info['bo_subject'];
    }
    
    return $list;
}

// 기간별 인기 게시물 가져오기
$daily_list = get_popular_posts('daily', $rows);
$weekly_list = get_popular_posts('weekly', $rows);
$monthly_list = get_popular_posts('monthly', $rows);

// 각 기간별 게시물 수 계산
$daily_count = count($daily_list);
$weekly_count = count($weekly_list);
$monthly_count = count($monthly_list);

// 고유 ID 생성 (여러 인스턴스가 페이지에 있을 경우를 대비)
$unique_id = uniqid('popular_posts_');
?>
<div class="popular-posts-container" id="<?php echo $unique_id; ?>">
    <div class="tab-buttons">
        <button class="tab-button active" data-period="daily">오늘 인기</button>
        <button class="tab-button" data-period="weekly">주간 인기</button>
        <button class="tab-button" data-period="monthly">월간 인기</button>
    </div>
    
    <!-- 일간 인기글 -->
    <div class="posts-list daily-posts">
        <?php if ($daily_count > 0) { ?>
            <?php for ($i=0; $i<$daily_count; $i++) { ?>
                <div class="post-item">
                    <span class="post-rank"><?php echo $i+1; ?></span>
                    <a href="<?php echo get_pretty_url($daily_list[$i]['bo_table'], $daily_list[$i]['wr_id']); ?>" class="post-title">
                        <span class="board-name">[<?php echo $daily_list[$i]['bo_subject']; ?>]</span>
                        <?php echo $daily_list[$i]['subject']; ?>
                        <?php if($daily_list[$i]['comment_cnt'] > 0) { ?><span class="post-comment-count">[<?php echo $daily_list[$i]['comment_cnt']; ?>]</span><?php } ?>
                    </a>
                    <span class="post-date"><?php echo date('m-d', strtotime($daily_list[$i]['datetime'])); ?></span>
                </div>
            <?php } ?>
        <?php } else { ?>
            <div class="empty-posts">인기 게시물이 없습니다.</div>
        <?php } ?>
    </div>
    
    <!-- 주간 인기글 -->
    <div class="posts-list weekly-posts" style="display: none;">
        <?php if ($weekly_count > 0) { ?>
            <?php for ($i=0; $i<$weekly_count; $i++) { ?>
                <div class="post-item">
                    <span class="post-rank"><?php echo $i+1; ?></span>
                    <a href="<?php echo get_pretty_url($weekly_list[$i]['bo_table'], $weekly_list[$i]['wr_id']); ?>" class="post-title">
                        <span class="board-name">[<?php echo $weekly_list[$i]['bo_subject']; ?>]</span>
                        <?php echo $weekly_list[$i]['subject']; ?>
                        <?php if($weekly_list[$i]['comment_cnt'] > 0) { ?><span class="post-comment-count">[<?php echo $weekly_list[$i]['comment_cnt']; ?>]</span><?php } ?>
                    </a>
                    <span class="post-date"><?php echo date('m-d', strtotime($weekly_list[$i]['datetime'])); ?></span>
                </div>
            <?php } ?>
        <?php } else { ?>
            <div class="empty-posts">인기 게시물이 없습니다.</div>
        <?php } ?>
    </div>
    
    <!-- 월간 인기글 -->
    <div class="posts-list monthly-posts" style="display: none;">
        <?php if ($monthly_count > 0) { ?>
            <?php for ($i=0; $i<$monthly_count; $i++) { ?>
                <div class="post-item">
                    <span class="post-rank"><?php echo $i+1; ?></span>
                    <a href="<?php echo get_pretty_url($monthly_list[$i]['bo_table'], $monthly_list[$i]['wr_id']); ?>" class="post-title">
                        <span class="board-name">[<?php echo $monthly_list[$i]['bo_subject']; ?>]</span>
                        <?php echo $monthly_list[$i]['subject']; ?>
                        <?php if($monthly_list[$i]['comment_cnt'] > 0) { ?><span class="post-comment-count">[<?php echo $monthly_list[$i]['comment_cnt']; ?>]</span><?php } ?>
                    </a>
                    <span class="post-date"><?php echo date('m-d', strtotime($monthly_list[$i]['datetime'])); ?></span>
                </div>
            <?php } ?>
        <?php } else { ?>
            <div class="empty-posts">인기 게시물이 없습니다.</div>
        <?php } ?>
    </div>
</div>
