document.addEventListener('DOMContentLoaded', function() {
    // 모든 인기 게시물 위젯에 대해 탭 기능 초기화
    const containers = document.querySelectorAll('.popular-posts-container');
    
    containers.forEach(function(container) {
        const tabButtons = container.querySelectorAll('.tab-button');
        const dailyPosts = container.querySelector('.daily-posts');
        const weeklyPosts = container.querySelector('.weekly-posts');
        const monthlyPosts = container.querySelector('.monthly-posts');
        
        // 모든 게시물 목록 배열
        const allPostsLists = [dailyPosts, weeklyPosts, monthlyPosts];
        
        // 탭 버튼 클릭 이벤트 처리
        tabButtons.forEach(function(button, index) {
            button.addEventListener('click', function() {
                // 모든 버튼에서 active 클래스 제거
                tabButtons.forEach(btn => btn.classList.remove('active'));
                // 클릭된 버튼에 active 클래스 추가
                button.classList.add('active');
                
                // 모든 게시물 목록 숨기기
                allPostsLists.forEach(list => {
                    if (list) list.style.display = 'none';
                });
                
                // 선택된 기간의 게시물 목록 표시
                const period = button.dataset.period;
                if (period === 'daily' && dailyPosts) {
                    dailyPosts.style.display = 'block';
                } else if (period === 'weekly' && weeklyPosts) {
                    weeklyPosts.style.display = 'block';
                } else if (period === 'monthly' && monthlyPosts) {
                    monthlyPosts.style.display = 'block';
                }
            });
        });
    });
});
