<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

// license : gpl
// GPL 프로그램은 어떤 목적으로, 어떤 형태로든 사용할 수 있지만 사용하거나 변경된 프로그램을 배포하는 경우 무조건 동일한 라이선스 즉, GPL로 공개해야 한다.

// wr_1 : 경매시작일시
// wr_2 : 경매종료일시
// wr_3 : 참여 포인트
// wr_4 : 입찰 최소 번호
// wr_5 : 입찰 최고 번호
// wr_6 : 하루 참여 횟수 
// wr_7 : 입찰 횟수
// wr_8 : 경매상태 (0: 경매전, 1:진행중, 2:낙찰, 3:유찰)
// wr_9 : 낙찰 포인트
// wr_10 : 낙찰회원아이디

    $tender_table = $g5['write_prefix']."Tender"."_".$bo_table; //$g5['write_prefix']."_".$bo_table; //입찰_Table 고대영 처리
    $auction_possible_point = 0; //회원의 경매등록 가능한 포인터-경매등록 포인트
    $auction_impossible_modify = 1; //경매정보 수정 불가, Tender_Table의 입찰수가 $impossible_modify_tender 이상일때 수정불가
    
if (!isset($board['bo_1']) || !$board['bo_1'])
{
    $sql = " update {$g5['board_table']} set ";
    $sql.= "  bo_1_subj = '참여 포인트 기본값' ";
    $sql.= " ,bo_2_subj = '입찰 최소 번호 기본값' ";
    $sql.= " ,bo_3_subj = '입찰 최대 번호 기본값' ";
    $sql.= " ,bo_4_subj = '하루 참여 횟수 기본값' ";
    $sql.= " ,bo_5_subj = '회원가입후 입찰 가능일 기본값' ";
    $sql.= " ,bo_6_subj = '입찰금액 단위' ";
    $sql.= " ,bo_7_subj = '입찰방식' ";
    $sql.= " ,bo_8_subj = '낙찰방식' ";
    $sql.= " ,bo_9_subj = '배송방법' ";
    $sql.= " ,bo_10_subj = '배송비용' ";
    $sql.= " where bo_table = '$bo_table' ";
    sql_query($sql, false);

    $sql = " update {$g5['board_table']} set ";
    $sql.= "  bo_1 = '0' ";
    $sql.= " ,bo_2 = '0' ";    
    $sql.= " ,bo_3 = '10000' ";
    $sql.= " ,bo_4 = '1' ";
    $sql.= " ,bo_5 = '0' ";
    $sql.= " ,bo_6 = '1|10|100|1000|10000|100000|1000000' ";
    $sql.= " ,bo_7 = '공개|비공개' ";
    $sql.= " ,bo_8 = '최저가|최고가' ";
    $sql.= " ,bo_9 = '택배-선불|택배-착불|화물-선불|화물-착불|기타' ";
    $sql.= " ,bo_10 = '3000|5000|10000|15000|30000' ";
    $sql.= " where bo_table = '$bo_table' ";
    sql_query($sql, false);
}

    $sql = " CREATE TABLE IF NOT EXISTS $tender_table ( "; // create table $tender_table ( "; //고대영 처리
    $sql.= " `td_id` INT NOT NULL AUTO_INCREMENT ,";
    $sql.= " `wr_id` INT NOT NULL ,";
    $sql.= " `mb_id` VARCHAR( 30 ) NOT NULL ,";
    $sql.= " `mb_name` VARCHAR( 255 ) NOT NULL ,";
    $sql.= " `mb_nick` VARCHAR( 255 ) NOT NULL ,";
    $sql.= " `mb_email` VARCHAR( 255 ) NOT NULL ,";
    $sql.= " `mb_homepage` VARCHAR( 255 ) NOT NULL ,";
    $sql.= " `td_inter_point` INT NOT NULL ,";
    $sql.= " `td_tender_point` INT NOT NULL ,";
    $sql.= " `td_status` CHAR( 1 ) NOT NULL ,";
    $sql.= " `td_last` DATETIME NOT NULL ,";
    $sql.= " `td_datetime` DATETIME NOT NULL ,";
    $sql.= " PRIMARY KEY ( `td_id` ) ,";
    $sql.= " INDEX ( `wr_id` ) ";
    $sql.= " ); ";
    sql_query($sql, false);
    
    //write_table(경매_Table)이 비어 있을시 입찰_Table을 비운다.--관리자가 경매_Table 삭제시 입찰_Table의 데이터가 남아 있을 수 있다.
    $write_table_row = sql_fetch(" select count(wr_id) as cnt from $write_table; ");
    if (!isset($write_table_row['cnt']) || !$write_table_row['cnt']){sql_query(" delete from $tender_table; ");}
    //write_table(경매_Table)이 비어 있을시 입찰_Table을 비운다.
        
// 경매 상태 출력
function auction_status($status) {
    switch (intval($status))
    {
        case 0: $status = "시작전"; break;
        case 1: $status = "진행중"; break;
        case 2: $status = "종료[낙찰]"; break;
        case 3: $status = "종료[유찰]"; break;
    }
    return $status;
}

// 경매 상태 변경 -- 고대영 추가
function auction_status_change($info) {
    global $g5, $write_table, $tender_table;

    // 경매전 -> 시작시간이 지났을 때 -> 경매진행중
    if (($info['status'] ?? '') == "0" && ($info['start_datetime'] ?? '') <= G5_TIME_YMDHIS)
    {
    sql_query(" update $write_table set wr_8 = '1' where wr_id = '{$info['wr_id']}' ");
    $info['status'] = "1";
    }

    // 경매진행중 -> 종료시간이 지났을 때 -> 경매종료
    if (($info['status'] ?? '') == "1" && ($info['end_datetime'] ?? '') <= G5_TIME_YMDHIS)
    {////--1
    $result = auction_successful($info);
    if (isset($result['wr_8']) && $result['wr_8'] > 1)
      {////--2
        $info['tender_count'] = $result['wr_7'] ?? 0;
        $info['status'] = $result['wr_8'] ?? 0;
        $info['auction_off_point'] = doubleval($result['wr_9'] ?? 0);//낙찰금액
        $info['mb_id'] = $result['wr_10'] ?? '';
      }////--2
    }////--1

    return $info;//변경된 info return
}

// 입찰된 내역을 조회 (현재 1위) - 고대영 추가
function auction_super_point($info) { //$view=1 이면 Display용, $view=0 이면 실제 입찰금액에서 super_point를 구한다.
    $row = sql_fetch($info['auction_query'] ?? '');
    $super = array("point" => ($row['point'] ?? 0), "count" => ($row['cnt'] ?? 0));
    if(!($super['point'] ?? 0)){
        if(($info['auction_off_method'] ?? '') == "최고가"){
            $super['point'] = $info['tender_lower'] ?? 0;
        } else {
            $super['point'] = $info['tender_higher'] ?? 0;
        }
    }//현재가 셋팅
    
    return $super;
}
// 경매정보(추가필드)를 가져온다.
function get_info_auction($wr_id, $row=null) {
    global $g5, $write, $write_table, $tender_table;

    if (!$row && !$write) {
        $row = sql_fetch(" select wr_subject, wr_1, wr_2, wr_3, wr_4, wr_5, wr_6, wr_7, wr_8, wr_9, wr_10 from $write_table where wr_id = '$wr_id' ");
    } elseif (!$row && $write) {
        $row = $write;
    }

    $pd = explode("|", $row['wr_subject'] ?? '');//0-공급업체, 1-상품명, 2-입찰단위금액, 3-입찰방식, 4-낙찰방식, 5-한 사람(회원) 입찰 가능수, 6-낙찰하기 위한 입찰자 수,7-배송방법, 8-배송비용

    unset($res);
    $res = [];
    $res['wr_id'] = $wr_id;
    $res['company'] = trim($pd[0] ?? '');
    $res['product'] = trim($pd[1] ?? '');
////경매-부가정보////
    $res['tender_unit'] = trim($pd[2] ?? '');
    $res['tender_method'] = trim($pd[3] ?? '');
    $res['auction_off_method'] = trim($pd[4] ?? '');
    $res['tender_possible_count'] = trim($pd[5] ?? '');
    $res['auction_off_member_count'] = trim($pd[6] ?? '');
    $res['delivery_method'] = trim($pd[7] ?? '');
    $res['delivery_price'] = trim($pd[8] ?? '');
    //최고가-최저가 쿼리
    $res['order_by'] = (($res['auction_off_method'] ?? '') == "최저가") ? "" : "desc"; //최저가-최대가(desc)
    $res['auction_query'] = " select td_tender_point as point, count(td_tender_point) as cnt from $tender_table where wr_id = '$wr_id' group by point order by point {$res['order_by']}, cnt limit 1 ";
    //최고가-최저가 쿼리
    //낙찰을 위한 입찰자 쿼리
    $res['off_row_query'] = " Select COUNT(DISTINCT mb_id) As cnt From $tender_table Where wr_id = '$wr_id' ";
    //낙찰을 위한 입찰자 쿼리
////경매-정보////
    $res['start_datetime'] = $row['wr_1'] ?? '';
    $res['end_datetime'] = $row['wr_2'] ?? '';
    $res['inter_point'] = doubleval($row['wr_3'] ?? 0); //doubleval - 고대영 추가
    $res['tender_lower'] = doubleval($row['wr_4'] ?? 0);
    $res['tender_higher'] = doubleval($row['wr_5'] ?? 0);
    $res['day_limit'] = intval($row['wr_6'] ?? 0);
    //즉시구매가
    $res['buy_now_price'] = 0;
    if(($res['auction_off_method'] ?? '') == "최고가"){
        if(($res['tender_higher'] ?? 0) > 0){
            $res['buy_now_price'] = $res['tender_higher'];
        }
    } //최고가-->tender_higher를 즉시 구매가로 설정
    if(($res['auction_off_method'] ?? '') == "최저가"){
        if(($res['tender_lower'] ?? 0) > 0){
            $res['buy_now_price'] = $res['tender_lower'];
        }
    } //최고가-->tender_higher를 즉시 구매가로 설정
    
    $res['lower_label'] = (($res['auction_off_method'] ?? '') == "최고가") ? "시작가" : "하한가"; //라벨설정
    $res['higher_label'] = (($res['auction_off_method'] ?? '') == "최고가") ? "상한가" : "시작가"; //라벨설정
    //즉시구매가
////경매-정보////
////경매-입찰정보////
    $res['tender_count'] = intval($row['wr_7'] ?? 0);
    $res['status'] = intval($row['wr_8'] ?? 0);
    $res['auction_off_point'] = doubleval($row['wr_9'] ?? 0);//낙찰금액
    $res['mb_id'] = $row['wr_10'] ?? '';
////경매-입찰정보////

// 경매 상태 변경 -- 고대영 추가
    $res = auction_status_change($res); //정보변경
// 경매 상태 변경 -- 고대영 추가

    return $res;
}

// 경매 입찰 공통 검사
function tender_common_check($wr_id) {
    global $g5, $board, $bo_table, $member, $write, $write_table, $tender_table;
    
    $url = G5_BBS_URL."/board.php?bo_table=".$bo_table;

    if (!isset($member['mb_id']) || !$member['mb_id']){alert_only("로그인 해주세요.", "{$url}");}
    if (isset($board['bo_5']) && $board['bo_5'] > 0 && ((G5_SERVER_TIME - strtotime($member['mb_datetime'] ?? '')) < ($board['bo_5']*86400))){alert_only("회원가입 후 {$board['bo_5']} 일이 지나야 참여 가능합니다.", "{$url}");}

    $auction = get_info_auction($wr_id);

    if (G5_TIME_YMDHIS < ($auction['start_datetime'] ?? '')){alert_only("경매 시작전 입니다.", "{$url}");}
    if (G5_TIME_YMDHIS > ($auction['end_datetime'] ?? '')){alert_only("경매가 종료 되었습니다.", "{$url}");}

    return $auction;
}

// 경매 건별 입찰 진행
function tender_send($wr_id, $point) {
    global $g5, $board, $bo_table, $member, $write, $write_table, $tender_table;
    
    $url = G5_BBS_URL."/board.php?bo_table=".$bo_table."&wr_id=".$wr_id;

    $auction = tender_common_check($wr_id);
    
    //한사람 제한 횟수 체크
    $tender_possible_count_row = sql_fetch(" select count(mb_id) as cnt from $tender_table where mb_id = '{$member['mb_id']}' and wr_id = '$wr_id' ");
    if (($tender_possible_count_row['cnt'] ?? 0) >= ($auction['tender_possible_count'] ?? 0)){alert_only("이미 입찰하셨습니다. 입찰에 {$auction['tender_possible_count']} 번만 참여 가능합니다.", "{$url}");}
    
    //1일 제한 횟수 체크
    $day_limit_row = sql_fetch(" select count(mb_id) as cnt from $tender_table where td_datetime like '".G5_TIME_YMD."%' and mb_id = '{$member['mb_id']}' and wr_id = '$wr_id' ");
    if (($day_limit_row['cnt'] ?? 0) >= ($auction['day_limit'] ?? 0)){alert_only("하루에 {$auction['day_limit']} 번만 참여 가능합니다.", "{$url}");}
    
    if($point <= 0){alert_only("입찰 금액은 0 보다 크야 합니다.", "{$url}");} //고대영 추가
    if(($auction['tender_lower'] ?? 0) > 0 && ($auction['tender_higher'] ?? 0) > 0){
        if ($point < ($auction['tender_lower'] ?? 0) || $point > ($auction['tender_higher'] ?? 0)){
            alert_only("입찰 금액은 ".number_format($auction['tender_lower'] ?? 0)."~".number_format($auction['tender_higher'] ?? 0)."원 사이로 설정해주세요.", "{$url}");
        }
    }//최저-최고가 가 설정됨
    
    if(($auction['auction_off_method'] ?? '') == "최고가" && (($auction['tender_lower'] ?? 0) > 0 && ($auction['tender_higher'] ?? 0) == 0)){
        if($point < ($auction['tender_lower'] ?? 0)){
            alert_only("입찰 금액은 시작가".number_format($auction['tender_lower'] ?? 0)."원 보다 높아야 합니다.", "{$url}");
        }
    } //고대영 추가
    
    if(($auction['auction_off_method'] ?? '') == "최저가" && (($auction['tender_lower'] ?? 0) == 0 && ($auction['tender_higher'] ?? 0) > 0)){
        if($point < ($auction['tender_higher'] ?? 0)){
            alert_only("입찰 금액은 시작가".number_format($auction['tender_higher'] ?? 0)."원 보다 낮아야 합니다.", "{$url}");
        }
    } //고대영 추가
        
    $total_point = (int)($auction['inter_point'] ?? 0);

    if (($member['mb_point'] ?? 0) - $total_point < 0){alert_only("보유중인 포인트(".number_format($member['mb_point'] ?? 0).") 가 참여 포인트(".number_format($total_point).") 보다 부족합니다.", "{$url}");}

    // 최고|최저 입찰된 내역을 조회 (현재 1위)
    $super = auction_super_point($auction);//$view=0, 실제 입찰가에서 구한다.
    // 최고|최저 입찰된 내역을 조회 (현재 1위)
    
    if(($auction['auction_off_method'] ?? '') == "최저가") //고대영 추가
    {
        if (($super['point'] ?? 0) < $point){
            alert_only("현재 최저가(".number_format($super['point'] ?? 0)."원)보다 낮아야 합니다.", "{$url}");
        }
    } //고대영 추가
    else
    {
        if (($super['point'] ?? 0) > $point){
            alert_only("현재 최고가(".number_format($super['point'] ?? 0)."원)보다 높아야 합니다.", "{$url}");
        }
    }
    
    // 즉구 처리
  	//if ($point == $auction[tender_higher]){sql_query(" update $write_table set wr_8 = '2', wr_9 = '$point', wr_10 = '$member[mb_id]' where wr_id = '$wr_id' ");}
  	if ($point == ($auction['buy_now_price'] ?? 0)){sql_query(" update $write_table set wr_8 = '2', wr_9 = '$point', wr_10 = '{$member['mb_id']}' where wr_id = '$wr_id' ");} //고대영 처리

    $row = sql_fetch(" select count(*) as cnt from $tender_table where wr_id = '$wr_id' and mb_id = '{$member['mb_id']}' and td_tender_point = '$point' ");
    if (($row['cnt'] ?? 0)){alert_only("이미 같은 금액으로 입찰 하셨습니다.", "{$url}");}

    tender_common_update($auction, $point);
}

// 입찰 DB 처리
function tender_common_update($auction, $point) {
    global $g5, $board, $bo_table, $member, $write, $write_table, $tender_table;

    $sql = "insert into {$tender_table} set ";
    $sql.= " wr_id = '{$auction['wr_id']}' ";
    $sql.= ",mb_id = '{$member['mb_id']}' ";
    $sql.= ",mb_name = '{$member['mb_name']}' ";
    $sql.= ",mb_nick = '{$member['mb_nick']}' ";
    $sql.= ",mb_email = '{$member['mb_email']}' ";
    $sql.= ",mb_homepage = '{$member['mb_homepage']}' ";
    $sql.= ",td_inter_point = '{$auction['inter_point']}' ";
    $sql.= ",td_tender_point = '$point' ";
    $sql.= ",td_status = '1' ";
    $sql.= ",td_last = '".G5_TIME_YMDHIS."' ";
    $sql.= ",td_datetime = '".G5_TIME_YMDHIS."' ";
    sql_query($sql);

    // 입찰 횟수
    $row = sql_fetch(" select count(*) as cnt from {$tender_table} where wr_id = '{$auction['wr_id']}' ");
    $tender_count = (int)($row['cnt'] ?? 0);
    sql_query(" update $write_table set wr_7 = {$tender_count} where wr_id = '{$auction['wr_id']}' ");
}

// 경매의 낙찰 여부 검사 및 업데이트
function auction_successful($auction) {
    global $g5, $write_table, $tender_table;
    // 나중에 등록한 게시물의 종료시간이 더 짧으면 모두 종료되는 오류 수정

    // 경매상태 조회 - 이미 종료되었으면 return
    if (($auction['status'] ?? 0) > 1){return false;}

    // 경매가 시작전이면 return
    if (($auction['start_datetime'] ?? '') > G5_TIME_YMDHIS){return false;}

    // 경매날짜를 비교하여 진행중일경우 return
    if (($auction['start_datetime'] ?? '') < G5_TIME_YMDHIS && ($auction['end_datetime'] ?? '') > G5_TIME_YMDHIS){return false;}

    // 최고|최저 입찰된 내역을 조회 -- 고대영
    $row = sql_fetch($auction['auction_query'] ?? '');

    // 입찰자수 조회 내역을 조회 -- 고대영
    $off_row = sql_fetch($auction['off_row_query'] ?? '');

    // 중복되었거나 입찰내역이 없을 경우, 입찰자 수가 낙찰하기 위한 입찰자 수보다 적은 경우 유찰
    if (($row['cnt'] ?? 0) > 1 || !$row || ($off_row['cnt'] ?? 0) < ($auction['auction_off_member_count'] ?? 0)) {
        sql_query(" update $write_table set wr_8 = '3' where wr_id = '{$auction['wr_id']}' ");

        $res = sql_fetch(" select wr_7, wr_8, wr_9, wr_10 from $write_table where wr_id = '{$auction['wr_id']}' ");
        return $res;
    } else {
        // 낙찰된 입찰정보 가져오기
        $row = sql_fetch(" select * from $tender_table where td_tender_point = '{$row['point']}' and wr_id = '{$auction['wr_id']}' ");
        sql_query(" update $write_table set wr_8 = '2', wr_9 = '{$row['td_tender_point']}', wr_10 = '{$row['mb_id']}' where wr_id = '{$auction['wr_id']}' ");

        $res = sql_fetch(" select wr_7, wr_8, wr_9, wr_10 from $write_table where wr_id = '{$auction['wr_id']}' ");
        return $res;
    }
}

function alert_only($msg='', $url='') {
	//global $g5;

	echo "<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\">";
	echo "<script>";
	echo "alert('$msg');";
	if($url) {
	    echo "location.replace('$url');";
	}
	echo "</script>";
    exit;
}
