<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH . '/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . $latest_skin_url . '/slick/slick.min.css">', 0);
add_javascript('<script src="' . $latest_skin_url . '/slick/slick.min.js"></script>', 0);
add_stylesheet('<link rel="stylesheet" href="' . $latest_skin_url . '/style.css">', 0);
$thumb_width = 400;
$thumb_height = 520;
$list_count = (is_array($list) && $list) ? count($list) : 0;
?>
<section id="chamcode-banner">
	<div class="slick-wrap">
		<div class="slick">
			<?php
			for ($i = 0; $i < $list_count; $i++) {
				$thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);
				if ($thumb['src']) {
					$img = $thumb['src'];
				} else {
					$img = G5_IMG_URL . '/no_img.png';
					$thumb['alt'] = '이미지가 없습니다.';
				}
				$img_content = '<img src="' . $img . '" alt="' . $thumb['alt'] . '" >';
				if ($list[$i]['wr_link1'] != '') {
					$link = $list[$i]['wr_link1'];
				} else {
					$link = get_pretty_url($bo_table, $list[$i]['wr_id']);
				}
				$flag = (int) $list[$i]['wr_2'];
			?>
				<div class="wrap" style="background-color:<?php echo $list[$i]['wr_3']; ?>">
					<figure>
						<a href="<?php echo $link; ?>" <?php echo ($flag) ? 'target="_blank" title="새창 열림"' : ''; ?> class="lt-img"><?php echo run_replace('thumb_image_tag', $img_content, $thumb); ?></a>
						<figcaption>
							<h2><a href="<?php echo $link; ?>" <?php echo ($flag) ? 'target="_blank" title="새창 열림"' : ''; ?>><?php echo $list[$i]['wr_subject']; ?></a></h2>
							<div class="banner-content">
								<?php echo $list[$i]['wr_1']; ?>
							</div>
						</figcaption>
					</figure>
				</div>
			<?php }  ?>
			<?php if ($list_count == 0) { //게시물이 없을 때
			?>
				<p class="empty">게시물이 없습니다.</p>
			<?php }  ?>
		</div>
		<div class="pack">
			<div class="dots-wrap">
				<div class="dots"></div>
				<button class="pause">
					<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-tallymark-2" width="18"
						height="18" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
						stroke-linecap="round" stroke-linejoin="round">
						<title>배너 일시 정지</title>
						<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
						<line x1="10" y1="5" x2="10" y2="19"></line>
						<line x1="14" y1="5" x2="14" y2="19"></line>
					</svg>
				</button>
				<button class="play">
					<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-play" width="18"
						height="18" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
						stroke-linecap="round" stroke-linejoin="round">
						<title>배너 자동 재생</title>
						<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
						<path d="M7 4v16l13 -8z"></path>
					</svg>
				</button>
			</div>
			<button class="prev">
				<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="50"
					height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" fill="none" stroke-linecap="round"
					stroke-linejoin="round">
					<title>이전 배너 보기</title>
					<path stroke="none" d="M0 0h24v24H0z" fill="none" />
					<polyline points="15 6 9 12 15 18" />
				</svg>
			</button>
			<button class="next">
				<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-right" width="30"
					height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
					stroke-linecap="round" stroke-linejoin="round">
					<title>다음 배너 보기</title>
					<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
					<polyline points="9 6 15 12 9 18"></polyline>
				</svg>
			</button>
		</div>
	</div>
</section>
<script>
	$('#chamcode-banner .slick').slick({
		autoplay: true,
		arrows: true,
		accessibility: true,
		dots: true,
		appendDots: $('#chamcode-banner .dots'),
		dotsClass: 'slick-dots',
		prevArrow: $('#chamcode-banner .prev'),
		nextArrow: $('#chamcode-banner .next'),
		draggable: true,
		fade: true,
		infinite: true,
		centerMode: false,
		slidesToShow: 1,
		slidesToScroll: 1,
		zIndex: 1,
		pauseOnHover: false,
		autoplaySpeed: 5000,
		speed: 1500,
	});
	$('#chamcode-banner .play, #chamcode-banner .pause').on('click', function(e) {
		e.preventDefault();
		if ($(this).hasClass('pause')) {
			$(this).hide();
			$('#chamcode-banner .play').show();
			$('#chamcode-banner .slick').slick('slickPause');
		} else if ($(this).hasClass('play')) {
			$(this).hide();
			$('#chamcode-banner .pause').show();
			$('#chamcode-banner .slick').slick('slickPlay');
		}
	});
</script>