<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

/**
 * 반응형 유튜브 및 미디어 기능 그누보드 훅
 * - 에디터에 유튜브 삽입 기능 추가
 * - 반응형 유튜브 비디오 처리
 * - 모바일 최적화 인터페이스
 */

// 페이지 하단에 스크립트 추가
add_event('tail_sub', 'responsive_media_handler');

function responsive_media_handler() {
    global $board, $wr_id, $config, $member;
    
    // 글쓰기 페이지에서 에디터 수정
    if (basename($_SERVER['PHP_SELF']) === "write.php" && ($wr_id || $wr_id === 0) && 
        isset($board['bo_use_dhtml_editor']) && $board['bo_use_dhtml_editor'] && 
        isset($config['cf_editor']) && $config['cf_editor'] == "smarteditor2") {
        
        // 사용자 권한에 따라 업로드 버튼 표시 여부 결정
        $upload_display = isset($member['mb_level']) && isset($board['bo_upload_level']) && 
                        $member['mb_level'] < $board['bo_upload_level'] ? "none" : "block";
        
        add_editor_youtube_button($upload_display);
    }
    
    // 게시글 보기 페이지에서 유튜브 비디오 반응형 처리
    if (basename($_SERVER['PHP_SELF']) === "board.php" && $wr_id && $wr_id > 0) {
        add_responsive_viewer();
    }
    
    // 댓글 영역 미디어 처리 (모든 페이지)
    add_comment_media_handler();
}

/**
 * 스마트에디터에 유튜브 삽입 버튼 추가
 */
function add_editor_youtube_button($upload_display) {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        // 에디터 iframe이 로드된 후 실행
        const editorFrame = document.getElementById('wr_content')?.nextSibling;
        if (!editorFrame) return;
        
        editorFrame.onload = function() {
            const se2Custom = this.contentWindow.document;
            
            // 에디터 컨테이너 스타일 설정 (100% 너비)
            const editorContainer = se2Custom.querySelector('#smart_editor2');
            if (editorContainer) {
                editorContainer.style.width = 
                editorContainer.style.maxWidth = 
                editorContainer.style.minWidth = '100%';
            }
            
            // 에디터 스타일 개선
            improveEditorStyles(se2Custom, '<?php echo $upload_display; ?>');
            
            // 유튜브 삽입 버튼 추가
            addYoutubeButton(se2Custom);
            
            // 에디터 내부 iframe에 반응형 스타일 추가
            const editorIframe = se2Custom.querySelector('#smart_editor2 #se2_iframe');
            if (editorIframe) {
                editorIframe.onload = function() {
                    // 반응형 스타일 추가
                    const doc = this.contentWindow.document;
                    doc.head.insertAdjacentHTML('beforeend', `
                        <style>
                            /* 이미지 반응형 처리 */
                            img { 
                                max-width: 100%; 
                                height: auto; 
                            }
                            
                            /* 유튜브 컨테이너 반응형 처리 */
                            .youtube-bo_v_con {
                                position: relative;
                                width: 100%;
                                padding-bottom: 56.25%; /* 16:9 비율 */
                                margin: 1em 0;
                                overflow: hidden;
                            }
                            
                            .youtube-bo_v_con iframe {
                                position: absolute;
                                top: 0;
                                left: 0;
                                width: 100% !important;
                                height: 100% !important;
                                border: none;
                            }
                        </style>
                    `);
                };
            }
        };
        
        /**
         * 에디터 스타일 개선 함수
         */
        function improveEditorStyles(se2Custom, uploadDisplay) {
            // 툴바 패딩 조정
            const toolbar = se2Custom.querySelector('#smart_editor2 .se2_text_tool');
            if (toolbar) {
                toolbar.style.padding = '0px 0px 5px 5px';
            }
            
            // 폰트 타입 메뉴 조정
            const fontTypeMenu = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_font_type li');
            if (fontTypeMenu) {
                fontTypeMenu.style.marginLeft = '-1px';
            }
            
            // 툴바 내 모든 메뉴 패딩 조정
            const toolbarMenus = se2Custom.querySelectorAll('#smart_editor2 .se2_text_tool ul');
            toolbarMenus.forEach(menu => {
                menu.style.paddingTop = '5px';
            });
            
            // 캐릭터 메뉴 조정
            const specialCharMenu = se2Custom.querySelector('#smart_editor2 .se2_bx_character .se2_s_character ul');
            if (specialCharMenu) {
                specialCharMenu.style.marginTop = '5px';
            }
            
            // 멀티 메뉴 조정
            const multiMenu = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_multy');
            if (multiMenu) {
                multiMenu.style.float = 'right';
                multiMenu.style.paddingRight = '4px';
                multiMenu.style.position = 'static';
                multiMenu.style.height = '21px';
                multiMenu.style.border = 'none';
                multiMenu.style.display = uploadDisplay;
            }
            
            // 멀티 버튼 조정
            const multiButton = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_multy button');
            if (multiButton) {
                multiButton.style.height = '21px';
                multiButton.style.backgroundColor = '#f4e3d5';
                multiButton.style.border = '1px solid #bbbbbb';
            }
            
            // 멀티 아이콘 조정
            const multiIcon = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_multy .se2_icon');
            const multiText = se2Custom.querySelector('#smart_editor2 .se2_text_tool button span.se2_mntxt');
            if (multiIcon && multiText) {
                multiIcon.style.marginTop = multiText.style.marginTop = '-5px';
            }
            
            // Z-index 조정 (메뉴가 겹치지 않도록)
            const fontType = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_font_type');
            if (fontType) {
                fontType.style.position = 'relative';
                fontType.style.zIndex = '60';
                
                // nextSibling 처리를 안전하게 수행
                let sibling = fontType.nextElementSibling;
                let zIndex = 59;
                while (sibling && zIndex >= 55) {
                    sibling.style.position = 'relative';
                    sibling.style.zIndex = zIndex.toString();
                    sibling = sibling.nextElementSibling;
                    zIndex--;
                }
            }
            
            // 컨버전 모드 조정
            const conversionMode = se2Custom.querySelector('#smart_editor2 .se2_conversion_mode');
            if (conversionMode) {
                conversionMode.style.padding = '5px';
                conversionMode.style.backgroundColor = '#f9f9f9';
            }
            
            // 인풋 영역 컨트롤러 조정
            const inputAreaController = se2Custom.querySelector('#smart_editor2 .se2_inputarea_controller');
            if (inputAreaController) {
                inputAreaController.style.textAlign = 'left';
                inputAreaController.style.paddingLeft = '5px';
            }
        }
        
        /**
         * 유튜브 삽입 버튼 추가 함수
         */
        function addYoutubeButton(se2Custom) {
            const fontTypeMenu = se2Custom.querySelector('#smart_editor2 .se2_text_tool .se2_font_type');
            if (!fontTypeMenu) return;
            
            // 유튜브 버튼 추가
            fontTypeMenu.insertAdjacentHTML('afterend', `
                <ul id='addMedia' style='display:flex;justify-content:center;align-items:center;height:30px;'>
                    <span style='display:flex;justify-content:center;align-items:center;color:#0000ff;font-weight:bold;cursor:pointer;width:60px;height:21px;background-color:#d5e6f9;border:1px solid #bbbbbb;border-radius:3px;box-sizing:border-box'>
                        유튜브
                    </span>
                    <div style='display:none;position:absolute;top:30px;left:0;z-index:100;background-color:#fff;padding:10px;border:1px solid #bbbbbb;border-radius:3px;box-shadow:0 2px 5px rgba(0,0,0,0.2);width:450px'>
                        <div style="display:flex;margin-bottom:5px">
                            <input placeholder="유튜브 URL 또는 비디오 ID를 입력하세요" style='flex:1;height:30px;border:1px solid #bbbbbb;border-radius:3px;padding:0 10px;outline:none;'>
                        </div>
                        <div style="display:flex;justify-content:flex-end">
                            <span id='addMediaInsert' style='display:flex;justify-content:center;align-items:center;color:#0000ff;font-weight:bold;cursor:pointer;width:60px;height:30px;border:1px solid #bbbbbb;border-radius:3px;background-color:#d5e6f9;margin-right:5px'>
                                삽입
                            </span>
                            <span id='addMediaClose' style='display:flex;justify-content:center;align-items:center;color:#c00000;font-weight:bold;cursor:pointer;width:60px;height:30px;border:1px solid #bbbbbb;border-radius:3px;background-color:#f7d7e4'>
                                닫기
                            </span>
                        </div>
                    </div>
                </ul>
            `);
            
            // 유튜브 삽입 기능 설정
            const addMediaBtn = se2Custom.querySelector('#addMedia > span');
            const addMediaPopup = se2Custom.querySelector('#addMedia > div');
            const addMediaInput = se2Custom.querySelector('#addMedia input');
            const addMediaInsert = se2Custom.querySelector('#addMediaInsert');
            const addMediaClose = se2Custom.querySelector('#addMediaClose');
            
            // 유튜브 버튼 클릭 이벤트
            addMediaBtn.onclick = function(e) {
                e.stopPropagation();
                addMediaPopup.style.display = addMediaPopup.style.display === 'none' ? 'block' : 'none';
            };
            
            // 외부 클릭 시 팝업 닫기
            document.addEventListener('click', function(e) {
                if (!addMediaPopup.contains(e.target) && e.target !== addMediaBtn) {
                    addMediaPopup.style.display = 'none';
                }
            });
            
            // 삽입 버튼 클릭 이벤트
            addMediaInsert.onclick = function() {
                let videoId = addMediaInput.value.trim();
                
                // 다양한 유튜브 URL 형식 처리
                if (videoId.includes('youtube.com/watch?v=')) {
                    const match = videoId.match(/[?&]v=([a-zA-Z0-9_-]{11})/);
                    if (match && match[1]) videoId = match[1];
                } else if (videoId.includes('youtu.be/')) {
                    const match = videoId.match(/youtu\.be\/([a-zA-Z0-9_-]{11})/);
                    if (match && match[1]) videoId = match[1];
                } else if (videoId.includes('youtube.com/shorts/')) {
                    const match = videoId.match(/shorts\/([a-zA-Z0-9_-]{11})/);
                    if (match && match[1]) videoId = match[1];
                }
                
                // 반응형 유튜브 컨테이너 삽입
                if (videoId && videoId.length === 11) {
                    const youtubeHtml = `
                        <div class='youtube-bo_v_con'>
                            <iframe src='https://www.youtube.com/embed/${videoId}?rel=0' frameborder='0' allowfullscreen></iframe>
                        </div>
                    `;
                    window.oEditors.getById['wr_content'].exec('PASTE_HTML', [youtubeHtml]);
                    addMediaInput.value = '';
                    addMediaPopup.style.display = 'none';
                }
            };
            
            // 닫기 버튼 클릭 이벤트
            addMediaClose.onclick = function() {
                addMediaInput.value = '';
                addMediaPopup.style.display = 'none';
            };
        }
    });
    </script>
    <?php
}

/**
 * 게시글 보기 페이지에 반응형 유튜브 처리 추가
 */
function add_responsive_viewer() {
    ?>
    <style>
    /* 반응형 유튜브 컨테이너 */
    .youtube-bo_v_con {
        position: relative;
        width: 100%;
        padding-bottom: 56.25%; /* 16:9 비율 */
        margin: 1em 0;
        overflow: hidden;
    }
    
    .youtube-bo_v_con iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100% !important;
        height: 100% !important;
        border: none;
    }
    
    /* 모바일 최적화 */
    @media (max-width: 768px) {
        .youtube-bo_v_con {
            margin: 0.5em 0;
        }
    }
    </style>
    <?php
}

/**
 * 댓글 영역 미디어 자동 변환 처리
 */
function add_comment_media_handler() {
    ?>
    <style>
    /* 댓글 내 반응형 미디어 컨테이너 */
    .responsive-media {
        max-width: 100%;
        margin: 0.5em 0;
        overflow: hidden;
    }
    
    /* 반응형 이미지 */
    .responsive-image {
        max-width: 100%;
        height: auto;
    }
    
    /* 반응형 비디오/오디오 */
    .responsive-video video,
    .responsive-audio audio {
        width: 100%;
        max-width: 100%;
    }
    
    /* 반응형 유튜브 일반 영상 (16:9) */
    .responsive-youtube {
        position: relative;
        width: 100%;
        padding-bottom: 56.25%;
        overflow: hidden;
    }
    
    /* 반응형 유튜브 쇼츠 (9:16) */
    .responsive-youtube-shorts {
        position: relative;
        width: 100%;
        max-width: 315px;
        padding-bottom: 177.78%;
        margin: 0 auto;
        overflow: hidden;
    }
    
    /* 유튜브 iframe 공통 스타일 */
    .responsive-youtube iframe,
    .responsive-youtube-shorts iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border: none;
    }
    </style>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // 댓글 영역 미디어 링크 자동 변환
        const commentLinks = document.querySelectorAll("#bo_vc .cmt_contents a");
        if (!commentLinks.length) return;
        
        const fileExtensions = [".mp3", ".mp4", ".jpg", ".png", ".gif", ".jpeg"];
        
        commentLinks.forEach(link => {
            const href = link.href.toLowerCase();
            const fileExt = href.substring(href.lastIndexOf('.'));
            
            // 미디어 파일 링크 처리
            if (fileExtensions.includes(fileExt)) {
                const container = document.createElement('div');
                container.className = 'responsive-media';
                
                // 오디오 파일
                if (fileExt === ".mp3") {
                    container.innerHTML = `
                        <div class="responsive-audio">
                            <audio src="${link.href}" controls controlsList="nodownload"></audio>
                        </div>
                    `;
                }
                // 비디오 파일
                else if (fileExt === ".mp4") {
                    container.innerHTML = `
                        <div class="responsive-video">
                            <video src="${link.href}" controls controlsList="nodownload"></video>
                        </div>
                    `;
                }
                // 이미지 파일
                else {
                    container.innerHTML = `
                        <div class="responsive-image">
                            <img src="${link.href}" alt="미디어 콘텐츠" loading="lazy">
                        </div>
                    `;
                }
                
                link.innerHTML = '';
                link.parentNode.replaceChild(container, link);
            }
            // 유튜브 일반 영상 링크 처리
            else if (href.includes("youtube.com/watch?v=")) {
                const videoId = extractYoutubeId(href);
                if (videoId) {
                    const youtubeContainer = document.createElement('div');
                    youtubeContainer.className = 'responsive-youtube';
                    youtubeContainer.innerHTML = `
                        <iframe src="https://www.youtube.com/embed/${videoId}?rel=0" 
                                allowfullscreen loading="lazy"></iframe>
                    `;
                    
                    link.innerHTML = '';
                    link.parentNode.replaceChild(youtubeContainer, link);
                }
            }
            // 유튜브 쇼츠 링크 처리
            else if (href.includes("youtube.com/shorts/")) {
                const videoId = extractYoutubeId(href, true);
                if (videoId) {
                    const shortsContainer = document.createElement('div');
                    shortsContainer.className = 'responsive-youtube-shorts';
                    shortsContainer.innerHTML = `
                        <iframe src="https://www.youtube.com/embed/${videoId}?rel=0&loop=1" 
                                allowfullscreen loading="lazy"></iframe>
                    `;
                    
                    link.innerHTML = '';
                    link.parentNode.replaceChild(shortsContainer, link);
                }
            }
            // 외부 링크는 새 탭에서 열기
            else {
                link.target = "_blank";
                link.rel = "noopener noreferrer"; // 보안 강화
            }
        });
        
        /**
         * 유튜브 비디오 ID 추출
         * @param {string} url - 유튜브 URL
         * @param {boolean} isShorts - 쇼츠 여부
         * @returns {string|null} - 비디오 ID 또는 null
         */
        function extractYoutubeId(url, isShorts = false) {
            let videoId = null;
            
            if (isShorts && url.includes('youtube.com/shorts/')) {
                const match = url.match(/youtube\.com\/shorts\/([a-zA-Z0-9_-]{11})/);
                if (match && match[1]) {
                    videoId = match[1];
                }
            } else if (url.includes('youtube.com/watch?v=')) {
                const match = url.match(/[?&]v=([a-zA-Z0-9_-]{11})/);
                if (match && match[1]) {
                    videoId = match[1];
                }
            } else if (url.includes('youtu.be/')) {
                const match = url.match(/youtu\.be\/([a-zA-Z0-9_-]{11})/);
                if (match && match[1]) {
                    videoId = match[1];
                }
            }
            
            return videoId;
        }
    });
    </script>
    <?php
}
