<?php
function loadEnv($path = G5_PATH . '/.env') {
    if (!file_exists($path)) {
        return;
    }

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue; // 주석은 무시
        if (!strpos($line, '=')) continue; // = 없으면 무시

        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);

        putenv("$name=$value");     // 시스템 환경변수로 설정
        $_ENV[$name] = $value;      // PHP에서 $_ENV로 접근 가능
    }
}