<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

add_stylesheet('<link rel="stylesheet" href="'.$widget_url.'/widget.css">', 0);
// 한국천문연구원_특일 정보 API_KEY를 본인의 키로 변경하세요.
require_once G5_PATH.'/con_env.php';
loadEnv(); // .env 파일 읽기
$apiKey = trim(getenv('KOREA_HOLIDAY_API_KEY')); // 키 가져오기
define('API_URL', 'https://apis.data.go.kr/B090041/openapi/service/SpcdeInfoService');

// 현재 날짜 설정
$currentDate = new DateTime();
$currentYear = $currentDate->format('Y');
$currentMonth = $currentDate->format('n') - 1;
$today = getdate();
$year = isset($_GET['year']) ? (int)$_GET['year'] : $today['year'];
$month = isset($_GET['month']) ? (int)$_GET['month'] : $today['mon'];
$hp_latest_skin = explode("Basic/widget/",$widget_url);
$latest_dir = $hp_latest_skin[1];
$latest_url = $widget_url;

// 월 이동 처리
if (isset($_GET['year']) && isset($_GET['month'])) {
    $currentYear = (int)$_GET['year'];
    $currentMonth = (int)$_GET['month'] - 1;
    if ($currentMonth < 0) {
        $currentMonth = 11;
        $currentYear--;
    } elseif ($currentMonth > 11) {
        $currentMonth = 0;
        $currentYear++;
    }
}

// 특일 정보 가져오기
$holidays = fetchHolidays($currentYear, $currentMonth + 1, $apiKey);

// day/$year.txt 파일에서 사용자 정의 마크 읽기 (줄바꿈으로 구분)
$customMarks = readCustomMarks($currentYear);

// 달력 생성
$calendarHtml = generateCalendar($currentYear, $currentMonth, $holidays, $customMarks, $bo_table, $latest_url);

// API에서 특일 정보 가져오는 함수 (중복 제거 로직 추가)
function fetchHolidays($year, $month, $apiKey) {
    $solYear = $year;
    $solMonth = str_pad($month, 2, '0', STR_PAD_LEFT);
    $holidays = [];
    $dateNames = []; // 중복 체크를 위한 배열

    // API 요청을 수행하는 함수
    function fetchData($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // SSL 검증 비활성화
        curl_setopt($ch, CURLOPT_TIMEOUT, 10); // 요청 시간 초과 설정
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response, true);
    }

    try {
        // 1. 공휴일 정보 가져오기
        $holidaysUrl = API_URL . "/getRestDeInfo?serviceKey=$apiKey&solYear=$solYear&solMonth=$solMonth&_type=json";
        $holidaysData = fetchData($holidaysUrl);

        if (isset($holidaysData['response']['body']['items']['item'])) {
            $items = is_array($holidaysData['response']['body']['items']['item'][0]) ?
                     $holidaysData['response']['body']['items']['item'] :
                     [$holidaysData['response']['body']['items']['item']];

            foreach ($items as $item) {
                $dateKey = $item['locdate'];
                if (!isset($dateNames[$dateKey])) {
                    $item['isHoliday'] = 'Y';
                    $item['dateKind'] = '공휴일';
                    $holidays[] = $item;
                    $dateNames[$dateKey] = true;
                }
            }
        }

        // 2. 기념일 정보 가져오기
        $anniversariesUrl = API_URL . "/getAnniversaryInfo?serviceKey=$apiKey&solYear=$solYear&solMonth=$solMonth&_type=json";
        $anniversariesData = fetchData($anniversariesUrl);

        if (isset($anniversariesData['response']['body']['items']['item'])) {
            $items = is_array($anniversariesData['response']['body']['items']['item'][0]) ?
                     $anniversariesData['response']['body']['items']['item'] :
                     [$anniversariesData['response']['body']['items']['item']];

            foreach ($items as $item) {
                $dateKey = $item['locdate'];
                if (!isset($dateNames[$dateKey])) {
                    $item['isHoliday'] = 'N';
                    $item['dateKind'] = '기념일';
                    $holidays[] = $item;
                    $dateNames[$dateKey] = true;
                }
            }
        }

        // 3. 24절기 정보 가져오기
        $solarTermsUrl = API_URL . "/get24DivisionsInfo?serviceKey=$apiKey&solYear=$year&_type=json";
        $solarTermsData = fetchData($solarTermsUrl);

        if (isset($solarTermsData['response']['body']['items']['item'])) {
            $items = is_array($solarTermsData['response']['body']['items']['item'][0]) ?
                     $solarTermsData['response']['body']['items']['item'] :
                     [$solarTermsData['response']['body']['items']['item']];

            foreach ($items as $item) {
                $termDate = isset($item['locdate']) ? (string)$item['locdate'] : '';
                if (!$termDate) continue;

                $termMonth = (int)substr($termDate, 4, 2);
                if ($termMonth === $month) {
                    $dateKey = $item['locdate'];
                    if (!isset($dateNames[$dateKey])) {
                        $item['isHoliday'] = 'N';
                        $item['dateKind'] = '24절기';
                        $holidays[] = $item;
                        $dateNames[$dateKey] = true;
                    }
                }
            }
        }

        // 4. 잡절 정보 가져오기
        $etcEventsUrl = API_URL . "/getSundryDayInfo?serviceKey=$apiKey&solYear=$year&_type=json";
        $etcEventsData = fetchData($etcEventsUrl);

        if (isset($etcEventsData['response']['body']['items']['item'])) {
            $items = is_array($etcEventsData['response']['body']['items']['item'][0]) ?
                     $etcEventsData['response']['body']['items']['item'] :
                     [$etcEventsData['response']['body']['items']['item']];

            foreach ($items as $item) {
                $eventDate = isset($item['locdate']) ? (string)$item['locdate'] : '';
                if (!$eventDate) continue;

                $eventMonth = (int)substr($eventDate, 4, 2);
                if ($eventMonth === $month) {
                    $dateKey = $item['locdate'];
                    if (!isset($dateNames[$dateKey])) {
                        $item['isHoliday'] = 'N';
                        $item['dateKind'] = '잡절';
                        $holidays[] = $item;
                        $dateNames[$dateKey] = true;
                    }
                }
            }
        }

        return $holidays;
    } catch (Exception $error) {
        error_log('Error fetching data: ' . $error->getMessage());
        return [];
    }
}

// 수정된 readCustomMarks() 함수
function readCustomMarks($year) {
    global $widget_path;
    
    $marks = [];
    $filePath = "day/" . $year . ".txt";
    
    // 1. 파일 존재 여부 체크 (강화)
if (file_exists($filePath)) {
    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (preg_match('/^(\d{4})\|([^|]+)(?:\|(.+))?$/', trim($line), $matches)) {
            $customMarks[$matches[1]] = [
                'symbol' => $matches[2],
                'color' => $matches[3] ?? 'blue'
            ];
        }
    }
}

    // 2. 파일 내용 읽기 (LOCK 추가)
    $content = @file_get_contents($filePath, LOCK_SH);
    if ($content === false) {
        error_log("[Calendar] 파일 읽기 실패: " . $filePath);
        return $marks;
    }

    // 3. 인코딩 변환 (BOM 제거)
    if (substr($content, 0, 3) == "\xEF\xBB\xBF") {
        $content = substr($content, 3);
    }
    $content = mb_convert_encoding($content, 'UTF-8', 'ASCII,UTF-8,EUC-KR,SJIS');

    // 4. 줄 단위 처리 (개선된 방법)
    $lines = array_filter(preg_split("/\r\n|\n|\r/", $content), function($line) {
        return trim($line) !== '';
    });
 
    foreach ($lines as $i => $line) {
        $line = trim($line);
        if (empty($line)) continue;

        // 5. 파이프 분리 (안전한 버전)
        $parts = array_map('trim', explode('|', $line, 3));
        
        // 6. 유효성 검사 강화
        if (count($parts) >= 2 && preg_match('/^(\d{2})(\d{2})$/', $parts[0], $matches)) {
            $month = $matches[1];
            $day = $matches[2];
            
            // 월(01-12), 일(01-31) 유효성 검사
            if ($month >= 1 && $month <= 12 && $day >= 1 && $day <= 31) {
                $marks[$parts[0]] = [
                    'symbol' => $parts[1],
                    'color' => $parts[2] ?? 'blue'
                ];
            }
        }
    }

    // 최종 결과 로깅
    error_log("[Calendar] Parsed Marks: " . json_encode($marks));
    return $marks;
}

// 달력 생성 함수 (색상 강조 개선)
function generateCalendar($year, $month, $holidays, $customMarks, $bo_table, $latest_url) {
    global $schedule_days, $g5, $member;
    $monthNames = ["1월", "2월", "3월", "4월", "5월", "6월", 
                   "7월", "8월", "9월", "10월", "11월", "12월"];

    $eventsByDate = [];
    foreach ($holidays as $event) {
        $date = isset($event['locdate']) ? (string)$event['locdate'] : '';
        if (!$date) continue;

        $formattedDate = substr($date, 0, 4) . '-' . substr($date, 4, 2) . '-' . substr($date, 6, 2);
        $eventsByDate[$formattedDate] = $event;
    }

    $firstDay = new DateTime("$year-" . ($month + 1) . "-01");
    $lastDay = new DateTime($firstDay->format('Y-m-t'));
    $lastDayOfMonth = (int)$lastDay->format('d'); // <-- 마지막 일자 가져오기

    $today = new DateTime();
    $isCurrentMonth = $today->format('Y') == $year && $today->format('n') == ($month + 1);

    $html = '<div class="days">';

    // 빈 칸 추가
    for ($i = 0; $i < $firstDay->format('w'); $i++) {
        $html .= '<div class="day empty"></div>';
    }

    // 스케줄 데이터 배열 초기화
    $html_day = [];

    // 스케줄 wr_1, wr_2 범위 내 날짜 수집
    $targetMonth = sprintf("%02d", $month + 1);
    $sel_month = $year . $targetMonth;
    $query = "SELECT * FROM {$g5['write_prefix']}{$bo_table} 
              WHERE LEFT(wr_1, 6) <= '{$sel_month}' 
                AND LEFT(wr_2, 6) >= '{$sel_month}' 
              ORDER BY wr_id ASC";

    $result = sql_query($query);

    while ($row = sql_fetch_array($result)) {
        if ($row['mb_id'] != $member['mb_id']) continue;

        $start_day = (substr($row['wr_1'], 0, 6) < $sel_month) ? 1 : (int)substr($row['wr_1'], 6, 2);
        $end_day = (substr($row['wr_2'], 0, 6) > $sel_month) ? $lastDayOfMonth : (int)substr($row['wr_2'], 6, 2);

        for ($i = $start_day; $i <= $end_day; $i++) {
            $html_day[$i] = true;
        }
    }

    // 날짜 출력 루프
    for ($day = 1; $day <= $lastDayOfMonth; $day++) {
        $date = new DateTime("$year-" . ($month + 1) . "-$day");
        $dateString = $date->format('Y-m-d');
        $dayKey = $date->format('md');
        $event = $eventsByDate[$dateString] ?? null;
        $dayClass = 'day';
        $dayStyle = '';

        // 요일 색상
        if ($date->format('w') == 0) $dayStyle = 'color:#cc3366;';
        elseif ($date->format('w') == 6) $dayStyle = 'color:#3366cc;';

        // 공휴일 강조
        if ($event && $event['isHoliday'] === 'Y') {
            $dayStyle = 'color:#cc3366;';
            $dayClass .= ' holiday';
        }

        // 오늘 날짜 강조
        if ($isCurrentMonth && $day == $today->format('d')) {
            $dayClass .= ' today';
        }

        // 날짜 셀 시작
        $html .= "<div class=\"$dayClass\" style=\"$dayStyle\">";

        // 사용자 정의 마크
        if (!empty($customMarks[$dayKey])) {
            $mark = $customMarks[$dayKey];
            $color = ($mark['color'] === 'red') ? '#cc3366' : '#3366cc';
            $html .= "<span class=\"custom-mark\" style=\"color:{$color}\">{$mark['symbol']}</span>";
        }

        // 스케줄 링크 or 날짜만 표시
        $latest_dir = explode("Basic/widget/",$latest_url)[1];
        if (isset($html_day[$day])) {
            $html .= "<p><a href=\"javascript:popup_window('{$latest_url}/pop_schedule.php?bo_table={$bo_table}&year={$year}&month=" . ($month+1) . "&day={$day}&latest_dir={$latest_dir}', '{$latest_dir}', 'left=50, top=50, width=320, height=400, scrollbars=0');\" class=\"writeday\" title=\"일정팝업보기\">{$day}</a>";
        } else {
            $title = !empty($event['dateName']) ? "title=\"{$event['dateName']}\"" : "";
            $html .= "<div class=\"day-number\" $title>$day</div>";
        }

        // 공휴일/기념일 텍스트
        if (!empty($event)) {
            $eventClass = 'event ';
            switch ($event['dateKind']) {
                case '공휴일': $eventClass .= 'public-holiday'; break;
                case '기념일': $eventClass .= 'anniversary'; break;
                case '24절기': $eventClass .= 'solar-term-event'; break;
                case '잡절': $eventClass .= 'other-event'; break;
            }
            $html .= "<div class=\"$eventClass\" $title>{$event['dateName']}</div>";
        }

        $html .= '</p></div>'; // 날짜 셀 닫기
    }

    // 마지막 주 빈 칸 채우기
    $remainingDays = 6 - $lastDay->format('w');
    for ($i = 0; $i < $remainingDays; $i++) {
        $html .= '<div class="day empty"></div>';
    }

    $html .= '</div>';
    return $html;
}
?>

<div class="calendar-container">

<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr>
    <td align="center" style="background:rgba(0,0,255,0.1); text-align:center">
    <table border="0" cellspacing="0" cellpadding="0" align="center">
        <tr>
            <td width="56" style="font-size: 5px;padding-top: 10px">
                <font color='red'>⚉ 미휴</font> 
                <font color='black'><br><p style='margin-top:2px'>● 무재</p></font>
            </td>
            <td width="20" align="right">
                <a href="<?php echo $_SERVER['PHP_SELF']."?bo_table=".$bo_table."&"; 
                $year_pre = ($month == 1) ? ($year - 1) : $year;
                $month_pre = ($month == 1) ? 12 : ($month - 1);
                echo "year=$year_pre&month=$month_pre"; ?>">
                    <img src="<?php echo $widget_url; ?>/img/month_prev.png" border="0" alt="<?php echo $month_pre.'월 '?>">
                </a>
            </td>
            <td width="" align="center" style="padding:0 5px;line-height:27px;font-size:12px">
                <a href="<?php echo G5_URL; ?>/<?php echo $bo_table; ?>" style="color:#808080;" onfocus="this.blur()" title="일정관리 바로가기">
                    <b><?php echo $year.'년 '?> <?php echo $month.'월 '?></b>
                </a>
            </td>
            <td width="20" align="left">
                <a href="<?php echo $_SERVER['PHP_SELF']."?bo_table=".$bo_table."&"; 
                $year_next = ($month == 12) ? ($year + 1) : $year;
                $month_next = ($month == 12) ? 1 : ($month + 1);
                echo "year=$year_next&month=$month_next"; ?>">
                    <img src="<?php echo $widget_url ?>/img/month_next.png" border="0" alt="<?php echo $month_next.'월 '?>">
                </a>
            </td>
            <td width="56" style="font-size: 4px"></td>
        </tr>
    </table>
    </td>
</tr>
</table>

    <div class="days-of-week">
        <div style="color:#cc3366">일</div>
        <div>월</div>
        <div>화</div>
        <div>수</div>
        <div>목</div>
        <div>금</div>
        <div style="color:#3366cc">토</div>
    </div>

    <?= $calendarHtml ?>

<div style="background:rgba(250,250,250,0.3)">
    <!--행사 예정 뽑아오기 시작-->
    <?php
    global $member;
    $limit  = '5';
    $todays = date('Ymd');
    $qry = "select  * from ".$g5['write_prefix'].$bo_table." where $todays <= wr_1 or $todays <= wr_2 order by wr_1 ASC LIMIT 0, $limit";
    $result1 = sql_query($qry);
    for ($i=0; $row = sql_fetch_array($result1); $i++)if($row['mb_id'] == $member['mb_id']){
        $SUBJECT = $row['wr_subject'];
        $S_Year  = substr($row['wr_1'], 0, 4);
        $S_MON   = substr($row['wr_1'], 4, 2);
        $S_Date  = substr($row['wr_1'], 6, 2);
        echo "";
        echo "<img src='{$widget_url}/img/mini00.png' align='absmiddle' alt='' />";
        echo "<a href=\"javascript:popup_window('".$widget_url."/pop_schedule.php?bo_table=".$bo_table."&year=".$S_Year."&month=".number_format($S_MON)."&day=".number_format($S_Date)."&latest_dir=".$latest_dir."', 'schedule', 'left=0, top=0, width=600, height=600, scrollbars=1');\" class=writedayoo>";
        if (isset($row['is_notice01']))
            if ($row['wr_1']==$row['wr_2'])
                echo "<font style='font-family:돋움; font-size:11px; color:#2C88B9;'> $SUBJECT <lii style='float:right;padding:3px 5px 0 0'>".substr($row['wr_1'],4,2).'.'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'.'.substr($row['wr_2'],6,2)."</lii></font>";
            else
                echo "<font style='font-family:돋움; font-size:11px; color:#2C88B9;'> $SUBJECT <lii style='float:right;padding:3px 5px 0 0'>".substr($row['wr_1'],4,2).'.'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'.'.substr($row['wr_2'],6,2)."</lii></font>";
        else
        if ($row['wr_1']==$row['wr_2'])
            echo "<font style='font-family:돋움; font-size:11px; color:#2C88B9;'> $SUBJECT <lii style='float:right;padding:3px 5px 0 0'>".substr($row['wr_1'],4,2).'.'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'.'.substr($row['wr_2'],6,2)."</lii></font>";
        else
            echo "<font style='font-family:돋움; font-size:11px; color:#2C88B9;'> $SUBJECT <lii style='float:right;padding:3px 5px 0 0'>".substr($row['wr_1'],4,2).'.'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'.'.substr($row['wr_2'],6,2)."</lii></font>";
        echo "</a><br>";

        if (isset($row['comment_cnt']))
            echo " <a href=\"{$row['comment_href']}\"><span style='font-family:돋움; font-size:11px; color:#2C88B9;'>{$row['comment_cnt']}</span></a>";
    }
    ?>
    <!--행사 예정 뽑아오기 끝-->
</div>
</div>