<?php
$sub_menu = '300900';
include_once('./_common.php');

check_demo();

auth_check_menu($auth, $sub_menu, 'r');

$g5['title'] = '아이콘 선택기';
include_once ('./admin.head.php');
?>
<style>
.d-flex {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
}

.justify-content-center {
    -webkit-box-pack: center;
    -ms-flex-pack: center;
    justify-content: center;
}

.text-center {
  text-align: center;
}

.icon_picker pre {
    padding: 1rem;
    background: #eee;
    margin: 0 auto 60px;
    overflow: auto;
}

.icon_picker h2 {
    font-size: 18px; margin: 14px 0px; font-weight: 500; line-height: 1.6; vertical-align: baseline;
}

.icon_picker li a {
	box-sizing: border-box; background: 0px 0px; color: rgb(11, 145, 234); text-decoration-line: none; cursor: pointer; margin: 0px; padding: 0px; border: 0px; vertical-align: baseline;
}

.demo-output {
    -webkit-transform-origin: center center;
    transform-origin: center center;
    -webkit-transform: scale(1);
    transform: scale(1);
    margin: 60px auto;
	font-size: 0.875rem;
}

.demo-output.hidden {
    opacity: 0;
    -webkit-transform: scale(0);
    transform: scale(0);
	margin: 0px;
}

.demo-output-icon {
    margin-top: 60px;
    text-align: center;
}

.demo-output-icon i {
    font-size: 8rem !important;
}

</style>
<div class="local_desc01 local_desc">
    <p>
        Font Awesome, Material Icons, Bootstrap Icons 등 아이콘 선택 도구입니다.<br>
        JSON 및 스타일시트에서 아이콘 데이터를 가져와 사용자가 원하는 아이콘을 쉽고 빠르게 찾을 수 있도록 팝업을 표시합니다.
    </p>
</div>
<div class="local_ov01 local_ov">
    <div class="container icon_picker">

		<div class="sch_last">
			<select name="icon-library-select">
				<optgroup label="Font Awesome">
					<option value="font-awesome" data-css="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" selected="selected">Font Awesome (all)</option>
					<option value="font-awesome-solid" data-css="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">Font Awesome Solid</option>
					<option value="font-awesome-regular" data-css="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">Font Awesome Regular</option>
					<option value="font-awesome-brands" data-css="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">Font Awesome Brands</option>
				</optgroup>

				<optgroup label="Material Icons">
					<option value="material-icons-filled" data-css="https://fonts.googleapis.com/css2?family=Material+Icons">Material Icons Filled</option>
					<option value="material-icons-outlined" data-css="https://fonts.googleapis.com/css2?family=Material+Icons+Outlined">Material Icons Outlined</option>
					<option value="material-icons-round" data-css="https://fonts.googleapis.com/css2?family=Material+Icons+Round">Material Icons Round</option>
					<option value="material-icons-sharp" data-css="https://fonts.googleapis.com/css2?family=Material+Icons+Sharp">Material Icons Sharp</option>
					<option value="material-icons-two-tone" data-css="https://fonts.googleapis.com/css2?family=Material+Icons+Two+Tone">Material Icons Two-tone</option>
				</optgroup>

				<optgroup label="Other libraries">
					<option value="bootstrap-icons" data-css="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">Bootstrap Icons</option>
					<option value="elegant-icons" data-css="elegant-icons.min.css">Elegant Icons</option>
					<option value="feather-icons" data-css="feather-icons.min.css">Feather Icons</option>
					<option value="fomantic-ui" data-css="fomantic-ui-icons.min.css">Fomantic UI</option>
					<option value="foundation-icons" data-css="foundation-icons.min.css">Foundation Icons</option>
					<option value="happy-icons" data-css="happy-icons.min.css">Happy Icons</option>
					<option value="icomoon" data-css="icomoon.min.css">Icomoon</option>
					<option value="open-iconic" data-css="open-iconic.min.css">Open-iconic</option>
					<option value="tabler-icons" data-css="tabler-icons.min.css">Tabler Icons</option>
					<option value="weather-icons" data-css="weather-icons.min.css">Weather Icons</option>
					<option value="zondicons" data-css="zondicons.min.css">Zondicons</option>
				</optgroup>
			</select>
			<button id="uip-select-btn" class="btn_03 btn">아이콘 라이브러리를 열려면 클릭하세요.</button>
			<button id="uip-reset-btn" class="btn_01 btn">Reset</button>
		</div>

        <div class="demo-output hidden" id="output">
            <pre><code class="demo-output-json" id="output-json"></code></pre>
            <div class="demo-output-icon" id="output-icon"></div>
        </div>

		<h2>아이콘 라이브러리:</h2>
		<div class="local_desc01 local_desc">
			<ol>
				<li><a href="https://fontawesome.com/" target="_blank" rel="nofollow noreferrer noopener">Font Awesome (All, Solid, Regular, Brands)</a></li>
				<li><a href="https://www.google.com/design/icons/" rel="nofollow" target="_blank">Material Icons (Filled, Outlined, Round, Sharp, Two-tone)</a></li>
				<li><a href="https://icons.getbootstrap.com/" target="_blank" rel="nofollow noreferrer noopener">Bootstrap Icons</a></li>
				<li><a href="https://www.elegantthemes.com/blog/resources/elegant-icon-font" target="_blank" rel="nofollow noreferrer noopener">Elegant Icons</a></li>
				<li><a href="https://feathericons.com/" rel="nofollow" target="_blank">Feather Icons</a></li>
				<li><a href="https://zurb.com/playground/foundation-icon-fonts-3" target="_blank" rel="nofollow noreferrer noopener">Foundation Icons</a></li>
				<li><a href="https://icomoon.io/" target="_blank" rel="nofollow noreferrer noopener">Icomoon</a></li>
				<li><a href="https://useiconic.com/open" target="_blank" rel="nofollow noreferrer noopener">Open-iconic</a></li>
				<li><a href="https://tablericons.com/" target="_blank" rel="nofollow noreferrer noopener">Tabler Icons</a></li>
				<li><a href="https://github.com/erikflowers/weather-icons" target="_blank" rel="nofollow noreferrer noopener">Weather Icons</a></li>
				<li><a href="https://www.zondicons.com/" target="_blank" rel="nofollow noreferrer noopener">Zondicons</a></li>
				<li><a href="https://fomantic-ui.com/elements/icon.html" target="_blank" rel="nofollow noreferrer noopener">Fomantic UI icons</a></li>
			</ol>
		</div>

    </div>

    <script src="assets/js/universal-icon-picker.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function(event) {
            const $selectElement  = document.querySelector('select[name ="icon-library-select"]');

            // create the Universal Icon Picker
            const uip = new UniversalIconPicker('#uip-select-btn', {
                resetSelector: '#uip-reset-btn',
                mode: 'onrequest',
                onSelect: function(jsonIconData) {
                    document.getElementById('output-json').innerHTML = JSON.stringify(jsonIconData, null, 4);
                    document.getElementById('output-icon').innerHTML = jsonIconData.iconHtml;
                    document.getElementById('output').classList.remove('hidden');
                },
                onReset: function() {
                    document.getElementById('output-json').innerHTML = '';
                    document.getElementById('output-icon').innerHTML = '';
                    document.getElementById('output').classList.add('hidden');
                }
            });

            $selectElement.addEventListener('change', () => {
                let currentIconLibrary = $selectElement.value,
                currentIconLibraryCss = $selectElement.options[$selectElement.selectedIndex].dataset.css;
                uip.setOptions({
                    iconLibraries: [ currentIconLibrary + '.min.json' ],
                    iconLibrariesCss: [currentIconLibraryCss]
                });
            });
            const evt = new Event('change');
            $selectElement.dispatchEvent(evt);
        });
    </script>
</div>



<?php
include_once ('./admin.tail.php');