<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 설정값 초기화
$cellh = 21; $cellw = 42;
if (!empty($options)) list($n_table_width, $cellw, $cellh) = explode(",", $options);

// 날짜 정보
$today = getdate();
$year = isset($_GET['year']) ? (int)$_GET['year'] : $today['year'];
$month = isset($_GET['month']) ? (int)$_GET['month'] : $today['mon'];

// 기념일 데이터 가져오기 함수 수정
function get_anniversaries($year, $skin_path) {
    $file = $skin_path.'/day/'.$year.'.txt';
    $holidays = ["새해첫날", "대체공휴일", "임시공휴일", "설날", "설날연휴", "삼일절", "추석", "추석연휴", "어린이날", "부처님오신날", "현충일", "광복절", "개천절", "한글날", "성탄절", "21대 대통령선거"];

    $data = array();
    if (file_exists($file)) {
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach($lines as $line) {
            $line = trim($line);
            if (preg_match('/^(\d{2})(\d{2})\|(.+)\|$/', $line, $matches)) {
                $month_day = $matches[1].$matches[2]; // MMDD 형식
                $content = $matches[3];

                // 모든 공휴일 검사 (중복 허용)
                $included_holidays = array();
                foreach ($holidays as $holiday) {
                    if (strpos($content, $holiday) !== false) {
                        $included_holidays[] = $holiday;
                        $content = str_replace($holiday, '', $content); // 찾은 공휴일은 제거
                    }
                }

                $data[$month_day] = array(
                    'symbol' => trim($content),
                    'is_red' => !empty($included_holidays),
                    'holidays' => $included_holidays // 배열로 저장
                );
            }
        }
    }
    return $data;
}

$anniversaries = get_anniversaries($year, $latest_skin_path);

// 스케줄 데이터
$schedule_days = array();
$sql = "SELECT wr_1, wr_2, mb_id FROM ".$g5['write_prefix'].$bo_table." WHERE LEFT(wr_1,6) <= '".$year.sprintf("%02d",$month)."' AND LEFT(wr_2,6) >= '".$year.sprintf("%02d",$month)."'";
$result = sql_query($sql);
while($row = sql_fetch_array($result)) {
    if($row['mb_id'] == $member['mb_id']) {
        $start = max(1, (int)substr($row['wr_1'],6,2));
        $end = min(date('t', mktime(0,0,0,$month,1,$year)), (int)substr($row['wr_2'],6,2));
        for($iz=$start; $iz<=$end; $iz++) $schedule_days[$iz] = true;
    }
}

// 달력 생성
$lastday = date('t', mktime(0,0,0,$month,1,$year));
$firstday = date('w', mktime(0,0,0,$month,1,$year));
?>

<style type="text/css">
td.title    {text-align: center; padding-top: 1px; padding-bottom: 1px; height: 25px; font-weight:bold;}
td.invalid  {
    text-align: center; padding-top: 2px; height:<?php echo $cellh; ?>px; width:<?php echo $cellw; ?>px;
}

td.valid    {
    text-align: center; padding-top: 2px; height:<?php echo $cellh; ?>px; width:<?php echo $cellw; ?>px;
}

td.today    {
    text-align: center; padding-top: 2px; height:<?php echo $cellh ?>px; width:<?php echo $cellw; ?>px;
    background: rgba(0,0,255,0.1);
}

.bgsun    {text-align: center; font-size: 11px; color: #cc3366; padding-top: 2px; height:<?php echo $cellh; ?>px; width:<?php echo $cellw; ?>px;
    background: url(<?php echo $latest_skin_url; ?>/img/mini.gif) no-repeat bottom;
}
.bgsat  {text-align: center; font-size: 11px; color: #3366cc; padding-top: 2px; height:<?php echo $cellh?>px; width:<?php echo $cellw; ?>px;
    background: url(<?php echo $latest_skin_url; ?>/img/mini.gif) no-repeat bottom;
}
.bgweek   {text-align: center; font-size: 11px; color: #808080; padding-top: 2px; height:<?php echo $cellh?>px; width:<?php echo $cellw; ?>px;
    background: url(<?php echo $latest_skin_url; ?>/img/mini.gif) no-repeat bottom;
}

p.title     {font-size: 1em; font-weight:bold}
p.sunday    {text-align: center; font-size: 11px; color: #cc3366;}
p.saturday  {text-align: center; font-size: 11px; color: #3366CC;}
p.weekday   {text-align: center; font-size: 11px; color: #808080;}
p a:link.writeday, p a:visited.writeday {font-weight:bold;text-align: center; font-size:12px;color:#6a00ff;}
img {border:0}
.anniversary-mark {position:absolute;display:inline-block;font-size:4px;color:#666;vertical-align:top;}
.red-day {color:#cc3366!important;cursor:help;}
</style>

<?php
$hp_latest_skin = explode("skin/latest/",$latest_skin_url);
$latest_dir = $hp_latest_skin[1];
$today = getdate(); 
$b_mon = $today['mon']; 
$b_day = $today['mday']; 
$b_year = $today['year']; 

if (isset($year) < 1) {
   $month = $b_mon;
   $mday = $b_day;
   $year = $b_year;
}

if (isset($_GET['year'])) {
    $year = $_GET['year'];
}
if (isset($_GET['month'])) {
    $month = $_GET['month'];
}

$lastday=array(0,31,28,31,30,31,30,31,31,30,31,30,31);
if ($year%4 == 0) $lastday[2] = 29;
$dayoftheweek = date("w", mktime (0,0,0,$month,1,$year));
?>

<div style="background: rgba(255,255,255,0.1);margin:0 auto;border-top:solid 1px #adb5c1; border-left:solid 1px #adb5c1; border-right:solid 1px #adb5c1;border-bottom:solid 1px #adb5c1;width:100%;">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr>
    <td align="center" style="background:rgba(0,0,255,0.1); text-align:center">
    <table border="0" cellspacing="0" cellpadding="0" align="center">
        <tr><td width="56" style="font-size: 5px;padding-right:10px"><font color='red'>⚉ 미휴</font> <font color='black'>● 무재</font></td>
            <td width="20" align="right"><a href="<?php echo $_SERVER['PHP_SELF']."?bo_table=".$bo_table."&"; ?><?php if ($month == 1) { $year_pre=$year-1; $month_pre=12; } else {$year_pre=$year; $month_pre=$month-1;} echo ("year=$year_pre&month=$month_pre");?>"><img src="<?php echo $latest_skin_url; ?>/img/month_prev.png" border="0" alt="<?php echo $month_pre.'월 '?>"></a></td>
            <td width="" align="center" style="padding:0 5px;line-height:27px;"><a href="<?php echo G5_URL; ?>/<?php echo $bo_table; ?>" style="color:#808080;" onfocus="this.blur()" title="일정관리 바로가기"><b><?php echo $year.'년'?> <?php echo $month.'월 '?></b></a></td>
            <td width="20" align="left"><a href="<?php echo $_SERVER['PHP_SELF']."?bo_table=".$bo_table."&"; ?><?php if ($month == 12) { $year_pre=$year+1; $month_pre=1; } else {$year_pre=$year; $month_pre=$month+1;} echo ("year=$year_pre&month=$month_pre");?>"><img src="<?php echo $latest_skin_url ?>/img/month_next.png" border="0" alt="<?php echo $month_pre.'월 '?>"></a></td><td width="56" style="font-size: 4px"></td>
        </tr>
    </table>
    </td>
</tr>
</table>
    
    <div style="margin-bottom:0px; padding:7px 0; border-top:solid 1px #adb5c1; border-bottom:solid 0px #adb5c1;">
        <table width="100%" cellSpacing="0" cellPadding="0" border="0" align="center">
            <tr>
                <td align="center" class="bgsun">일</td>
                <td align="center" class="bgweek">월</td>
                <td align="center" class="bgweek">화</td>
                <td align="center" class="bgweek">수</td>
                <td align="center" class="bgweek">목</td>
                <td align="center" class="bgweek">금</td>
                <td align="center" class="bgsat">토</td>
            </tr>
            <tr>
                <td colspan="7" bgcolor="#DDDDDD"></td>
            </tr>
            <?php
            $cday = 1;
            $sel_mon['i'] = sprintf("%02d",$month);
            $query = "select * from ".$g5['write_prefix'].$bo_table." where left(wr_1,6) <= '".$year.$sel_mon['i']."' and left(wr_2,6) >= '".$year.$sel_mon['i']."' order by wr_id asc";
            $result = sql_query($query);

            // 내용을 보여주는 부분
            while ($row = sql_fetch_array($result))if($row['mb_id'] == $member['mb_id']){  // 제목글 뽑아서 링크 문자열 만들기..
                if( substr($row['wr_1'],0,6) < $year.$sel_mon['i'] ) {
                    $start_day['i'] =1; 
                    $start_day['i']= (int)$start_day['i'];
                } else {
                    $start_day['i'] = substr($row['wr_1'],6,2);
                    $start_day['i']= (int)$start_day['i'];
                }

                if( substr($row['wr_2'],0,6) > $year.$sel_mon['i'] ) {
                    $end_day['i'] = $lastday[$month];
                    $end_day['i']= (int)$end_day['i'];
                } else {
                    $end_day['i'] = substr($row['wr_2'],6,2);
                    $end_day['i']= (int)$end_day['i'];
                }

                for ($i = $start_day['i'] ; $i <= $end_day['i'];  $i++) {
                    $html_day[$i] = "1";
                }
            }

            // 달력의 틀을 보여주는 부분
            $temp = 7- (($lastday[$month]+$dayoftheweek)%7);
            if ($temp == 7) $temp = 0;
            $lastcount = $lastday[$month]+$dayoftheweek + $temp;

            for ($iz = 1; $iz <= $lastcount; $iz++) {
                if ($dayoftheweek < $iz  &&  $iz <= $lastday[$month]+$dayoftheweek) {
                    // 기념일 정보 확인
                    $mmdd = sprintf("%02d%02d", $month, $cday);
                    $anniversary = isset($anniversaries[$mmdd]) ? $anniversaries[$mmdd] : null;

                    $is_today = ($year==$today['year'] && $month==$today['mon'] && $cday==$today['mday']);
                    $is_red_day = ($anniversary && $anniversary['is_red']);
                    $symbol = ($anniversary && $anniversary['symbol']) ? $anniversary['symbol'] : '';
                    $holiday_info = ($anniversary && !empty($anniversary['holidays'])) ? implode(", ", $anniversary['holidays']) : '';

                    if ($b_year==$year && $b_mon==$month && $b_day==$cday) {
                        $cstyle = 'today';
                    } else {
                        $cstyle = 'valid';
                    }

                    switch ($iz%7) {// 요일에 따라 날짜의 색깔 결정
                        case 1: $dstyle = 'sunday'; break;
                        case 0: $dstyle = 'saturday'; break;
                        default: $dstyle = 'weekday';
                    }
                    // 빨간 날짜 처리
                    $day_class = $dstyle;
                    $title_attr = '';
                    if ($is_red_day) {
                        $day_class .= ' red-day';
                        $title_attr = $holiday_info ? 'title="'.$holiday_info.'"' : '';
                    }

                    $daytext = $cday;   // 날짜 숫자
                    if ($iz%7 == 1 && !$is_red_day) $daytext = "<font color=#cc3366>$daytext</font>"; // 일요일
                    if ($iz%7 == 0 && !$is_red_day) $daytext = "<font color=#3366CC>$daytext</font>"; // 토요일

                    echo ("<td class='".$cstyle."'>");
                    if (isset($html_day[$cday])) {
                        $f_date = $year.sprintf("%02d",$month).sprintf("%02d",$cday);
                        echo "<p><a href=\"javascript:popup_window('".$latest_skin_url."/pop_schedule.php?bo_table=".$bo_table."&year=".$year."&month=".$month."&day=".$cday."&latest_dir=".$latest_dir."', 'schedule', 'left=50, top=50, width=320, height=400, scrollbars=0');\" class=\"writeday\" title=".__('일정팝업보기').">".$daytext."</a></pp>";
                    }
                    else { // 글쓰기 권한이 없으면 글쓰기 링크는 넣지 않고 그냥 숫자만 출력하기 
                        echo "<p class='".$day_class."' ".$title_attr.">".$daytext;
                    }

                    // 기념일 표시
                    if($symbol) {
                        echo '<span class="anniversary-mark">'.$symbol.'</span></p>';
                    }
                    echo ("</td>\n");  // 한칸을 마무리
                    $cday++; // 날짜를 카운팅
                }
                // 빈 셀 처리
                else {
                    echo ("<td class='invalid'>&nbsp;</td>\n");
                }

                if (($iz%7) == 0) echo ("</tr>\n");
            }
            ?>
        </table>
    </div>

<div style="background:rgba(250,250,250,0.3)">
    <!--행사 예정 뽑아오기 시작-->
    <?php
    $new_date = date('Y-m-d',time()); //오늘 날짜
    $years  = date('Y');  // 2000
    $months = date('m');  // 1, 2, 3, ..., 12
    $days     = date('d');  // 1, 2, 3, ..., 31
    $limit = '5';
    $today_row = date('Ymd');
    $qry  = "select  * from ".$g5['write_prefix'].$bo_table." where $today_row <= wr_1 or $today_row <= wr_2 order by wr_1 ASC LIMIT 0, $limit";
    $result1 = sql_query($qry);
    for ($i=0; $row = sql_fetch_array($result1); $i++)if($row['mb_id'] == $member['mb_id']){
        $OID = $row['wr_id'];
        $SUBJECT = $row['wr_subject'];
        $S_Year  = substr($row['wr_1'], 0, 4);
        $S_MON   = substr($row['wr_1'], 4, 2);
        $S_Date  = substr($row['wr_1'], 6, 2);
        $E_MON   = substr($row['wr_2'], 4, 2);
        $E_Date  = substr($row['wr_2'], 6, 2);

        echo "";
        echo "<img src='{$latest_skin_url}/img/mini00.png' align='absmiddle' alt='' />";
        echo isset($row['icon_reply']) . " ";
        echo "<a href=\"javascript:popup_window('".$latest_skin_url."/pop_schedule.php?bo_table=".$bo_table."&year=".$S_Year."&month=".number_format($S_MON)."&day=".number_format($S_Date)."&latest_dir=".$latest_dir."', 'schedule', 'left=0, top=0, width=600, height=600, scrollbars=1');\" class=writedayoo>";
        if (isset($row['is_notice01']))
            if ($row['wr_1']==$row['wr_2'])
                echo "<font style='font-weight:bold;font-family:돋움; font-size:12px; color:#2C88B9;'> $SUBJECT </font><lii style='float:right;padding-right:5px'>".substr($row['wr_1'],4,2).'/'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'/'.substr($row['wr_2'],6,2)."</lii>";
            else
                echo "<font style='font-weight:bold;font-family:돋움; font-size:12px; color:#2C88B9;'> $SUBJECT </font><lii style='float:right;padding-right:5px'>".substr($row['wr_1'],4,2).'/'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'/'.substr($row['wr_2'],6,2)."</lii>";
        else
        if ($row['wr_1']==$row['wr_2'])
            echo "<font style='font-weight:bold;font-family:돋움; font-size:12px; color:#6A6A6A;'> $SUBJECT </font><lii style='float:right;padding-right:5px'>".substr($row['wr_1'],4,2).'/'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'/'.substr($row['wr_2'],6,2)."</lii>";
        else
            echo "<font style='font-weight:bold;font-family:돋움; font-size:12px; color:#6A6A6A;'> $SUBJECT </font><lii style='float:right;padding-right:5px'>".substr($row['wr_1'],4,2).'/'.substr($row['wr_1'],6,2).' ~ '.substr($row['wr_2'],4,2).'/'.substr($row['wr_2'],6,2)."</lii>";
        echo "</a>";

        if (isset($row['comment_cnt']))
            echo " <a href=\"{$row['comment_href']}\"><span style='font-family:돋움; font-size:11px; color:#9A9A9A;'>{$row['comment_cnt']}</span></a>";
    }
    ?>
    <!--행사 예정 뽑아오기 끝-->
</div>
</div>
